package at.tugraz.genome.dbutilities;

import java.util.Vector;
/**
 * <p>Title: MARS EJB</p>
 * <p>Description: Microarray Analysis and Retrieval System</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: genome.tugraz.at</p>
 * @author Robert Molidor
 * @version 1.0
 */

public class SearchableField extends DatabaseTableField {
  private String operator_ = null;
  private String searchValue_ = null;
  private String additionalWhereClause = null;


  public SearchableField(String dbTableName,
                         String dbFieldName,
                         String dbFieldDisplayName,
                         boolean fake,
                         String operator,
                         String searchValue) {
    super(dbTableName, dbFieldName, dbFieldDisplayName, fake);
    operator_ = operator;
    searchValue_ = searchValue;
  }

  public SearchableField(String dbTableName,
                         String dbTableAlias,
                         String dbFieldName,
                         String dbFieldDisplayName,
                         boolean fake,
                         String operator,
                         String searchValue) {
    super(dbTableName, dbTableAlias, dbFieldName, dbFieldDisplayName, fake);
    operator_ = operator;
    searchValue_ = searchValue;
  }



  public SearchableField(String dbTableName,
                         String dbFieldName,
                         String dbFieldDisplayName,
                         boolean fake,
                         String fakeDBTableField,
                         String fakeTableName,
                         String fakeTableConnectorFieldName,
                         String fakeOrderByField,
                         String operator,
                         String searchValue) {
    super(dbTableName, dbFieldName, dbFieldDisplayName, fake, fakeDBTableField, fakeTableName, fakeTableConnectorFieldName, fakeOrderByField);
    operator_ = operator;
    searchValue_ = searchValue;
  }

  public SearchableField(String dbTableName,
                         String dbTableAlias,
                         String dbFieldName,
                         String dbFieldDisplayName,
                         boolean fake,
                         String fakeDBTableField,
                         String fakeTableName,
                         String fakeTableAlias,
                         String fakeTableConnectorFieldName,
                         String fakeOrderByField,
                         String operator,
                         String searchValue) {
    super(dbTableName, dbTableAlias, dbFieldName, dbFieldDisplayName, fake, fakeDBTableField, fakeTableName, fakeTableAlias, fakeTableConnectorFieldName, fakeOrderByField);
    operator_ = operator;
    searchValue_ = searchValue;
  }

  /**
   * This method allows to search in combination with other database fields
   * @param dbField the other database table field
   * @param operator the operator (=,>,<,..)
   * @param searchValue the value to search for
   * @author Juergen Hartler
   */
  public SearchableField(DatabaseTableField dbField,
                         String operator,
                         String searchValue) {
    super(dbField.getDBTableName(),
          dbField.getDBTableAlias(),
          dbField.getDBFieldName(),
          dbField.getDBFieldDisplayName(),
          dbField.isFake(),
          dbField.getFakeDBTableField(),
          dbField.getFakeTableName(),
          dbField.getFakeTableAlias(),
          dbField.getFakeTableConnectorFieldName(),
          dbField.getFakeOrderByField(),
          new Vector(dbField.getANDCombinedFields()),
          new Vector(dbField.getORCombinedFields()));
    this.setDbField(dbField);

    setFakeTableAliases(dbField.getFakeTableAliases());
    setFakeTableNames(dbField.getFakeTableNames());
    setSQLSubStatement(dbField.getSQLSubStatement());
    setKey(dbField.getKey());
    operator_ = operator;
    searchValue_ = searchValue;
    super.setAdditionalTablesVector(dbField.getAdditionalTablesVector());
  }

  public void setOperator(String operator) {
    operator_ = operator;
  }

  public String getOperator() {
    return operator_;
  }

  public void setSearchValue(String value) {
    searchValue_ = value;
  }

  public String getSearchValue() {
    return searchValue_.replaceAll("\'","\'\'");
  }

  public String getAdditionalWhereClause() {
	return additionalWhereClause;
  }

  public void setAdditionalWhereClause(String additionalWhereClause) {
	this.additionalWhereClause = additionalWhereClause;
  }



}