package at.tugraz.genome.dbutilities;

import at.tugraz.genome.dbutilities.exception.IteratorException;

import java.io.Serializable;
import java.util.*;

import org.apache.log4j.Logger;

/**
 * <p>
 * Title: MARS EJB
 * </p>
 * <p>
 * Description: Microarray Analysis and Retrieval System
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: genome.tugraz.at
 * </p>
 * 
 * @author Robert Molidor
 * @version 2.0
 */

public class ValueListHandler extends ValueListIterator implements Serializable
{
  protected LinkedList list_;

  protected int currentIndex_;

  protected transient ListIterator listIterator_;
  /** the logger*/
  private static transient Logger log_ = Logger.getLogger(at.tugraz.genome.dbutilities.ValueListHandler.class);

  public ValueListHandler()
  {
  }

  public ValueListHandler(LinkedList list) throws IteratorException
  {
    super();
    setList(list);
  }

  protected void setList(LinkedList list) throws IteratorException
  {
    this.list_ = new LinkedList(list);
    if (list_ != null) {
      listIterator_ = list_.listIterator();
    } else
      throw new IteratorException("List is empty: setList()");
  }

  protected void setList(LinkedList list, boolean preserveIndex)
      throws IteratorException
  {
    log_.debug("[ValueListHandler] currentIndex = " + currentIndex_);
    setList(list);
    if (preserveIndex) {
      setIndex(this.currentIndex_);
    }
  }

  protected Collection getList()
  {
    return list_;
  }

  public int getSize() throws IteratorException
  {
    int size = 0;
    if (list_ != null) {
      size = list_.size();
    } else {
      throw new IteratorException("List is empty: getSize()");
    }
    return size;
  }

  protected Object getCurrentElement() throws IteratorException
  {
    Object obj = null;
    if (list_ != null) {
      int currentIndex = listIterator_.nextIndex();
      if (currentIndex == getSize()) {
        currentIndex = getSize() - 1;
      }
      currentIndex_ = currentIndex;
      obj = list_.get(currentIndex);
    } else {
      throw new IteratorException("List is empty: getCurrentElement()");
    }
    return obj;
  }

  protected List getPreviousElements(int count) throws IteratorException
  {
    int i = 0;
    Object object = null;
    LinkedList list = new LinkedList();
    if (listIterator_ != null) {
      while (listIterator_.hasPrevious() && (i < count)) {
        object = listIterator_.previous();
        list.add(object);
        i++;
        currentIndex_ = listIterator_.nextIndex();
      }
    } else {
      throw new IteratorException("List is empty: getPreviousElements()");
    }
    return list;
  }

  protected List getNextElements(int count) throws IteratorException
  {
    int i = 0;
    Object object = null;
    LinkedList list = new LinkedList();
    if (listIterator_ != null) {
      while (listIterator_.hasNext() && (i < count)) {
        object = listIterator_.next();
        list.add(object);
        i++;
        currentIndex_ = listIterator_.nextIndex();
      }
      log_.info("currentIndex after getNextElements(): "
          + currentIndex_);
    } else {
      throw new IteratorException("List is empty: getNextElements()");
    }
    return list;
  }

  public void setIndex(int idx) throws IteratorException
  {
    if (idx < 0) {
      idx = 0;
    }
    if (listIterator_ != null) {
      if (idx < getSize()) {
        listIterator_ = list_.listIterator(idx);
        currentIndex_ = idx;
      } else {
        if (idx > getSize()) {
          throw new IteratorException("Index " + idx
              + " is greater than the number of elements in the list!");
        } else {
          if (idx == getSize()) {
            lastIndex();
          }
        }
      }
    } else {
      throw new IteratorException("List is empty: setIndex()");
    }
  }

  public void resetIndex() throws IteratorException
  {
    if (listIterator_ != null) {
      listIterator_ = list_.listIterator();
      currentIndex_ = listIterator_.nextIndex();
    } else {
      throw new IteratorException("List is empty: resetIndex()");
    }
  }

  public void lastIndex() throws IteratorException
  {
    if (listIterator_ != null) {
      listIterator_ = list_.listIterator(this.getSize());
      currentIndex_ = listIterator_.nextIndex();
    } else {
      throw new IteratorException("List is empty: lastIndex()");
    }
  }

  public boolean hasPrevious() throws IteratorException
  {
    if (listIterator_ != null) {
      if (listIterator_.hasPrevious()) {
        return true;
      } else {
        return false;
      }
    } else {
      throw new IteratorException("List is empty: hasPrevious()");
    }
  }

  public boolean hasNext() throws IteratorException
  {
    if (listIterator_ != null) {
      if (listIterator_.hasNext()) {
        return true;
      } else {
        return false;
      }
    } else {
      throw new IteratorException("List is empty: hasNext()");
    }
  }

  public int getNumberOfPages(int count) throws IteratorException
  {
    return (int) Math.ceil((double) getSize() / (double) count);
  }

  public int getNumberOfElements() throws IteratorException
  {
    return getSize();
  }
}