package at.tugraz.genome.dbutilities;

/**
 * <p>Title: MARS EJB</p>
 * <p>Description: Microarray Analysis and Retrieval System</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: genome.tugraz.at</p>
 * @author Robert Molidor
 * @version 1.0
 */

import java.util.List;
import at.tugraz.genome.dbutilities.exception.IteratorException;

public abstract class ValueListIterator {
  public abstract int getSize() throws IteratorException;
  protected abstract Object getCurrentElement() throws IteratorException;
  protected abstract List getPreviousElements(int count) throws IteratorException;
  protected abstract List getNextElements(int count) throws IteratorException;
  public abstract void setIndex(int idx) throws IteratorException;
  public abstract void resetIndex() throws IteratorException;
  public abstract void lastIndex() throws IteratorException;
  public abstract boolean hasPrevious() throws IteratorException;
  public abstract boolean hasNext() throws IteratorException;
  public abstract int getNumberOfPages(int count) throws IteratorException;
  public abstract int getNumberOfElements() throws IteratorException;
  //other common methods as required
}