package at.tugraz.genome.maspectras.chromaviewer;

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

import java.util.Vector;

//import at.tugraz.genome.maspectras.chromaviewer.vos.ChromaResolutionSettingsVO;
//import at.tugraz.genome.maspectras.chromaviewer.vos.ChromaViewSettingsVO;
import at.tugraz.genome.maspectras.msResultsAnalysis.vos.ViewerresolutionVO;
import at.tugraz.genome.maspectras.msResultsAnalysis.vos.ViewersettingVO;
import at.tugraz.genome.viewer3d.MapViewer;

public class CgChromaViewer extends Applet implements ActionListener
{
  String m_version = "V1.00";

  /** the uid */
  private static final long serialVersionUID = 1L;

  // Basic visualization parameters:

  String m_url; // URL for the Servlet

  int m_serial; // For Idiots

  String m_searchId; // ID of maspectras search

  String m_sequence; // Peptide sequence without modification

  String m_modification; // Modifications
  
  String m_peptide_modification; // Modifications

  String m_title; // Display Title

  double m_step; // Step size between cromatograms

  int m_charge; // Charge

  double m_lowerSpan; // Start mz value

  double m_upperSpan; // End mz value

  // TODO: This solution is insecure has to be replaced by a question to the AAS
  // or something similar
  boolean allowStorage; // User is allowed to store the data to the database

  CgChromaSetInfo m_info[]; // Chromatogram Data

  int m_state; // System State

  CgTitleManager m_titlePnl; // Title Panel

  Panel m_comPnl; // Command Panel

  Cg3dGraphicsManager m_3dPnl; // 3d Display

  Cg2dGraphicsManager m_2dPnl; // Single Spectrum Display

  CgFooterManager m_statPnl; // Status Display

  TextField m_upperSpanText;

  TextField m_lowerSpanText;

  TextField m_stepMzText; // Step

  // Choice m_chargeChoice;
  Button m_retrData; // Retrieve Data Command Button

  Button m_storeData;

  Checkbox m_chkRaw;

  Checkbox m_chkSmooth;
  
  Checkbox m_chkQuasi3D;

  Checkbox m_chk3D;

  Choice m_dispChargeChoice;

  Button m_upButton;

  Button m_dnButton;

  TextField m_minTimeText;

  TextField m_maxTimeText;

  Button m_zoomIn;

  Button m_zoomAll;

  Long quantId;
  
  // All aparallel processing is implemented in the following two threads:

  CgThreadedDataLoader m_loader;

  CgThreadedDataStorer m_storer;
  
  ThreadedChromaFetcher m_fetcher;
  
  Threaded3dSettingsStorer set_storer;

  java.util.Timer m_timer;
  
  Vector<Double> idealIntensityDistribution;
  
  MSMapViewer viewer;
  
  boolean setNewViewer_;
  
  private int toolWidth = 99;

  private Rectangle oldBounds;
  
  Long m_userid;
  
  private ViewersettingVO currentSettingVO;
  
  public static int maxCharge_ = 22;
  
  private Long peaklistId_;
  
  
  public void init()
  {
    m_timer = new java.util.Timer();
    m_serial = 0;
    retrieveParameters(); // retrieve the basic visualization parameters
                          // provided
    this.handleControlEvent("RetrieveData");
    createUserInterface();

    m_timer.schedule(new CgLoadingSupervisor(this), 10, 1000);
    m_titlePnl.setTitle(m_titlePnl, m_title, m_version);
  }

  public void paint(Graphics g)
  {
  }

  public void destroy()
  {
    m_timer.cancel();
    if (m_loader != null){
      m_loader.destroyDataLoader();
    }  
    m_loader = null;
    //      m_loader.stop();
    if (m_storer != null){
      m_storer.destroyDataStorer();
//      m_storer.stop();
    }
    if (m_fetcher !=null){
      m_fetcher.destroyDataFetcher();
    }
    m_storer = null; 
    if (set_storer != null){
      set_storer.destroyStorer();
    }
    set_storer = null;
//      set_storer.stop();
    if (this.viewer!=null){
      this.viewer.destroyViewer();
      if (this.viewer.getGraphics()!=null)
        this.viewer.getGraphics().dispose();
    }
    this.viewer = null;
    this.currentSettingVO = null;
    this.idealIntensityDistribution = null;
    this.m_2dPnl.destroy2dGraphicsManager();
    this.m_2dPnl.getGraphics().dispose();
    this.m_2dPnl = null;
    this.m_3dPnl.destroy3dGraphicsManager();
    if (this.m_3dPnl.getGraphics()!=null)
      this.m_3dPnl.getGraphics().dispose();
    this.m_3dPnl = null;
    this.m_chk3D.getGraphics().dispose();
    this.m_chk3D=null;
    this.m_chkQuasi3D.getGraphics().dispose();
    this.m_chkQuasi3D = null;
    this.m_chkRaw.getGraphics().dispose();
    this.m_chkRaw = null;
    this.m_chkSmooth.getGraphics().dispose();
    this.m_chkSmooth = null;
    this.m_comPnl.getGraphics().dispose();
    this.m_comPnl = null;
    this.m_dispChargeChoice.getGraphics().dispose();
    this.m_dispChargeChoice = null;
    this.m_dnButton.getGraphics().dispose();
    this.m_dnButton = null;
    if (this.m_info!=null){
      for (int i=0; i!=this.m_info.length;i++){
        if (m_info[i]!=null){
          m_info[i].destroyInfoObject();
          m_info[i] = null;
        }
      }
    }
    this.m_info = null;
    this.m_lowerSpanText.getGraphics().dispose();
    this.m_lowerSpanText = null;
    this.m_maxTimeText.getGraphics().dispose();
    this.m_maxTimeText = null;
    this.m_minTimeText.getGraphics().dispose();
    this.m_minTimeText = null;
    this.m_modification = null;
    this.m_peptide_modification = null;
    this.m_retrData.getGraphics().dispose();
    this.m_retrData = null;
    this.m_searchId = null;
    this.m_sequence = null;
    this.m_statPnl.getGraphics().dispose();
    this.m_statPnl.destroyFooter();
    this.m_statPnl = null;
    this.m_stepMzText.getGraphics().dispose();
    this.m_stepMzText = null;
    this.m_storeData.getGraphics().dispose();
    this.m_storeData = null;
    this.m_timer = null;
    this.m_title = null;
    this.m_titlePnl.destroyTitle();
    this.m_titlePnl.getGraphics().dispose();
    this.m_titlePnl = null;
    this.m_upButton.getGraphics().dispose();
    this.m_upButton = null;
    this.m_upperSpanText.getGraphics().dispose();
    this.m_upperSpanText = null;
    this.m_url = null;
    this.m_userid = null;
    this.peaklistId_ = null;
    this.m_version = null;
    this.m_zoomAll.getGraphics().dispose();
    this.m_zoomAll = null;
    this.m_zoomIn.getGraphics().dispose();
    this.m_zoomIn = null;
    this.oldBounds = null;
    this.quantId = null;
    this.getGraphics().dispose();
//    try {
//      this.finalize();
//    }
    
//    catch (Throwable e) {
      // TODO Auto-generated catch block
//      e.printStackTrace();
//    }
    System.gc();
    super.destroy();

//    System.gc();
  }

  public Cg2dGraphicsManager get2dPanel()
  {
    return m_2dPnl;
  }

  public Cg3dGraphicsManager get3dPanel()
  {
    return m_3dPnl;
  }

  public boolean any2dUserCgProbeThere(int x)
  {
    if (m_info == null)
      return false;
    int i = selectedCharge();
    if (i < 0)
      return false;
    return m_info[i].anyUserCgProbeThere(x);
  }

  public boolean any2dSystemCgProbeThere(int x)
  {
    if (m_info == null)
      return false;
    int i = selectedCharge();
    if (i < 0)
      return false;
    return m_info[i].anySystemCgProbeThere(x);
  }

  public void paint3dGraphics()
  {
    String s = m_dispChargeChoice.getSelectedItem();
    int i = Integer.parseInt(s);
    if (m_info == null)
      return;
    if (m_info.length < (i - 1))
      return;
    if (m_info[i - 1] == null)
      return;
    if (!this.m_chkQuasi3D.getState()&&m_info[i - 1].getM_set()!=null&&m_info[i - 1].getM_set().getRawData()!=null&&setNewViewer_){
      if (viewer!=null){
        this.remove(viewer);
        this.viewer.destroyViewer();
        this.viewer = null;
      }  
      viewer = MSMapViewerFactory.getMSMapViewer(m_info[i - 1].getM_set().getRawData(), m_info[i - 1].getM_set().getRetentionTimes(),
          m_info[i - 1].getM_minRawMz(),m_info[i - 1].getM_maxRawMz(),m_info[i - 1].getM_set().getResolutionFactor(),
          Float.parseFloat(this.m_stepMzText.getText()),this);
      float[] range = m_info[i - 1].getCurrentMzRange();
      viewer.setCurrent2DMzRange(range[0], range [1]);
      viewer.setPaintableProbes(m_info[i - 1].getProbesToPaint());
      viewer.setViewerSettings(this.currentSettingVO);
      //viewer.setCurrent2DMzRange(startMz, stopMz);
      viewer.init();
    }
    if (!this.m_chkQuasi3D.getState()){
      if (!setNewViewer_){
        float[] range = m_info[i - 1].getCurrentMzRange();
        viewer.setCurrent2DMzRange(range[0], range [1]);
        viewer.setPaintableProbes(m_info[i - 1].getProbesToPaint());
        viewer.repaintColors();
      }
      viewer.setTheShowSelectedWasOn(false);
      this.check3dPanelOnPanel();
    }else{  
      this.checkViewerOnPanel();
      if (m_chkRaw.getState() == true) {
        m_3dPnl.preparePaint();
        m_info[i - 1].Draw3DDiagram(m_3dPnl, true);
        m_3dPnl.refresh();
      } else {
        m_3dPnl.preparePaint();
        m_info[i - 1].Draw3DDiagram(m_3dPnl, false);
        m_3dPnl.refresh();
      }
    }
  }

  public void paint2dGraphics(Graphics g)
  {
    String s = m_dispChargeChoice.getSelectedItem();
    int i = Integer.parseInt(s);
    if (m_info == null)
      return;
    if (m_info.length < (i - 1))
      return;
    if (m_info[i - 1] == null)
      return;

    if (m_chkRaw.getState() == true)
      m_info[i - 1].Draw2DDiagram(m_2dPnl, true);
    else
      m_info[i - 1].Draw2DDiagram(m_2dPnl, false);
  }

  public void mouse2dAction(MouseEvent e)
  {
    int i = selectedCharge();
    if (i < 0)
      return;
    m_info[i].mouse2dAction(m_2dPnl, e);
  }

  public void popup2dMenuAction(ActionEvent e)
  {
    if (e.getActionCommand() == "Determine Area") {
      int i = selectedCharge();
      if (i < 0)
        return;
      m_info[i].popup2dAction(e);
    }
    if (e.getActionCommand() == "Determine Area (Col)") {
      int i = selectedCharge();
      if (i < 0)
        return;
      m_info[i].popup2dAction(e);
    } else if (e.getActionCommand() == "Delete Area") {
      int i = selectedCharge();
      if (i < 0)
        return;
      m_info[i].popup2dAction(e);
    }
  }

  public int allow2dPopup(int x, int y)
  {
    if (m_info == null)
      return 0;
    int i = selectedCharge();
    if (i < 0)
      return 0;
    return m_info[i].checkPopupClick(x, y);
  }

  public void handleControlEvent(String controlName)
  {
    int i;
    if (controlName.equalsIgnoreCase(MSMapViewer.CMD_SAVE_SETTINGS)){
      ViewersettingVO settingsVO = this.viewer.getViewerSettings();
      settingsVO.setUserid(m_userid);
      if (this.currentSettingVO==null)
        this.currentSettingVO=settingsVO;
      if (!this.compareSettingsVOs(settingsVO,this.currentSettingVO)){
        this.currentSettingVO = settingsVO;
        this.viewer.executeCommand(MSMapViewer.CMD_UPDATE_RES_LEVEL);
      }
      if (settingsVO!=null){
        set_storer = new Threaded3dSettingsStorer(settingsVO);
        set_storer.setBaseUrl(m_url);
        set_storer.start();
      }
    }
    
    if (controlName.equalsIgnoreCase("RetrieveData")) {
      if (m_state == 1)
        return;
      m_state = 1;
      if (this.viewer!=null){
        this.currentSettingVO = this.viewer.getViewerSettings();
      }
      m_loader = new CgThreadedDataLoader(this);
      m_loader.setUrl(getProcessUrl());
      m_loader.start();
      if (m_storer != null)
        m_storer = null;
    }
    if (controlName.equalsIgnoreCase("RequestSpectrum")) {
      if (m_state == 1)
        return;
      m_state = 5;
      m_fetcher = new ThreadedChromaFetcher(this);
      m_fetcher.setUrl(getFetchUrl());
      m_fetcher.setChargeState_(Integer.valueOf(this.m_dispChargeChoice.getSelectedItem()));
      m_fetcher.start();
      if (m_storer != null)
        m_storer = null;
      if (set_storer != null)
        set_storer = null;
      m_retrData.setEnabled(false);
      m_storeData.setEnabled(false);
      m_2dPnl.requestSpectrum_.setEnabled(false);
      
    }   
    if (controlName.equalsIgnoreCase("StoreData")) {
      if (m_state == 1 || m_state == 5)
        return;
      // CgDataStorer storer = new CgDataStorer(this);
      // storer.storeData();
      // storer = null;
      m_state = 1;
      m_storer = new CgThreadedDataStorer(this);
      m_storer.setBaseUrl(m_url);
      m_storer.start();
    }
    if (controlName.equalsIgnoreCase("DisableStorage")) {
      this.m_storeData.setEnabled(false);
    } else if (controlName == "Minus3dGain") {
      if (m_info == null)
        return;
      i = selectedCharge();
      if (i < 0)
        return;
      m_info[i].set3dGain(m_info[i].get3dGain() / (float) 1.1);
      paint3dGraphics();
    } else if (controlName.equalsIgnoreCase("Plus3dGain")) {
      if (m_info == null)
        return;
      i = selectedCharge();
      if (i < 0)
        return;
      m_info[i].set3dGain(m_info[i].get3dGain() * (float) 1.1);
      paint3dGraphics();
    } else if (controlName.equalsIgnoreCase("Plus2dGain")) {
      if (m_info == null)
        return;
      i = selectedCharge();
      if (i < 0)
        return;
      m_info[i].set2dGain(m_info[i].get2dGain() * (float) 1.1);
      m_2dPnl.preparePaint();
      paint2dGraphics(m_2dPnl.getGraphics());
    } else if (controlName.equalsIgnoreCase("Minus2dGain")) {
      if (m_info == null)
        return;
      i = selectedCharge();
      if (i < 0)
        return;
      m_info[i].set2dGain(m_info[i].get2dGain() / (float) 1.1);
      m_2dPnl.preparePaint();
      paint2dGraphics(m_2dPnl.getGraphics());
    } else if (controlName.equalsIgnoreCase("Minus2dShift")) {
      if (m_info == null)
        return;
      i = selectedCharge();
      if (i < 0)
        return;
      m_info[i].set2dShift(-1);
      m_2dPnl.preparePaint();
      paint2dGraphics(m_2dPnl.getGraphics());
    } else if (controlName.equalsIgnoreCase("Plus2dShift")) {
      if (m_info == null)
        return;
      i = selectedCharge();
      if (i < 0)
        return;
      m_info[i].set2dShift(+1);
      m_2dPnl.preparePaint();
      paint2dGraphics(m_2dPnl.getGraphics());
    }

    else if (controlName.equalsIgnoreCase("DisplayChargeChoice")
        || controlName.equalsIgnoreCase("DisplayModeRaw")
        || controlName.equalsIgnoreCase("DisplayModeSmooth")
        || controlName.equalsIgnoreCase("DisplayQuasi3D")
        || controlName.equalsIgnoreCase("Display3D")) {
      if (m_info == null)
        return;
      if (controlName == "DisplayChargeChoice"){
        if (this.viewer!=null){
          this.currentSettingVO = this.viewer.getViewerSettings();
/*          this.viewer = null;*/
        }
        this.setNewViewer_ = true;
      }  
      i = selectedCharge();
      if (m_info[i].getChromaCount() == 0) {
        m_2dPnl.hideFields();
        m_3dPnl.hideFields();
        if (this.viewer!=null)
          this.viewer.setVisible(false);
      } else {
        m_2dPnl.showFields();
        m_3dPnl.showFields();
        if (this.viewer!=null)
          this.viewer.setVisible(true);
      }
////      m_3dPnl.preparePaint();
      paint3dGraphics();
////      m_3dPnl.refresh();
      m_2dPnl.preparePaint(); 
      paint2dGraphics(m_2dPnl.getGraphics());
    } else if (controlName.equalsIgnoreCase("Dn")) {
      if (m_info == null)
        return;
      i = selectedCharge();
      if (i < 0)
        return;
      m_info[i].setNextChromatogram();
      m_2dPnl.preparePaint();
      paint2dGraphics(m_2dPnl.getGraphics());
////      m_3dPnl.preparePaint();
      paint3dGraphics();
    } else if (controlName.equalsIgnoreCase("Up")) {
      if (m_info == null)
        return;
      i = selectedCharge();
      if (i < 0)
        return;
      m_info[i].setPreviousChromatogram();
      m_2dPnl.preparePaint();
      paint2dGraphics(m_2dPnl.getGraphics());
////      m_3dPnl.preparePaint();
      paint3dGraphics();
    } else if (controlName.equalsIgnoreCase("ZoomIn")) {
      i = selectedCharge();
      if (i < 0)
        return;
      try {
        float f1 = Float.parseFloat(m_minTimeText.getText());
        float f2 = Float.parseFloat(m_maxTimeText.getText());
        if (f1 < 0 || f2 < 0 || f1 >= f2)
          return;
        if (m_info[i].setMinDispTime2d(f1) == false)
          return;
        if (m_info[i].setMaxDispTime2d(f2) == false)
          return;
        m_2dPnl.preparePaint();
        paint2dGraphics(m_2dPnl.getGraphics());
      }
      catch (Exception ex) {
        System.out.println(ex.toString());
      }
    } else if (controlName.equalsIgnoreCase("ZoomAll")) {
      i = selectedCharge();
      if (i < 0)
        return;
      try {
        m_info[i].zoomAll();
        m_2dPnl.preparePaint();
        paint2dGraphics(m_2dPnl.getGraphics());
      }
      catch (Exception ex) {
        System.out.println(ex.toString());
      }
    }
  }

  private int selectedCharge()
  {
    String s = m_dispChargeChoice.getSelectedItem();
    int i = Integer.parseInt(s);
    if (m_info == null)
      return -1;
    if (m_info.length < (i - 1))
      return -1;
    if (m_info[i - 1] == null)
      return -1;
    return i - 1;
  }

  public void handleTimerEvent()
  {
    if (m_statPnl == null)
      return;

    if (m_loader != null && m_loader.getJustReady() == true) {
      if (this.allowStorage) {
        this.m_storeData.setEnabled(true);
      }
  //    this.setNewViewer_ = true;
      this.oldBounds = this.m_3dPnl.getBounds();
      m_loader = null;
      m_state = 2;
      m_2dPnl.hideFields();
      if (m_info != null) {
        for (int i = 0; i < maxCharge_; i++) {
          if (m_info[i] == null)
            continue;
          if (m_info[i].getChromaCount() == 0)
            continue;
          if (m_info[i].getM_set().getRawData()==null)
            this.m_chk3D.setEnabled(false);
          else
            this.m_chk3D.setEnabled(true);
          this.m_dispChargeChoice.select(i);
          handleControlEvent("DisplayChargeChoice");
          m_2dPnl.showFields();
          return;
        }
      }

    }
    if (m_storer != null && m_storer.getJustReady() == true) {
      m_storer.stop();
      m_storer = null;

      handleControlEvent("DisplayChargeChoice");
      /*
       * 
       * m_2dPnl.preparePaint(); m_3dPnl.preparePaint(); Draw2DDiagram(m_2dPnl,
       * m_raw); Draw3DDiagram(m_3dPnl, m_raw); m_3dPnl.refresh();
       * 
       */

      m_state = 2;
    }
    if (m_fetcher != null && m_fetcher.getJustReady() == true) {
      m_fetcher.stop();
      m_fetcher = null;
      m_retrData.setEnabled(true);
      m_storeData.setEnabled(true);
      m_2dPnl.requestSpectrum_.setEnabled(true);
      handleControlEvent("DisplayChargeChoice");
      /*
       * 
       * m_2dPnl.preparePaint(); m_3dPnl.preparePaint(); Draw2DDiagram(m_2dPnl,
       * m_raw); Draw3DDiagram(m_3dPnl, m_raw); m_3dPnl.refresh();
       * 
       */

      m_state = 2;
    }

    switch (m_state) {
      case 0:
        m_statPnl
            .setStatus("Select Parameters and press <Process Data> to retrieve Data from maspectras Server.");
        break;
      case 1:
        m_statPnl.setStatus("Processing Data...");
        break;
      case 2:
        m_statPnl.setStatus("Done.");
        break;
      case 3:
        m_statPnl
            .setStatus("Error: Can't proceed: Chromatograms would overlap.");
        break;
      case 4:
        m_statPnl.setStatus("Storing Data...");
        break;
      case 5:
        m_statPnl.setStatus("Fetching Chromatogram...");
        break;  
    }
  }

  public void setChromaSetInfoArray(CgChromaSetInfo[] x)
  {
    m_info = x;
  }
  
  public void setChromaSetInfo(CgChromaSetInfo x,int charge)
  {
    m_info[charge-1] = x;
  }

  private void createUserInterface()
  {

    this.setLayout(null);
    Font toolBarFont=new Font("Helvetica",Font.PLAIN,10);
    Font smallFont=new Font("Helvetica",Font.PLAIN,9);
    m_comPnl = new Panel();
    m_comPnl.setLayout(null);
//    m_comPnl.setLayout(new GridBagLayout());
    m_comPnl.setBounds(this.getWidth() - toolWidth, 0, toolWidth, this
        .getHeight());
    m_comPnl.setBackground(new Color(240, 240, 240));
    this.add(m_comPnl);

    m_titlePnl = new CgTitleManager();
    m_titlePnl.setBounds(0, 0, this.getWidth() - toolWidth, 30);
    m_titlePnl.setBackground(new Color(240, 240, 240));
    m_comPnl.setVisible(true);
    this.add(m_titlePnl);

    m_3dPnl = new Cg3dGraphicsManager(this);
    m_3dPnl.setBounds(0, 30, this.getWidth() - toolWidth, (int) ((this
        .getHeight() - 50) * 0.75));
    m_3dPnl.initialize();
    this.add(m_3dPnl);
    m_2dPnl = new Cg2dGraphicsManager(this);
    m_2dPnl.setBounds(0, m_3dPnl.getHeight() + 30, this.getWidth() - toolWidth,
        this.getHeight() - m_3dPnl.getHeight() - 50);
    m_2dPnl.initialize();
    this.add(m_2dPnl);
    m_statPnl = new CgFooterManager();
    m_statPnl.setBounds(0, this.getHeight() - 20, this.getWidth() - 60, 20);
    m_statPnl.setBackground(new Color(240, 240, 240));
    this.add(m_statPnl);

    // **** Retrieve new Data ****

    Label lx = new Label();
    lx.setText("Lower Mz Span:");
    lx.setFont(toolBarFont);
    lx.setBounds(5, 5, toolWidth - 10, 16); 
    m_comPnl.add(lx);
//    m_comPnl.add(lx,new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    m_lowerSpanText = new TextField();
    m_lowerSpanText.addTextListener(new CgTextChangeListener(this,
        "DisableStorage"));
    m_lowerSpanText.setText(String.format("%.0f", m_lowerSpan));
    m_lowerSpanText.setFont(toolBarFont);
    m_lowerSpanText.setBounds(5, lx.getY() + 16, toolWidth - 10, 20);
    m_comPnl.add(m_lowerSpanText);
//    m_comPnl.add(m_lowerSpanText,new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
//        ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    lx = new Label();
    lx.setText("mz Step:");
    lx.setFont(toolBarFont);
    lx.setBounds(5, m_lowerSpanText.getY() + 20, toolWidth - 10, 16);
    m_comPnl.add(lx);
//    m_comPnl.add(lx, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    m_stepMzText = new TextField();
    m_stepMzText.addTextListener(new CgTextChangeListener(this,
        "DisableStorage"));
    m_stepMzText.setFont(toolBarFont);
    m_stepMzText.setText(String.format("%.2f", m_step).replace(",", ".")
        .replace(".00", ""));
    m_stepMzText.setBounds(5, lx.getY() + 16, toolWidth - 10, 20);
    m_comPnl.add(m_stepMzText);
//    m_comPnl.add(m_stepMzText, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0
//        ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    lx = new Label();
    lx.setText("Upper mz Span:");
    lx.setFont(toolBarFont);
    lx.setBounds(5, m_stepMzText.getY() + 20, toolWidth - 10, 16);
    m_comPnl.add(lx);
//    m_comPnl.add(lx, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    m_upperSpanText = new TextField();
    m_upperSpanText.addTextListener(new CgTextChangeListener(this,
        "DisableStorage"));
    m_upperSpanText.setFont(toolBarFont);
    m_upperSpanText.setText(String.format("%.0f", m_upperSpan));
    m_upperSpanText.setBounds(5, lx.getY() + 16, toolWidth - 10, 20);
    m_comPnl.add(m_upperSpanText);
//    m_comPnl.add(m_upperSpanText, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0
//        ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));


    /**
     * lx = new Label(); lx.setText("Charge:"); lx.setBounds(5,
     * m_lowerSpanText.getY() + 20, toolWidth - 10, 16); m_comPnl.add(lx);
     * m_chargeChoice = new Choice(); m_chargeChoice.add("All");
     * m_chargeChoice.add("1"); m_chargeChoice.add("2");
     * m_chargeChoice.add("3"); m_chargeChoice.add("4");
     * m_chargeChoice.add("5"); m_chargeChoice.add("6");
     * m_chargeChoice.select(m_charge); m_chargeChoice.addItemListener(new
     * CgItemListener(this, "ChargeChoice")); m_chargeChoice.setBounds(5,
     * lx.getY() + 16, toolWidth - 10, 24); m_comPnl.add(m_chargeChoice);
     */

    m_retrData = new Button();
    m_retrData.setLabel("Process Data");
    m_retrData.setFont(toolBarFont);
    m_retrData.setBounds(5, /* m_chargeChoice.getY() */
        m_upperSpanText.getY() + 20 + 16 + 30, toolWidth - 10, 24); // m_lowerSpanText.getY()
                                                                    // + 20 +16
                                                                    // has been
                                                                    // added
    m_retrData.addActionListener(new CgActionListener(this, "RetrieveData"));
    m_comPnl.add(m_retrData);
//    m_comPnl.add(m_retrData,new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    m_storeData = new Button();
    m_storeData.setLabel("Store Data");
    m_storeData.setFont(toolBarFont);
    m_storeData.setBounds(5, m_retrData.getY() + 30, toolWidth - 10, 24); // m_lowerSpanText.getY()
                                                                          // + 20
                                                                          // +16
                                                                          // has
                                                                          // been
                                                                          // added
    m_storeData.addActionListener(new CgActionListener(this, "StoreData"));
    m_storeData.setEnabled(false);
    m_comPnl.add(m_storeData);
//    m_comPnl.add(m_storeData,new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    lx = new Label();
    lx.setText("Charge:");
    lx.setFont(smallFont);
    lx.setBounds(5, m_storeData.getY() + 60, (toolWidth - 15) / 2, 16);
    m_comPnl.add(lx);
//    m_comPnl.add(lx,new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    m_dispChargeChoice = new Choice();
    for (int i=0;i!=maxCharge_;i++){
      m_dispChargeChoice.add(String.valueOf(i+1));
    }
    m_dispChargeChoice.setFont(toolBarFont);
    m_dispChargeChoice.setBounds(5, lx.getY() + 16, (toolWidth - 10) / 2 + 5,
        24);
    m_dispChargeChoice.addItemListener(new CgItemListener(this,
        "DisplayChargeChoice"));
    m_comPnl.add(m_dispChargeChoice);
//    m_comPnl.add(m_dispChargeChoice,new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    CheckboxGroup group = new CheckboxGroup();
    m_chkRaw = new Checkbox("Raw", group, false);
    m_chkRaw.setFont(smallFont);
    m_chkRaw.setBounds(5, m_dispChargeChoice.getY() + 30, (toolWidth) / 2, 16);
    m_chkRaw.addItemListener(new CgItemListener(this, "DisplayModeRaw"));
    m_comPnl.add(m_chkRaw);
//    m_comPnl.add(m_chkRaw,new GridBagConstraints(0, 10, 2, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    m_chkSmooth = new Checkbox("Smooth", group, true);
    m_chkSmooth.setFont(smallFont);
    m_chkSmooth.setBounds(5, m_chkRaw.getY() + 16, (toolWidth) / 2, 16);
    m_chkSmooth.addItemListener(new CgItemListener(this, "DisplayModeSmooth"));
    m_comPnl.add(m_chkSmooth);
//    m_comPnl.add(m_chkSmooth,new GridBagConstraints(0, 11, 2, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    m_upButton = new Button();
    m_upButton.setLabel("- mz");
    m_upButton.setFont(smallFont);
    m_upButton.setBounds(15 + (toolWidth) / 2, m_retrData.getY() + 62,
        (toolWidth) / 2 - 20, 38);
    m_upButton.addActionListener(new CgActionListener(this, "Up"));
    m_comPnl.add(m_upButton);
//    m_comPnl.add(m_upButton,new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    m_dnButton = new Button();
    m_dnButton.setLabel("+ mz");
    m_dnButton.setFont(smallFont);
    m_dnButton.setBounds(15 + (toolWidth) / 2, m_upButton.getY() + 38,
        (toolWidth) / 2 - 20, 38);
    m_dnButton.addActionListener(new CgActionListener(this, "Dn"));
    m_comPnl.add(m_dnButton);
//    m_comPnl.add(m_dnButton,new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    // **** Zoom ****

    lx = new Label();
    lx.setText("t[min]:");
    lx.setFont(toolBarFont);
    lx.setBounds(5, m_dnButton.getY() + 70, (toolWidth - 15) / 2, 16);
    m_comPnl.add(lx);
//    m_comPnl.add(lx,new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    m_minTimeText = new TextField();
    m_minTimeText.setText("");
    m_minTimeText.setFont(toolBarFont);
    m_minTimeText.setBounds(5, lx.getY() + 16, (toolWidth - 15) / 2, 20);
    m_comPnl.add(m_minTimeText,new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    lx = new Label();
    lx.setText("t[max]:");
    lx.setFont(toolBarFont);
    lx.setBounds((toolWidth - 15) / 2 + 10, m_dnButton.getY() + 70,
        (toolWidth - 15) / 2, 16);
    m_comPnl.add(lx);
//    m_comPnl.add(lx,new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    m_maxTimeText = new TextField();
    m_maxTimeText.setText("");
    m_maxTimeText.setFont(toolBarFont);
    m_maxTimeText.setBounds((toolWidth - 15) / 2 + 10, lx.getY() + 16,
        (toolWidth - 15) / 2, 20);
    m_comPnl.add(m_maxTimeText);
//    m_comPnl.add(m_maxTimeText,new GridBagConstraints(1, 13, 1, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    m_zoomIn = new Button();
    m_zoomIn.setLabel("Zoom in");
    m_zoomIn.setFont(toolBarFont);
    m_zoomIn.setBounds(5, m_maxTimeText.getY() + 25, toolWidth - 10, 24);
    m_zoomIn.addActionListener(new CgActionListener(this, "ZoomIn"));
    m_comPnl.add(m_zoomIn);
//    m_comPnl.add(m_zoomIn,new GridBagConstraints(0, 14, 2, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    m_zoomAll = new Button();
    m_zoomAll.setLabel("Zoom all");
    m_zoomAll.setFont(toolBarFont);
    m_zoomAll.setBounds(5, m_zoomIn.getY() + 24, toolWidth - 10, 24);
    m_zoomAll.addActionListener(new CgActionListener(this, "ZoomAll"));
    m_comPnl.add(m_zoomAll);
//    m_comPnl.add(m_zoomAll,new GridBagConstraints(0, 15, 2, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    group = new CheckboxGroup();
    m_chkQuasi3D = new Checkbox("Quasi 3D", group, true);
    m_chkQuasi3D.setFont(smallFont);
    m_chkQuasi3D.setBounds(5, m_zoomAll.getY() + 30, (toolWidth*2) / 3, 16);
    m_chkQuasi3D.addItemListener(new CgItemListener(this, "DisplayQuasi3D"));
    m_comPnl.add(m_chkQuasi3D);
//    m_comPnl.add(m_chkRaw,new GridBagConstraints(0, 10, 2, 1, 0.0, 0.0
//        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    m_chk3D = new Checkbox("3D", group, false);
    m_chk3D.setFont(smallFont);
    m_chk3D.setEnabled(false);
    m_chk3D.setBounds(5, m_chkQuasi3D.getY() + 16, (toolWidth*2) / 3, 16);
    m_chk3D.addItemListener(new CgItemListener(this, "Display3D"));
    m_comPnl.add(m_chk3D);
    
    handleControlEvent("ChargeChoice");
  }

  private String getProcessUrl()
  {
    double d;

    if (m_searchId == null || m_searchId.length() < 1 || m_sequence == null
        || m_sequence.length() < 1 || m_modification == null
        || m_modification.length() < 1 || m_url == null || m_url.length() < 1)
      return "";
    StringBuilder sb = new StringBuilder();
    // sb.append("https://maspectras.genome.tugraz.at/maspectras/servlet/QuantificationDataProvider");
    sb.append(m_url);
    sb.append("/QuantificationDataProvider");
    sb.append("?");
    sb.append("searchId=" + m_searchId);
    sb.append("&");
    sb.append("sequence=" + m_sequence);
    sb.append("&");
    sb.append("modification=" + m_modification);
    sb.append("&");
    sb.append("peptidemodification=" + m_peptide_modification);
    sb.append("&");
    sb.append("userid=" + m_userid);
    sb.append("&");
    sb.append("peaklistId=" + peaklistId_.toString());
    /*
     * if (m_chargeChoice!=null && m_chargeChoice.getSelectedItem()!="All") {
     * sb.append("&"); sb.append("charge=" + m_chargeChoice.getSelectedItem()); }
     */
    try {
      // String url
      // ="https://maspectras.genome.tugraz.at/maspectras/servlet/QuantificationDataProvider?
      // searchId=551&sequence=LGEYGFQNALIVR&modification=000200000000004&step=0.5&lowerSpan=3&upperSpan=3";
      try {
        d = CgUtilities.StringToDouble(m_upperSpanText.getText());
      }
      catch (NullPointerException nex) {
        d = m_upperSpan;
      }
      sb.append("&");
      sb.append("upperSpan=" + Double.toString(d));
      try {
        d = CgUtilities.StringToDouble(m_lowerSpanText.getText());
      }
      catch (NullPointerException nex) {
        d = m_lowerSpan;
      }
      sb.append("&");
      sb.append("lowerSpan=" + Double.toString(d));
      try {
        d = CgUtilities.StringToDouble(m_stepMzText.getText());
      }
      catch (NullPointerException nex) {
        d = m_step;
      }
      sb.append("&");
      sb.append("step=" + Double.toString(d));

      sb.append("&");
      sb.append("serial=" + Integer.toString(++m_serial));
    }
    catch (Exception ex) {
      System.out.println(ex.toString());
    }
    return sb.toString();
  }
  
  private String getFetchUrl()
  {
    double d;

    if (m_searchId == null || m_searchId.length() < 1 || m_sequence == null
        || m_sequence.length() < 1 || m_modification == null
        || m_modification.length() < 1 || m_url == null || m_url.length() < 1)
      return "";
    StringBuilder sb = new StringBuilder();
    // sb.append("https://maspectras.genome.tugraz.at/maspectras/servlet/QuantificationDataProvider");
    sb.append(m_url);
    sb.append("/SingleChromaProvider");
    sb.append("?");
    sb.append("searchId=" +m_searchId);
    sb.append("&");
    sb.append("quantId=" +this.quantId);
    sb.append("&");
    sb.append("userid=" + m_userid);
    sb.append("&");
    sb.append("peaklistId=" + peaklistId_.toString());

    try {
      try {
        d = CgUtilities.StringToDouble(m_upperSpanText.getText());
      }
      catch (NullPointerException nex) {
        d = m_upperSpan;
      }
      sb.append("&");
      sb.append("upperSpan=" + Double.toString(d));
      try {
        d = CgUtilities.StringToDouble(m_lowerSpanText.getText());
      }
      catch (NullPointerException nex) {
        d = m_lowerSpan;
      }
      sb.append("&");
      sb.append("lowerSpan=" + Double.toString(d));
      try {
        d = CgUtilities.StringToDouble(m_stepMzText.getText());
      }
      catch (NullPointerException nex) {
        d = m_step;
      }
      sb.append("&");
      sb.append("step=" + Double.toString(d));

      sb.append("&");
      sb.append("charge=" + this.m_dispChargeChoice.getSelectedItem());
    }
    catch (Exception ex) {
      System.out.println(ex.toString());
    }
    return sb.toString();
  }

  // =========================================================================================
  // Parameters and Defaults
  // =========================================================================================

  private void retrieveParameters()
  {
    String s;

    s = getParameter("url");
    m_url = s != null ? s : "";

    s = getParameter("searchId");
    m_searchId = s != null ? s : "";

    s = getParameter("sequence");
    m_sequence = s != null ? s : "";

    s = getParameter("modification");
    m_modification = s != null ? s : "";
    
    s = getParameter("peptidemodification");
    m_peptide_modification = s != null ? s : "";

    s = getParameter("title");
    m_title = s != null ? s : "";

    s = getParameter("step");
    m_step = CgUtilities.StringToDouble(s);
    if (m_step == 0)
      m_step = 1;

    s = getParameter("lowerSpan");
    m_lowerSpan = CgUtilities.StringToDouble(s);
    if (m_lowerSpan == 0)
      m_lowerSpan = 3;

    s = getParameter("upperSpan");
    m_upperSpan = CgUtilities.StringToDouble(s);
    if (m_upperSpan == 0)
      m_upperSpan = 3;

    s = getParameter("charge");
    m_charge = CgUtilities.StringToInteger(s);

    // TODO: This solution is insecure has to be replaced by a question to the
    // AAS or something similar
    this.allowStorage = false;
    s = getParameter("allowStorage");
    if (s != null && (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes"))) {
      this.allowStorage = true;
    }
    s = getParameter("userId");
    m_userid = new Long(s);
    s = getParameter("peaklistId");
    peaklistId_ = new Long(s);

  }
/*  
  public void resize(Dimension d){
    System.out.println("Resizing");
    super.resize(d);
  }
  
  public void resize(int width, int height){
    System.out.println("Resizing 2");
    super.resize(width, height);
  }*/
  
  public void reshape(int x, int y, int width, int height){
    super.reshape(x, y, width, height);
    this.resizeUserInterface();
    this.validate();
    this.repaint();
  }
  
  private void resizeUserInterface(){

    if (m_comPnl!=null){
      m_comPnl.setBounds(this.getWidth() - toolWidth, 0, toolWidth, this
        .getHeight());
      m_titlePnl.setBounds(0, 0, this.getWidth() - toolWidth, 30);

      m_3dPnl.setBounds(0, 30, this.getWidth() - toolWidth, (int) ((this
        .getHeight() - 50) * 0.75));
      if (this.m_chkQuasi3D.getState())
        this.paint3dGraphics();
      m_2dPnl.setBounds(0, m_3dPnl.getHeight() + 30, this.getWidth() - toolWidth,
        this.getHeight() - m_3dPnl.getHeight() - 50);
      m_statPnl.setBounds(0, this.getHeight() - 20, this.getWidth() - 60, 20);
      if (viewer!=null){
        viewer.setBounds(0, 30, this.getWidth() - toolWidth, (int) ((this
        .getHeight() - 50) * 0.7));
      }
    }
  }
  
  private void check3dPanelOnPanel(){
    Component[] components = this.getComponents();
    boolean panel3DIsThere = false;
    for (int i=0; i!=components.length;i++){
      if (components[i].equals(m_3dPnl)) panel3DIsThere = true;
    }
    if (panel3DIsThere){
      Rectangle bounds = this.m_3dPnl.getBounds();
      this.remove(m_3dPnl);
      viewer.setBounds(bounds);
      this.add(viewer);
      this.validate();
      this.repaint();
    }
    if (this.setNewViewer_&&!panel3DIsThere){
      viewer.setBounds(oldBounds);
      this.add(viewer);
      this.validate();
      this.repaint(); 

    }
    if (this.setNewViewer_)
      this.setNewViewer_= false;
  }
  
  private void checkViewerOnPanel(){
    if (this.viewer!=null){
      Component[] components = this.getComponents();
      boolean viewerIsThere = false;
      for (int i=0; i!=components.length;i++){
        if (components[i].equals(viewer)) viewerIsThere = true;
      }
      if (viewerIsThere){
        Rectangle bounds = this.viewer.getBounds();
        this.remove(viewer);
        this.m_3dPnl.setBounds(bounds);
        this.add(m_3dPnl);
        this.validate();
        this.repaint();
      }
    }
  }

  public void actionPerformed(ActionEvent e)
  {
    String command = e.getActionCommand();
    if (command.equalsIgnoreCase(MapViewer.CMD_UPDATE_RES_LEVEL)||
        command.equalsIgnoreCase(MapViewer.CMD_ADD_RES_LEVEL)||
        command.equalsIgnoreCase(MapViewer.CMD_REMOVE_RES_LEVEL)||
        command.equalsIgnoreCase(MapViewer.CMD_SHOW_LIGHT)||
        command.equalsIgnoreCase(MapViewer.CMD_SHOW_TEXTURE)||
        command.equalsIgnoreCase(MSMapViewer.CMD_SHOW_SELECTED)||
        command.equalsIgnoreCase(MSMapViewer.CMD_SHOW_2D_POSITION)||
        command.equalsIgnoreCase(MSMapViewer.CMD_3D_DEFUALT)){
      this.currentSettingVO = this.viewer.getViewerSettings();
    }else{
      this.handleControlEvent(e.getActionCommand());
    }
  }

  public void setCurrentSettingVO(ViewersettingVO currentSettingVO)
  {
    this.currentSettingVO = currentSettingVO;
  }

  public ViewersettingVO getCurrentSettingVO()
  {
    return currentSettingVO;
  }
  
  private boolean compareSettingsVOs(ViewersettingVO first, ViewersettingVO second){
    boolean isEqual = true;
    if (first == null||second==null) isEqual=false; 
    if (isEqual&&first.getTimeStretch().doubleValue()!=second.getTimeStretch().doubleValue())
      isEqual = false;
    System.out.println(isEqual);
    if (isEqual&&first.getIntensityStretch().doubleValue()!=second.getIntensityStretch().doubleValue())
      isEqual = false;
    System.out.println(isEqual);
    if (isEqual&&first.getMzStretch().doubleValue()!=second.getMzStretch().doubleValue())
      isEqual = false;
    System.out.println(isEqual);
    if (isEqual&&(first.getLightSelected().booleanValue()!=second.getLightSelected().booleanValue()))
      isEqual = false;
    System.out.println(isEqual);
    if (isEqual&&(first.getTextureSelected().booleanValue()!=second.getTextureSelected().booleanValue()))
      isEqual = false;
    System.out.println(isEqual);
    if (isEqual&&(first.getSelectedSelected().booleanValue()!=second.getSelectedSelected().booleanValue()))
      isEqual = false;
    System.out.println(isEqual);
    if (isEqual&&(first.getPositionSelected().booleanValue()!=second.getPositionSelected().booleanValue()))
      isEqual = false;
    System.out.println(isEqual);
    if (isEqual&&(first.getThreeDDefault().booleanValue()!=second.getThreeDDefault().booleanValue()))
      isEqual = false;
    System.out.println(isEqual);
    if (isEqual&&first.getViewerresolutions().size()!=second.getViewerresolutions().size())
      isEqual = false;
    System.out.println(isEqual);
    if (isEqual){
      Vector firstResolutions = new Vector(first.getViewerresolutions());
      Vector secondResolutions = new Vector(second.getViewerresolutions());
      for (int i=0; i!=firstResolutions.size();i++){
        ViewerresolutionVO resVO1 = (ViewerresolutionVO)firstResolutions.get(i);
        ViewerresolutionVO resVO2 = (ViewerresolutionVO)secondResolutions.get(i);
        if (isEqual&&resVO1.getTimeResolution().doubleValue()!=resVO2.getTimeResolution().doubleValue())
          isEqual = false;
        System.out.println(isEqual);
        if (isEqual&&resVO1.getMzResolution().doubleValue()!=resVO2.getMzResolution().doubleValue())
          isEqual = false;
        System.out.println(isEqual);
        if (isEqual&&(i!=firstResolutions.size()-1)&&resVO1.getDistance().doubleValue()!=resVO2.getDistance().doubleValue())
          isEqual = false;
        System.out.println(isEqual);
      }
    }
    return isEqual;
  }
  

  
}
