package at.tugraz.genome.maspectras.chromaviewer;

import java.awt.*;

public class CgTitleManager extends Panel
{

  /** the uid */
  private static final long serialVersionUID = 1L;

  private String m_displayString;

  private String m_versionString;

  public CgTitleManager()
  {
    super(null);
    m_displayString = "";
    m_versionString = "";
  }

  public void setTitle(Panel myPanel, String title, String version)
  {
    m_displayString = title;
    m_versionString = version;
    this.invalidate();
  }

  public void paint(Graphics gx)
  {
    gx.setColor(Color.BLACK);
    gx.setFont(new Font("SansSerif", Font.BOLD, 18));
    gx.drawString(m_displayString, 10, 20);

    gx.setColor(Color.LIGHT_GRAY);
    gx.setFont(new Font("SansSerif", Font.PLAIN, 12));
    FontMetrics fm = gx.getFontMetrics();

    gx.drawString(m_versionString,
        getWidth() - fm.stringWidth(m_versionString), 27);
  }
  
  public void destroyTitle(){
    this.m_displayString = null;
    this.m_versionString = null;
//    try {
//      this.finalize();
//    }
//    catch (Throwable e) {
      // TODO Auto-generated catch block
//      e.printStackTrace();
//    }
  }
}
