package at.tugraz.genome.maspectras.chromaviewer;

import java.awt.event.ActionListener;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Hashtable;

import at.tugraz.genome.dbutilities.Base64;

public class MSMapViewerFactory
{
  public static MSMapViewer getMSMapViewer(String[] dataStrings, Hashtable<Integer,Float> retentionTimes, float mzStart, float mzStop,float startTime,float stopTime, int resolutionFactor,float stepSize, ActionListener listener){
    return MSMapViewerFactory.getMSMapViewer(dataStrings, retentionTimes, mzStart, mzStop, startTime, stopTime, resolutionFactor, stepSize, listener, MSMapViewer.DISPLAY_TIME_SECONDS,false);
  }
  
  public static MSMapViewer getMSMapViewer(String[] dataStrings, Hashtable<Integer,Float> retentionTimes, float mzStart, float mzStop,float startTime,float stopTime, int resolutionFactor,float stepSize, ActionListener listener, int displayTime, boolean msRangeChangeable){
    int startScan = -1;
    int stopScan = 100000000;
    if (startTime>0){
      Enumeration<Integer> keys = retentionTimes.keys();
      int lowestScan = 100000000;
      while (keys.hasMoreElements()){
        Integer key = keys.nextElement();
        if (retentionTimes.get(key)>=startTime&&key<lowestScan)
          lowestScan = key;
      }
      startScan = lowestScan;
    }
    if (stopTime>0){
      Enumeration<Integer> keys = retentionTimes.keys();
      int highestScan = 0;
      while (keys.hasMoreElements()){
        Integer key = keys.nextElement();
        if (retentionTimes.get(key)<=stopTime&&key>highestScan)
          highestScan = key;
      }
      stopScan = highestScan;
    }

    int dataAxisSize = retentionTimes.size();
    if (stopScan<100000000){
      if (dataAxisSize>stopScan)
        dataAxisSize = stopScan+1;
    }
    if (startScan>-1){
      dataAxisSize = dataAxisSize-startScan;
    }
    float[][]data = new float[dataStrings.length][dataAxisSize];
    for (int i = 0; i != dataStrings.length; i++) {
      if (dataStrings[i] != null && dataStrings[i].length() > 0) {
        ByteBuffer buffer = ByteBuffer.wrap(Base64.decode(dataStrings[i]));
        while (buffer.hasRemaining()) {
          int scanNumber = buffer.getInt();
          float intensity = buffer.getFloat();
          if (scanNumber>=startScan&&scanNumber<=stopScan){
            if (startScan>-1)
              data[i][scanNumber-startScan] += intensity;
            else
              data[i][scanNumber] += intensity;
          }
        }
      }
    }
    if (startScan > 0 || stopScan<100000000){
      Hashtable<Integer,Float> newRetentionTimes = new Hashtable<Integer,Float>();
      int reduceScanNumber = 0;
      if (startScan > 0)
        reduceScanNumber = startScan;
      Enumeration<Integer> keys = retentionTimes.keys();
      while (keys.hasMoreElements()){
        Integer key = keys.nextElement();
        if (key>=startScan&&key<=stopScan){
          newRetentionTimes.put(key-reduceScanNumber, retentionTimes.get(key));
//          System.out.println(key-reduceScanNumber+","+retentionTimes.get(key));
        }
      }
      retentionTimes = newRetentionTimes;
    }
//    System.out.println("dataAxisSize: "+dataAxisSize+";"+displayTime);
    MSMapViewer viewer = new MSMapViewer(data,retentionTimes,mzStart,mzStop,resolutionFactor,stepSize,listener,displayTime,msRangeChangeable);
    return viewer;
  }

  public static MSMapViewer getMSMapViewer(String[] dataStrings, Hashtable<Integer,Float> retentionTimes, float mzStart, float mzStop, int resolutionFactor,float stepSize, ActionListener listener,int displayTime,boolean msRangeChangeable){
    return MSMapViewerFactory.getMSMapViewer(dataStrings, retentionTimes, mzStart, mzStop, 0, 0, resolutionFactor, stepSize, listener,displayTime,msRangeChangeable);
  }

  
  public static MSMapViewer getMSMapViewer(String[] dataStrings, Hashtable<Integer,Float> retentionTimes, float mzStart, float mzStop, int resolutionFactor,float stepSize, ActionListener listener){
    return MSMapViewerFactory.getMSMapViewer(dataStrings, retentionTimes, mzStart, mzStop, 0, 0, resolutionFactor, stepSize, listener);
  }
}
