package at.tugraz.genome.maspectras.chromaviewer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Vector;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

//import at.tugraz.genome.maspectras.chromaviewer.vos.ChromaResolutionSettingsVO;
//import at.tugraz.genome.maspectras.chromaviewer.vos.ChromaViewSettingsVO;
import at.tugraz.genome.maspectras.msResultsAnalysis.vos.ViewerresolutionVO;
import at.tugraz.genome.maspectras.msResultsAnalysis.vos.ViewersettingVO;
import at.tugraz.genome.maspectras.quantification.CgProbe;

public class Threaded3dSettingsStorer extends Thread
{
  
  /** URL to the server */
  private String          m_base_url = "";
  
  /** 
   * 
   * @param sets the URL to the server
   */  
    public void setBaseUrl(String newValue)
    {
        m_base_url = newValue;
    }
    ViewersettingVO vo;
  
  /** 
   * 
   * @param myViewer the quantification applet
   */
  public Threaded3dSettingsStorer(ViewersettingVO vo)
  {
    this.vo = vo;
  }
    
  
  public void run()
  {
      URLConnection servletConnection = null;
      
//      String url = m_base_url;
      try
      {
                // this is only necessary for testing purposes, with applet loaded from the server not necessary
          if (m_base_url.startsWith("https"))
          {
              TrustManager[] trustAllCerts = new TrustManager[]
              { 
                  new X509TrustManager()
                  {
                      public boolean checkClientTrusted(java.security.cert.X509Certificate[] chain)               { return true; }
                      public java.security.cert.X509Certificate[] getAcceptedIssuers()                            { return null; }
                      public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) { }
                      public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) { } 
                  } 
              };
              try 
              {
                  SSLContext ctx;
                  ctx = SSLContext.getInstance("SSL");
                  ctx.init(null, trustAllCerts, null);
                  HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
              }
              catch (Exception e)
              {
                  e.printStackTrace();
              }
          } // this is only necessary for testing purposes, with applet loaded from the server not necessary
          String storeQuantparameterUrl = this.getStore3dSettingsURL();
          checkUrl(storeQuantparameterUrl);
          servletConnection = getServletConnection(storeQuantparameterUrl);
          servletConnection.getInputStream();
      }
      catch(Exception ex)
      {
        ex.printStackTrace();
      }
  }
  
  
  private static boolean checkUrl(String url) throws Exception
  {
    if (url.length() > 1024)
      throw new Exception("http request to long >1024!");
    return true;
  }

  private static URLConnection getServletConnection(String serverName)
  {
    URL url = null;
    URLConnection servletConnection = null;
    try {
      url = new URL(serverName);
      servletConnection = url.openConnection();
      servletConnection.setDoInput(true);
      servletConnection.setDoOutput(false);
      servletConnection.setUseCaches(false);
      servletConnection.setRequestProperty("Content-type",
          "application/octet-stream");
    }
    catch (IOException ioe) {
      System.out.println(ioe.getMessage());
      System.out.println("IOException " + ioe);
    }
    catch (Exception e) {
      System.out.println("Error in getServletConnection: " + e.getMessage());
    }
    return servletConnection;
  }
  
  private String getStore3dSettingsURL(){
    String url=this.m_base_url;
    url += "/Store3DSettings";
    url += "?";
    url += "uId="+vo.getUserid().toString();
    url += "&";
    url += "tStr="+vo.getTimeStretch().toString();;
    url += "&";
    url += "iStr="+vo.getIntensityStretch().toString();
    url += "&";
    url += "zStr="+vo.getMzStretch().toString();
    url += "&li=";
    if (vo.getLightSelected()){
      url += "1";
    }else{
      url += "0";
    }
    url += "&te=";
    if (vo.getTextureSelected()){
      url += "1";
    }else{
      url += "0";
    }
    url += "&se=";
    if (vo.getSelectedSelected()){
      url += "1";
    }else{
      url += "0";
    }
    url += "&po=";
    if (vo.getPositionSelected()){
      url += "1";
    }else{
      url += "0";
    }
    url += "&de=";
    if (vo.getThreeDDefault()){
      url += "1";
    }else{
      url += "0";
    }
    Iterator resVOs = vo.getViewerresolutions().iterator();
    url += "&ress=";
    url += String.valueOf(vo.getViewerresolutions().size());
    while (resVOs.hasNext()){
      ViewerresolutionVO resVO = (ViewerresolutionVO)resVOs.next();
      url += "&t"+resVO.getResolutionLevel().toString()+"="+resVO.getTimeResolution();
      url += "&m"+resVO.getResolutionLevel().toString()+"="+resVO.getMzResolution();
      if (vo.getViewerresolutions().size()!=resVO.getResolutionLevel().intValue()){
        url += "&d"+resVO.getResolutionLevel().toString()+"="+resVO.getDistance();
      }
    }
    

    System.out.println(url);
    return url;
  }
  
  public void destroyStorer(){
    this.m_base_url = null;
    this.vo = null;
//    try {
//      this.finalize();
//    }
//    catch (Throwable e) {
      // TODO Auto-generated catch block
//      e.printStackTrace();
//    }
//    super.destroy();
  }

}
