package at.tugraz.genome.maspectras.chromaviewer;

import java.io.ObjectInputStream;
import java.net.URLConnection;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import at.tugraz.genome.maspectras.quantification.vos.CgAllChromatogramSets;
import at.tugraz.genome.maspectras.quantification.vos.CgChromatogramSet;

public class ThreadedChromaFetcher extends Thread
{
  private String m_url = "";

  private CgChromaSetInfo m_info = null;
  
  private CgChromaViewer m_viewer;
  
  private int chargeState_ = 0;
  
  /** true when the first time data is retrieved */
  private boolean         m_firstCall;
  

  public ThreadedChromaFetcher(CgChromaViewer myViewer)
  {
    super();
    m_viewer = myViewer;
  }

  
  public void destroyDataFetcher(){
    this.m_info = null;
    this.m_url = null;
    if (this.m_viewer!=null)
      this.m_viewer.getGraphics().dispose();
    this.m_viewer = null;
  }
  
  /** 
   * 
   * @param sets the URL to the server
   */  
    public void setUrl(String newValue)
    {
        m_url = newValue;
    }
    
    /**
     * 
     * @return if the storage procedure is finished
     */
    public boolean getJustReady()
    {
        if (m_firstCall==true)
        {
            m_firstCall = false;
            return true;
        }
        return false;
    }
    
    
    
    public void setChargeState_(int chargeState_)
    {
      this.chargeState_ = chargeState_;
    }


    public void run()
    {
      URLConnection servletConnection = null;

      String url = m_url;
      try {
        CgThreadedDataLoader.checkUrl(url); // this is only necessary for testing purposes, with
                        // applet loaded from the server not necessary
        if (url.startsWith("https")) {
          TrustManager[] trustAllCerts = new TrustManager[] { new X509TrustManager() {
            public boolean checkClientTrusted(
                java.security.cert.X509Certificate[] chain)
            {
              return true;
            }

            public java.security.cert.X509Certificate[] getAcceptedIssuers()
            {
              return null;
            }

            public void checkClientTrusted(
                java.security.cert.X509Certificate[] chain, String authType)
            {
            }

            public void checkServerTrusted(
                java.security.cert.X509Certificate[] chain, String authType)
            {
            }
          } };
          try {
            SSLContext ctx;
            ctx = SSLContext.getInstance("SSL");
            ctx.init(null, trustAllCerts, null);
////            HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
          }
          catch (Exception e) {
            e.printStackTrace();
          }
        } // this is only necessary for testing purposes, with applet loaded from
          // the server not necessary

        servletConnection = CgThreadedDataLoader.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection
            .getInputStream());
        CgChromatogramSet set = (CgChromatogramSet) input.readObject();
        m_info = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
            .get3dPanel(), chargeState_, set);
      }
      catch (Exception ex) {
        System.out.println(ex.toString());
      }
      m_viewer.setChromaSetInfo(m_info,chargeState_);
      m_firstCall = true;
    }
    
}
