package at.tugraz.genome.maspectras.parser.spectrummill.vos;

/**
 * VO holding the occurrence and mass value of a chemical isotope
 * @author Juergen Hartler
 *
 */
public class SmIsotopeVO
{
  /** the mass value */
  private double mass;
  /** the relative occurence in the nature */
  private double abundance;

  /**
   * @param mass the mass value
   * @param abundance the relative occurence in the nature
   */
  public SmIsotopeVO(double mass, double abundance)
  {
    this.mass = mass;
    this.abundance = abundance;
  }
  /**
   * @return the relative occurence in the nature
   */
  public double getAbundance()
  {
    return abundance;
  }
  /**
   * @return the mass value
   */
  public double getMass()
  {
    return mass;
  }

}
