package at.tugraz.genome.maspectras.quantification;

/**
 * Factory to find the corresponding analyzer
 * @author Juergen Hartler
 *
 */
public class AnalyzerClusterFactory
{
  /**
   * finds the analyzer
   * @param filePath the raw/chrom file path
   * @param headerFilePath the header file path
   * @param indexFilePath the index file path
   * @param retentionTimeFilePath the retention-time file path
   * @param fileType the type of the raw/chrom file
   * @return the corresponding analyzer
   * @throws CgException
   */
  public static Analyzer getAnalyzer(String filePath, String headerFilePath, String indexFilePath, String retentionTimeFilePath, String fileType) throws CgException{
    Analyzer analyzer = null;
    if (fileType.equalsIgnoreCase("chrom")){
      analyzer = new ChromaAnalyzer(headerFilePath, indexFilePath, retentionTimeFilePath, filePath,false,0f);
    }else{
      analyzer = new CgAnalyzer(filePath,fileType);
    }
    return analyzer;
  }
}
