package at.tugraz.genome.maspectras.quantification;

public class Probe3D extends CgProbe
{
  private boolean overlapLowerMz_;
  private boolean overlapHigherMz_;
  private boolean overlapBefore_;
  private boolean overlapLater_;
  
  private float ellipseTimePosition_;
  private float ellipseMzPosition_;
  private float ellipseTimeStretch_;
  private float ellipseMzStretch_;
  
  /** the lower m/z value where the peak intensity falls below 10% of the apex*/
  private float lowMz10_ = -1f;
  /** the lower m/z value where the peak intensity falls below 50% of the apex*/
  private float lowMz50_ = -1f;
  /** the upper m/z value where the peak intensity falls below 10% of the apex*/
  private float upMz10_ = -1f;
  /** the upper m/z value where the peak intensity falls below 50% of the apex*/
  private float upMz50_ = -1f;
  
  /** lower hard limit - this happens if the ellipse of the peak is split by a hard retention time limit*/
  private float lowerHardRtLimit_;
  /** upper hard limit - this happens if the ellipse of the peak is split by a hard retention time limit*/
  private float upperHardRtLimit_;
  
  public Probe3D(CgProbe probe){
    super(probe);
    this.lowerHardRtLimit_ = -1f;
    this.upperHardRtLimit_ = -1f;
  }
  
  public Probe3D(Probe3D probe){
    this(((CgProbe)probe),probe.getEllipseTimePosition(),probe.getEllipseMzPosition(),
        probe.getEllipseTimeStretch(),probe.getEllipseMzStretch(),probe.lowerHardRtLimit_,
        probe.upperHardRtLimit_,probe.lowMz10_,probe.upMz10_,probe.lowMz50_,probe.upMz50_);
  }
  
  /**
   * 
   * @param probe the 2D chrom probe
   * @param profile the 2D profile probe
   * @param overlapLowerMz is there an overlap in the lower m/z region
   * @param overlapHigherMz is there an overlap in the higher m/z region
   * @param overlapBefore is there an overlap in the lower time region
   * @param overlapLater is there an overlap in the higher time region
   * @param ellipse the parameters for the ellipse
   */
  public Probe3D(CgProbe probe, CgProbe profile, boolean overlapLowerMz,
      boolean overlapHigherMz, boolean overlapBefore, boolean overlapLater,float[] ellipse){
    this (probe, overlapLowerMz, overlapHigherMz, overlapBefore, overlapLater, ellipse,
        profile.getLowerValley10(), profile.getUpperValley10(), profile.getLowerValley50(), profile.getUpperValley50());
  }
  
  /**
   * 
   * @param probe the 2D chrom probe
   * @param overlapLowerMz is there an overlap in the lower m/z region
   * @param overlapHigherMz is there an overlap in the higher m/z region
   * @param overlapBefore is there an overlap in the lower time region
   * @param overlapLater is there an overlap in the higher time region
   * @param ellipse the parameters for the ellipse
   * @param lowMz10 m/z value where intensity drops below 10% of the peak apex in the lower m/z region
   * @param upMz10 m/z value where intensity drops below 10% of the peak apex in the higher m/z region
   * @param lowMz50 m/z value where intensity drops below 50% of the peak apex in the lower m/z region
   * @param upMz50 m/z value where intensity drops below 50% of the peak apex in the higher m/z region
   */
  private Probe3D(CgProbe probe,boolean overlapLowerMz,boolean overlapHigherMz,
      boolean overlapBefore, boolean overlapLater,float[] ellipse,
      float lowMz10, float upMz10, float lowMz50, float upMz50)
  {
    this(probe,ellipse[0],ellipse[1],ellipse[2],ellipse[3], -1f, -1f,
        lowMz10, upMz10, lowMz50, upMz50);
    this.overlapLowerMz_ = overlapLowerMz;
    this.overlapHigherMz_ = overlapHigherMz;
    this.overlapBefore_ = overlapBefore;
    this.overlapLater_ = overlapLater;
    
  }

  /**
   * 
   * @param probe the 2D chrom probe
   * @param ellipseTimePosition chrom time in seconds of the center of the ellipse
   * @param ellipseMzPosition m/z of the center of the ellipse
   * @param ellipseTimeStretch extension of the ellipse in time direction in seconds
   * @param ellipseMzStretch extension of the ellipse in m/z direction
   * @param lowerHardLimit lower retention time hard limit in the case of overlapping isomers/isobars 
   * @param upperHardLimit upper retention time hard limit in the case of overlapping isomers/isobars 
   * @param lowMz10 m/z value where intensity drops below 10% of the peak apex in the lower m/z region
   * @param upMz10 m/z value where intensity drops below 10% of the peak apex in the higher m/z region
   * @param lowMz50 m/z value where intensity drops below 50% of the peak apex in the lower m/z region
   * @param upMz50 m/z value where intensity drops below 50% of the peak apex in the higher m/z region
   */
  public Probe3D(CgProbe probe, float  ellipseTimePosition, float ellipseMzPosition,
      float ellipseTimeStretch, float ellipseMzStretch, float lowerHardLimit, float upperHardLimit,
      float lowMz10, float upMz10, float lowMz50, float upMz50)
  {
    this(probe);
    this.ellipseTimePosition_ = ellipseTimePosition;
    this.ellipseMzPosition_ = ellipseMzPosition;
    this.ellipseTimeStretch_ = ellipseTimeStretch;
    this.ellipseMzStretch_ = ellipseMzStretch;
    this.lowerHardRtLimit_ = lowerHardLimit;
    this.upperHardRtLimit_ = upperHardLimit;
    this.lowMz10_ = lowMz10;
    this.upMz10_ = upMz10;
    this.lowMz50_ = lowMz50;
    this.upMz50_ = upMz50;
  }
  
  /**
   * 
   */
  private static final long serialVersionUID = -4299789166256383964L;



  public boolean isOverlapLowerMz()
  {
    return overlapLowerMz_;
  }

  public boolean isOverlapHigherMz()
  {
    return overlapHigherMz_;
  }

  public boolean isOverlapBefore()
  {
    return overlapBefore_;
  }

  public boolean isOverlapLater()
  {
    return overlapLater_;
  }

  public float getEllipseTimePosition()
  {
    return ellipseTimePosition_;
  }

  public float getEllipseMzPosition()
  {
    return ellipseMzPosition_;
  }

  public float getEllipseTimeStretch()
  {
    return ellipseTimeStretch_;
  }

  public float getEllipseMzStretch()
  {
    return ellipseMzStretch_;
  }

  /**
   * this happens if the ellipse of the peak is split by a hard retention time limit
   * @return the lower hard limit (if no one is there -1 is returned)
   */
  public float getLowerHardRtLimit()
  {
    return lowerHardRtLimit_;
  }

  /**
   * this happens if the ellipse of the peak is split by a hard retention time limit
   * @param lowerHardRtLimit the lower hard limit (if no one is there -1 is used)
   */
  public void setLowerHardRtLimit(float lowerHardRtLimit)
  {
    this.lowerHardRtLimit_ = lowerHardRtLimit;
  }

  /**
   * this happens if the ellipse of the peak is split by a hard retention time limit
   * @return the upper hard limit (if no one is there -1 is returned)
   */
  public float getUpperHardRtLimit()
  {
    return upperHardRtLimit_;
  }

  /**
   * this happens if the ellipse of the peak is split by a hard retention time limit
   * @param upperHardRtLimit the upper hard limit (if no one is there -1 is used)
   */
  public void setUpperHardRtLimit(float upperHardRtLimit)
  {
    this.upperHardRtLimit_ = upperHardRtLimit;
  }

  /**
   * 
   * @return m/z value where intensity drops below 10% of the peak apex in the lower m/z region
   */
  public float getLowMz10()
  {
    return lowMz10_;
  }

  /**
   * 
   * @return m/z value where intensity drops below 50% of the peak apex in the lower m/z region
   */
  public float getLowMz50()
  {
    return lowMz50_;
  }

  /**
   * 
   * @return m/z value where intensity drops below 10% of the peak apex in the upper m/z region
   */
  public float getUpMz10()
  {
    return upMz10_;
  }

  /**
   * 
   * @return m/z value where intensity drops below 50% of the peak apex in the upper m/z region
   */
  public float getUpMz50()
  {
    return upMz50_;
  }

  
  
}
