package at.tugraz.genome.maspectras.quantification.vos;

/**
 * Descriptions about a file stored in mzData format
 * @author Juergen Hartler
 *
 */
public class CgMzDataDescriptionVO extends LevelRangeVO
{
  /** the retention time */
  private float   retentionTime     = 0;
  /** the m/z value */
  private float   basePeakMz        = 0;
  /** the peak intensity */
  private float   basePeakIntensity = 0;
  /** the total ion current */
  private float   totIonCurrent     = 0;
  
  /**
   * @param level the ms scan level (MS, MS/MS, MS3, ...)
   * @param lowerMz lower m/z value
   * @param upperMz upper m/z value
   */
  public CgMzDataDescriptionVO(int level, float lowerMz, float upperMz)
  {
    super(level, lowerMz, upperMz);
  }
  
  /**
   * @param level the ms scan level (MS, MS/MS, MS3, ...)
   * @param lowerMz lower m/z value
   * @param upperMz upper m/z value
   * @param retentionTime retention time
   * @param basePeakMz m/z value
   * @param basePeakIntensity peak intensity
   * @param totIonCurrent total ion current
   */
  public CgMzDataDescriptionVO(int level, float lowerMz, float upperMz, float retentionTime, float basePeakMz, float basePeakIntensity, float totIonCurrent){
    this(level,lowerMz,upperMz);
    this.retentionTime = retentionTime;
    this.basePeakMz = basePeakMz;
    this.basePeakIntensity = basePeakIntensity;
    this.totIonCurrent = totIonCurrent;
  }
  /**
   * @param vo the VO holding m/z values and MS level
   * @param retentionTime retention time
   * @param basePeakMz m/z value
   * @param basePeakIntensity peak intensity
   * @param totIonCurrent total ion current
   */
  public CgMzDataDescriptionVO(LevelRangeVO vo, float retentionTime,float basePeakMz, float basePeakIntensity, float totIonCurrent){
    this (vo.getLevel(), vo.getLowerMz(), vo.getUpperMz(), retentionTime, basePeakMz, basePeakIntensity, totIonCurrent);
  }
  /**
   * @return peak intensity
   */
  public float getBasePeakIntensity()
  {
    return basePeakIntensity;
  }
  /**
   * @param basePeakIntensity peak intensity
   */
  public void setBasePeakIntensity(float basePeakIntensity)
  {
    this.basePeakIntensity = basePeakIntensity;
  }
  /**
   * @return m/z value
   */
  public float getBasePeakMz()
  {
    return basePeakMz;
  }
  /**
   * @param basePeakMz m/z value
   */
  public void setBasePeakMz(float basePeakMz)
  {
    this.basePeakMz = basePeakMz;
  }
  /**
   * @return retention time
   */
  public float getRetentionTime()
  {
    return retentionTime;
  }
  /**
   * @param retentionTime retention time
   */
  public void setRetentionTime(float retentionTime)
  {
    this.retentionTime = retentionTime;
  }
  /**
   * @return total ion current
   */
  public float getTotIonCurrent()
  {
    return totIonCurrent;
  }
  /**
   * @param totIonCurrent total ion current
   */
  public void setTotIonCurrent(float totIonCurrent)
  {
    this.totIonCurrent = totIonCurrent;
  }

}
