package at.tugraz.genome.maspectras.rawfilereader;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

/** This class contains about one scan entry. Sequest
 *  seems to combine sometimes scanentries to one spectra,
 *  it drops also scans with less than 25 detector hits.
 */ 
public class MSScanInfo {


/** Number of this scan, starting with 0.
 */
  private int		scannumber;

/** ID of the scan, normaly this is the number+1.
 */
  private int		scanid;

/** List of attributes attached to this scan.
 */
  private Hashtable	scanattributes;

/** List of detector hits.
 */
  private MSMZDataPoint	hitlist[];

  protected MSScanInfo(int scannumber, int scanid, MSMZDataPoint hitlist[],
                       Hashtable scanattributes) {
    this.scannumber=scannumber;
    this.scanid=scanid;
    this.hitlist=hitlist;
    this.scanattributes=scanattributes;
  }

  protected int getScanNumber() { return(scannumber); }

  public int getScanID() { return(scanid); }

  public int getHitCount() { return(hitlist.length); }
  public MSMZDataPoint[] getHitList() { return(hitlist); }

  public Object getScanAttribute(String name) {
    return(scanattributes.get(name));
  }
  protected void addScanAttribute(String name, Object value) {
    scanattributes.put(name, value);
  }

  public String[] getScanAttributeNames() {
    Enumeration keyenum=scanattributes.keys();
    ArrayList list=new ArrayList();
    while(keyenum.hasMoreElements()) {
      list.add(keyenum.nextElement());
    }
    String ret[]=new String[list.size()];
    list.toArray(ret);
    return(ret);
  }
}
