package at.tugraz.genome.maspectras.utils;

import java.io.File;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

import at.tugraz.genome.maspectras.msResultsAnalysis.vos.ProteinExtendedVO;

public class StringUtils
{
  /**
   * splits the title for dta files into one part with the name and the scan number and a second containing the charge
   * @param title whole title
   * @return the name and the scan number[0] and the charge [1]
   */
  public static String[] divideTitle(String title) {
    String[] dividedTitle = { "", "", "", "" };
    if (title.indexOf("FinneganScanNumber: ")!=-1){
      dividedTitle[0] = title.substring(title.indexOf("FinneganScanNumber: ")+"FinneganScanNumber: ".length());
    }else if(title.indexOf("SpectrumID: ")!=-1){
      dividedTitle[0] = title.substring(title.indexOf("SpectrumID: ")+"SpectrumID: ".length(),title.length()-1);
    }else if(title.indexOf("Locus:")!=-1){
      dividedTitle[0] = title.substring(title.indexOf("Locus:")+"Locus:".length(),title.length());
    }else if(title.indexOf("Sum of")!=-1&&title.indexOf("scans in range")!=-1&&title.indexOf("to ")!=-1){
      String firstScanNumber = (new StringTokenizer(title.substring(title.indexOf("scans in range ")+"scans in range ".length())," ")).nextToken();
      String restFragment = title.substring(title.indexOf("scans in range ")+"scans in range ".length());
      String secondScanNumber = (new StringTokenizer(restFragment.substring(restFragment.indexOf("to ")+"to ".length())," ")).nextToken();
      dividedTitle[0] = firstScanNumber+"."+secondScanNumber;
    }else if (title.indexOf("spectrumId=")!=-1){
      StringTokenizer tokenizer = new StringTokenizer(title.substring(title.indexOf("spectrumId=")+"spectrumId=".length())," ");
      dividedTitle[0] = tokenizer.nextToken();
    }else if (title.indexOf("Spectrum")!=-1){
      StringTokenizer tokenizer = new StringTokenizer(title.substring(title.indexOf("Spectrum")+"Spectrum".length())," ");
      dividedTitle[0] = tokenizer.nextToken();      
    }else if(title.indexOf("Scan")!=-1){
      StringTokenizer tokenizer = new StringTokenizer(title," ");
      while (tokenizer.hasMoreTokens()){
        String token = tokenizer.nextToken();
        if (token.equalsIgnoreCase("Scan")){
          dividedTitle[0] = tokenizer.nextToken();
        }
      }
    }else if(title.indexOf("MS/MS of")!=-1){
      dividedTitle[3] = "true";
//      dividedTitle[2] = "dta";
    }else{
      Vector<String> parts = new  Vector<String>();
      StringTokenizer tokenizer = new StringTokenizer(title, ".");
      while (tokenizer.hasMoreElements()) {
        parts.add(tokenizer.nextToken());
      }
      if (title.endsWith("dta")||title.endsWith("pkl")||title.endsWith("ekl")||
          title.indexOf(".dta.")!=-1||title.indexOf(".pkl.")!=-1||title.indexOf(".ekl.")!=-1){
        if (title.indexOf(".dta.")!=-1||title.indexOf(".pkl.")!=-1||title.indexOf(".ekl.")!=-1){
          int index = title.length();
          if (title.indexOf(".dta.")!=-1)
            index = title.indexOf(".dta.")+4;
          if (title.indexOf(".pkl.")!=-1)
            index = title.indexOf(".pkl.")+4;
          if (title.indexOf(".ekl.")!=-1)
            index = title.indexOf(".ekl.")+4;
          String subTitle = title.substring(0,index);
          parts = new Vector<String>();
          tokenizer = new StringTokenizer(subTitle, ".");
          while (tokenizer.hasMoreElements()) {
            parts.add(tokenizer.nextToken());
          }          
        }
        for (int i = 0; i != (parts.size() - 2); i++) {
          if (dividedTitle[0].equalsIgnoreCase("")) {
              dividedTitle[0] = (String) parts.get(i);
          } else {
              dividedTitle[0] = dividedTitle[0].concat(".").concat((String) parts.get(i));
          }
          dividedTitle[1] = ((String) parts.get(parts.size() - 2)) + "." + ((String) parts.get(parts.size() - 1));
        }
        if (parts.size()==2){
          dividedTitle[0] = (String)parts.get(0);
          dividedTitle[1] = null;
          dividedTitle[2] = (String)parts.get(1);
        }  
      }else{
        for (int i = 0; i != (parts.size() - 2); i++) {
          if (dividedTitle[0].equalsIgnoreCase("")) {
            dividedTitle[0] = (String) parts.get(i);
          } else {
            dividedTitle[0] = dividedTitle[0].concat(".").concat((String) parts.get(i));
          }
        }
        dividedTitle[0] = dividedTitle[0].concat(".").concat((String)parts.get(parts.size()-1));
        dividedTitle[2] = (String)parts.get(parts.size()-2);
      }
    }
    return dividedTitle;
  }
  
  public static String getJustFileName(String fullPath){
    int lastIndexSeparator = -1;
    int slashIndex = fullPath.lastIndexOf("/");
    int backSlIndex = fullPath.lastIndexOf("\\");
    if (slashIndex>backSlIndex)
      lastIndexSeparator = slashIndex;
    else
      lastIndexSeparator = backSlIndex;
    return fullPath.substring(lastIndexSeparator+1);
  }
  
  public static String getFileNameWOSuffix(String fullPath){
    String fileName = getJustFileName(fullPath);
    if (fileName.lastIndexOf(".")!=-1) fileName = fileName.substring(0,fileName.lastIndexOf("."));
    return fileName;
  }
  
  
  public static String[] getChromFilePaths(String filePath){
    String[] chromFilePaths = new String[4];
    String nameWithoutPostfix =  filePath.substring(0,filePath.lastIndexOf("."));
    File headerFile = new File(nameWithoutPostfix+".head");
    File chromDirectory = new File(nameWithoutPostfix+".chrom");
    if (headerFile.exists()){
      //Then there is nothing to do!
    }
    if (chromDirectory.exists()&&chromDirectory.isDirectory())
      nameWithoutPostfix = chromDirectory.getAbsolutePath()+"/"+StringUtils.getJustFileName(nameWithoutPostfix);
    chromFilePaths[0] = nameWithoutPostfix+".chrom";
    chromFilePaths[1] = nameWithoutPostfix+".head";
    chromFilePaths[2] = nameWithoutPostfix+".idx";
    chromFilePaths[3] = nameWithoutPostfix+".rtt";      
    return chromFilePaths;
  }
  
  @SuppressWarnings("unchecked")
  public static String getHashKeyStringIgnoreCase(Hashtable scans, String keyIgnoreCase){
    Set<String> keys = scans.keySet();
    String key = null;
    for (String aKey : keys){
      if (aKey.equalsIgnoreCase(keyIgnoreCase)){
        key = aKey;
        break;
      }
    }
    return key;
  }

  public static String extractDirName(String fileName){
    int idx = 0;
    int slashIdx = fileName.lastIndexOf("/");
    int bkSlashIdx = fileName.lastIndexOf("\\");
    if (slashIdx>bkSlashIdx)
      idx = slashIdx;
    else
      idx = bkSlashIdx;
    String newFileName = fileName.substring(0,idx);
    return newFileName;
  }
  
  public static String[] generateExternalLinkForExtDbEbtry(ProteinExtendedVO protExtVO,@SuppressWarnings("rawtypes") Collection paramsList,String directExternalLinks){
    String[] results = new String[2];
    String externalLinkJScript = "";
    String externalLinkWindowNames = "";
    @SuppressWarnings("rawtypes")
    java.util.Vector exDbIds =(Vector) paramsList;
    if (paramsList!=null&&paramsList.size()>0){
        if(exDbIds!=null){
        for(int i=0;i!=exDbIds.size();i++){
             String linkString = directExternalLinks;
        String linkId=(String)exDbIds.get(i);
        if (externalLinkJScript==null||externalLinkJScript.length()<1){
        externalLinkJScript="popUpExtLink('";
        }
        if (externalLinkJScript.indexOf(linkString)==-1||exDbIds.size()>0){
        externalLinkJScript+=linkString+linkId+";";
        externalLinkWindowNames+=linkId+";";
        }else{
                String firstPartString = externalLinkJScript.substring(0,externalLinkJScript.indexOf(linkString)+linkString.length());
                String secondPartString = externalLinkJScript.substring(externalLinkJScript.indexOf(linkString)+linkString.length());
                if ((new java.util.StringTokenizer(secondPartString,";")).nextToken().indexOf(linkId)==-1){
                externalLinkJScript=firstPartString+linkId+";"+linkString+secondPartString;
                }
              }  
           }//closing for
        }//closing for if
         }//closing while
    
    if (externalLinkJScript.length()>0){
        externalLinkJScript=externalLinkJScript.substring(0,externalLinkJScript.length()-1)+"')";
        externalLinkWindowNames=externalLinkWindowNames.substring(0,externalLinkWindowNames.length()-1);
        externalLinkJScript=externalLinkJScript.substring(0,externalLinkJScript.indexOf("'"))+"'"+externalLinkWindowNames+"',"+externalLinkJScript.substring(externalLinkJScript.indexOf("'"));
    }
      results[0] = externalLinkWindowNames;
      results[1] = externalLinkJScript;
      return results;
   
  }


}
