package at.tugraz.genome.utils;

import at.tugraz.genome.dbutilities.Databases;
import at.tugraz.genome.dbutilities.SimpleValueObject;
import javax.naming.*;

import at.tugraz.genome.maspectras.GlobalConstants;
import at.tugraz.genome.maspectrasService.ServerSettings;
import at.tugraz.genome.utils.upload.vos.FileUploadTypeVO;
import at.tugraz.genome.utils.upload.vos.ParserClassVO;
import at.tugraz.genome.utils.utils.ParserPluginClassLoader;
import at.tugraz.genome.dbutilities.GenericDAOFactory;

import javax.xml.parsers.*;

import org.apache.log4j.Logger;
import org.w3c.dom.*;
import org.xml.sax.*;

import java.io.*;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

import java.util.jar.*;

/**
 * Additaional Utility Constants used by the application
 * @author Juergen Harlter
 * 
 */
public class UtilsConstants
{
  /** the logger*/
  private static Logger log_ = Logger.getLogger(at.tugraz.genome.utils.UtilsConstants.class);
  /** MBean for general server settings*/
  private static ServerSettings serverSettings = null;
  /** the possible file upload types */
  private static FileUploadTypeVO[] ENUM_FILETYPES;
  /** singleton of the constants*/
  private static UtilsConstants instance_ = null;
  /** minimum entry, when no file upload types file has been found */
  public static FileUploadTypeVO E_PLATE = new FileUploadTypeVO("Plate",
      "plates");
  /** minimum entry, when no file upload types file has been found */
  private static FileUploadTypeVO[] ENUM_FILETYPES_LOCAL = { E_PLATE };
  /** database field id for the table fileupload */
  public static String FILEUPLOAD_FIELD_ID = "ID";
  /** database field name for the table fileupload */
  public static String FILEUPLOAD_FIELD_NAME = "Name";
  /** database field category for the table fileupload */
  public static String FILEUPLOAD_FIELD_CATEGORY = "Category";
  /** database field added date for the table fileupload */
  public static String FILEUPLOAD_FIELD_ADDED_DATE = "Added Date";
  /** database field filepathname for the table fileupload */
  public static String FILEUPLOAD_FIELD_PATH = "filepathname";
  /** database field filesize for the table fileupload */
  public static String FILEUPLOAD_FIELD_SIZE = "filesize";
  /** database field userid for the table fileupload */
  public static String FILEUPLOAD_FIELD_USER_ID = "userid";
  /** database field description for the table fileupload */
  public static String FILEUPLOAD_FIELD_DESCR = "descr";

  public final static String PEPTIDES_ONE_NODE_DYNAMIC = "dynamic";
  /** the username for the cluster connection */
  private static String clusterUsername;
  /** the password for the cluster connection */
  private static String clusterPassword;
  /** the URL to the cluster*/
  private static String clusterURL;
  /** the URL plus username and password for the connection to the cluster*/
  private static String clusterURLPlusUser;
  /** the update intervall for retrieving information from the cluster*/
  private static int clusterUpdateIntervall;
  /** the threshold in amount of peptides to send a quantification to the cluster*/
  private static int thresholdForClusterQuantification;
  /** the threshold for the cache for the chromatogram file for the automatic quantification*/
  private static int maxChromSizeForCacheInMB;
  /** the threshold for the filesize that can be read at once*/
  private static int maxFileSizeForChromTranslationAtOnceInMB;
  /** should the chromatogram translation take place*/
  private static boolean translateChromatograms;
  
  private static boolean refreshOrganism;
  /** URL to the annotator of the IMP*/
  private static String annotatorURL;
  /** the SOAP service name of the annotator of the IMP*/
  private static String annotatorService;

  /** number of processors available for the quantification*/
  private static int numberOfProcessors;
  
  /** maspectras server settings for cemm- automatic creation of experiments to sample..*/
  private static boolean cemmImplementation;
  
  /** maspectras server settings for multiple sequence alignment of maspec evidence based on KAlign..*/
  private static String kalignURL;
  
  /** maspectras server settings for multiple sequence alignment of MUSCLE..*/
  private static String muscleURL;
  
  /** maspectras server settings for multiple sequence alignment of TCOFFEE..*/
  private static String tCoffeeURL;
  
  /** maspectras server settings of OBO URL for GeneOntology based grouping and display..*/
  private static String oboURL;
    
  /** maspectras server settings for to parse metasearch engine results from PepArML..*/
  private static boolean pepArMLMetaSearch;
  
  /** maspectras server settings of ontology URL for GeneOntology based grouping (ClueGO).*/
  private static String ontologySourceURL;
  private static String ontologySourcefile;
  private static String goMinimumLevel;
  private static String goMaximumLevel;
  
  private static boolean refreshSampleMSExpCache = false;
  private static boolean updateMSMachine = false;
  private static boolean updateModIdentifiers = false;
  
  /** property setting to go to external database links to fetch the corresponding ID details*/
  private static String goExternalLinkEntrezGene;
  private static String goExternalLinkEnsembl;
  private static String goExternalLinkEnsemblHavanna;
  private static String goExternalLinkGen3D;
  private static String goExternalLinkGo;
  private static String goExternalLinkNcbiTaxId;
  private static String goExternalLinkInterPro;
  private static String goExternalLinkPathoSign;
  private static String goExternalLinkPfam;
  private static String goExternalLinkProsite;
  private static String goExternalLinkRefSeq;
  private static String goExternalLinkSmart;
  private static String goExternalLinkUniprotSwissprot;
  private static String goExternalLinkUniprotTrembl;
  private static String goExternalLinkVega;
  private static String goExternalLinkPubmed;
  private static String goExternalLinkKegg;
  private static String goExternalLinkIhop;
  private static String addSuffix;
  private static String addSuffixForGO;
  private static String goUniprotUrl;
  private static String goExternalLinkGeneCard;

  private static boolean msExpPeaklistUploadCheck;
  
  private static int externalDatabaseInformationRefreshHour;
  private static int externalDatabaseInformationRefreshDay;
  private static int externalDatabaseInformationRefreshMonth;
  
  private static boolean phenyxKeepSearchProteinseqs;
  
  private static ParserPluginClassLoader classLoader;
  private static Vector<ParserClassVO> parserClasses;
  
  private static String expressoBlastServer;
  
  private static Hashtable<String,String> pepMapperProps_;
  private static Hashtable<String,String> modifConfLookup_;
  
  private static Vector<String> uniprotFileNames_;
  
  private static String uniprotDirectory_;

  /** creates singleton of the UtilsConstants*/
  public static UtilsConstants getInstance()
  {
    if (instance_ == null) {
      instance_ = new UtilsConstants();
      try {
        Context ctx = new InitialContext();
        serverSettings = (ServerSettings) ctx
            .lookup("java:/MASPECTRASServerSettings");
        // DATASOURCE_JNDI = serverSettings.getJNDIName();
        serverSettings.getDATABASE();
        UtilsConstants.readServerConfigFile(UtilsConstants
            .getDataRootDirectory()
            + "analyses" + "/" + "partitioning" + "/");
        UtilsConstants.readAvailableParsers();
        java.util.Vector eVect = loadFileUploadTypeXML();
        if (eVect != null) {
          log_.info("Using FileUploadTypeVO from XML File");
          int itemsLess = 0;
          for (int i = 0; i < eVect.size(); i++) {
            FileUploadTypeVO typeVO = (FileUploadTypeVO) eVect.get(i);
            if (!cemmImplementation&&(typeVO.getPathname().equalsIgnoreCase(CATEGORY_CEMM)||
                typeVO.getPathname().equalsIgnoreCase(CATEGORY_CEMM_DEF))){
              itemsLess++;
            }  
          }
          if (cemmImplementation)
            ENUM_FILETYPES = new FileUploadTypeVO[eVect.size()];
          else
            ENUM_FILETYPES = new FileUploadTypeVO[eVect.size()-itemsLess];
          itemsLess = 0;
          for (int i = 0; i < eVect.size(); i++) {
            FileUploadTypeVO typeVO = (FileUploadTypeVO) eVect.get(i);
            if (!cemmImplementation&&(typeVO.getPathname().equalsIgnoreCase(CATEGORY_CEMM)||
                typeVO.getPathname().equalsIgnoreCase(CATEGORY_CEMM_DEF))){
              itemsLess++;
            }else{
              ENUM_FILETYPES[i-itemsLess] = typeVO;
            }  
          }
        } else {
          log_.info("Using FileUploadTypeVO from Upload Utils Class");
          ENUM_FILETYPES = ENUM_FILETYPES_LOCAL;
        }
        pepMapperProps_ = loadPeptidemapperProperties();
        modifConfLookup_ = loadModifConfiguration();
        uniprotDirectory_ = getDataRootDirectory()+"/uniprot/";

      }
      catch (NamingException ex) {
        ex.printStackTrace();
        log_.info(ex);
      }
    }
    return instance_;

  }

  /**
   * Reads the cluster config file
   * @param path to the cluster.properties config file
   */
  /**
   * And Reads the maspectrasForCemm config file
   * @param path to the maspectrasForCemm.properties config file
   */
  public static void readServerConfigFile(String path)
  {
    try {
      FileInputStream in = new FileInputStream(path + "/cluster.properties");
           Properties properties = new Properties();
      properties.load(in);
      in.close();
      //for getting maspectrasSetting properties file..(for Cemm some modifications are included in this .property file)
      FileInputStream inNew = new FileInputStream(path + "/maspectrasSettings.properties");
      Properties maspectrasProperties = new Properties();
      try{
    	 maspectrasProperties.load(inNew);
      inNew.close();
      }catch(Exception e){
    	 e.printStackTrace();
      }
      
      
      UtilsConstants.clusterUsername = properties.getProperty("UserName", "");
      UtilsConstants.clusterPassword = properties.getProperty("Password", "");
      UtilsConstants.clusterURL = properties.getProperty("ServerURL", "");
      UtilsConstants.clusterUpdateIntervall = Integer.parseInt(properties
          .getProperty("UpdateInterval", "1000"));
      UtilsConstants.clusterURLPlusUser = properties.getProperty(
          "ServerURLPlusUser", "");
      UtilsConstants.thresholdForClusterQuantification = Integer
          .parseInt(properties.getProperty(
              "minThresholdForClusterQuantification", "50"));
      UtilsConstants.maxChromSizeForCacheInMB = Integer
      .parseInt(properties.getProperty(
          "maxChromSizeForCacheInMB", "100"));
      UtilsConstants.maxFileSizeForChromTranslationAtOnceInMB = Integer
      .parseInt(properties.getProperty(
          "maxFileSizeForChromTranslationAtOnce", "200"));
      UtilsConstants.translateChromatograms = true;
      
      UtilsConstants.kalignURL = maspectrasProperties.getProperty("kalignURL", "");
      UtilsConstants.muscleURL = maspectrasProperties.getProperty("muscleURL", "");
      UtilsConstants.tCoffeeURL = maspectrasProperties.getProperty("tCoffeeURL", "");
      UtilsConstants.oboURL = maspectrasProperties.getProperty("oboURL", "");
      UtilsConstants.ontologySourceURL = maspectrasProperties.getProperty("ontologySourceURL", "");
      UtilsConstants.ontologySourcefile = maspectrasProperties.getProperty("ontologySourcefile","");
      UtilsConstants.goMaximumLevel = maspectrasProperties.getProperty("maximumLevel","");
      UtilsConstants.goMinimumLevel = maspectrasProperties.getProperty("minimumLevel","");
      
      refreshSampleMSExpCache = false;
      String fromPropertiesFile = maspectrasProperties.getProperty("refreshSampleMSExpCacheOnFirstLogin", "");
      if (fromPropertiesFile!=null&&(fromPropertiesFile.equalsIgnoreCase("true")||fromPropertiesFile.equalsIgnoreCase("yes")))
        refreshSampleMSExpCache = true;
      
      updateMSMachine = false;
      fromPropertiesFile = maspectrasProperties.getProperty("updateMSMachine", "");
      if (fromPropertiesFile!=null&&(fromPropertiesFile.equalsIgnoreCase("true")||fromPropertiesFile.equalsIgnoreCase("yes")))
        updateMSMachine = true;
      updateModIdentifiers = false;
      fromPropertiesFile = maspectrasProperties.getProperty("updateModIdentifiers", "");
      if (fromPropertiesFile!=null&&(fromPropertiesFile.equalsIgnoreCase("true")||fromPropertiesFile.equalsIgnoreCase("yes")))
        updateModIdentifiers = true;

      
      // for connecting with external database links
      UtilsConstants.goExternalLinkEntrezGene = maspectrasProperties.getProperty("getExternalLinkEntrezGene", "");
      UtilsConstants.goExternalLinkEnsembl = maspectrasProperties.getProperty("getExternalLinkEnsembl", "");
      UtilsConstants.goExternalLinkEnsemblHavanna = maspectrasProperties.getProperty("getExternalLinkEnsemblHavanna", "");
      UtilsConstants.goExternalLinkGen3D = maspectrasProperties.getProperty("getExternalLinkGen3D", "");
      UtilsConstants.goExternalLinkGo = maspectrasProperties.getProperty("getExternalLinkGo", "");
      UtilsConstants.goExternalLinkNcbiTaxId = maspectrasProperties.getProperty("getExternalLinkNcbiTaxId", "");
      UtilsConstants.goExternalLinkInterPro = maspectrasProperties.getProperty("getExternalLinkInterPro", "");
      UtilsConstants.goExternalLinkPathoSign = maspectrasProperties.getProperty("getExternalLinkPathoSign", "");
      UtilsConstants.goExternalLinkPfam = maspectrasProperties.getProperty("getExternalLinkPfam", "");
      UtilsConstants.goExternalLinkProsite = maspectrasProperties.getProperty("getExternalLinkProsite", "");
      UtilsConstants.goExternalLinkRefSeq = maspectrasProperties.getProperty("getExternalLinkRefSeq", "");
      UtilsConstants.goExternalLinkSmart = maspectrasProperties.getProperty("getExternalLinkSmart", "");
      UtilsConstants.goExternalLinkUniprotSwissprot = maspectrasProperties.getProperty("getExternalLinkUniprotSwissprot", "");
      UtilsConstants.goExternalLinkUniprotTrembl = maspectrasProperties.getProperty("getExternalLinkUniprotTrembl", "");
      UtilsConstants.goExternalLinkVega = maspectrasProperties.getProperty("getExternalLinkVega", "");
      UtilsConstants.goExternalLinkPubmed = maspectrasProperties.getProperty("getExternalLinkPubmed", "");
      UtilsConstants.goExternalLinkIhop = maspectrasProperties.getProperty("getExternalLinkIhop", "");
      UtilsConstants.goExternalLinkKegg = maspectrasProperties.getProperty("getExternalLinkKegg", "");
      UtilsConstants.goExternalLinkGeneCard = maspectrasProperties.getProperty("getExternalLinkGeneCard", "");
      UtilsConstants.addSuffix = maspectrasProperties.getProperty("getsuffix", "");
      UtilsConstants.addSuffixForGO = maspectrasProperties.getProperty("getsuffixForGO", "");
      UtilsConstants.goUniprotUrl = maspectrasProperties.getProperty("getUniprotUrl", "");
      
      
      
      UtilsConstants.externalDatabaseInformationRefreshHour = Integer.parseInt(maspectrasProperties.getProperty("DbInformationRefreshHour", "2"));
      String refreshDay = maspectrasProperties.getProperty("DbInformationRefreshDay", "2");
      if (refreshDay.equalsIgnoreCase("daily")){
        UtilsConstants.externalDatabaseInformationRefreshDay = Integer.parseInt("0");
      }else{
        UtilsConstants.externalDatabaseInformationRefreshDay = Integer.parseInt(refreshDay);
      }
      String refreshMonth = maspectrasProperties.getProperty("DbInformationRefreshMonth", "monthly");
      if (refreshMonth.equalsIgnoreCase("monthly")){
        UtilsConstants.externalDatabaseInformationRefreshMonth = 0;
      }else{
        if (refreshMonth.equalsIgnoreCase("1")||refreshMonth.equalsIgnoreCase("January")||refreshMonth.equalsIgnoreCase("Jan")){
          UtilsConstants.externalDatabaseInformationRefreshMonth = 1;
        }
        if (refreshMonth.equalsIgnoreCase("2")||refreshMonth.equalsIgnoreCase("February")||refreshMonth.equalsIgnoreCase("Feb")){
          UtilsConstants.externalDatabaseInformationRefreshMonth = 2;
        }
        if (refreshMonth.equalsIgnoreCase("3")||refreshMonth.equalsIgnoreCase("March")||refreshMonth.equalsIgnoreCase("Mar")){
          UtilsConstants.externalDatabaseInformationRefreshMonth = 3;
        }
        if (refreshMonth.equalsIgnoreCase("4")||refreshMonth.equalsIgnoreCase("April")||refreshMonth.equalsIgnoreCase("Apr")){
          UtilsConstants.externalDatabaseInformationRefreshMonth = 4;
        }
        if (refreshMonth.equalsIgnoreCase("5")||refreshMonth.equalsIgnoreCase("May")){
          UtilsConstants.externalDatabaseInformationRefreshMonth = 5;
        }
        if (refreshMonth.equalsIgnoreCase("6")||refreshMonth.equalsIgnoreCase("June")||refreshMonth.equalsIgnoreCase("Jun")){
          UtilsConstants.externalDatabaseInformationRefreshMonth = 6;
        }
        if (refreshMonth.equalsIgnoreCase("7")||refreshMonth.equalsIgnoreCase("July")||refreshMonth.equalsIgnoreCase("Jul")){
          UtilsConstants.externalDatabaseInformationRefreshMonth = 7;
        }
        if (refreshMonth.equalsIgnoreCase("8")||refreshMonth.equalsIgnoreCase("August")||refreshMonth.equalsIgnoreCase("Aug")){
          UtilsConstants.externalDatabaseInformationRefreshMonth = 8;
        }
        if (refreshMonth.equalsIgnoreCase("9")||refreshMonth.equalsIgnoreCase("September")||refreshMonth.equalsIgnoreCase("Sep")){
          UtilsConstants.externalDatabaseInformationRefreshMonth = 9;
        }
        if (refreshMonth.equalsIgnoreCase("10")||refreshMonth.equalsIgnoreCase("October")||refreshMonth.equalsIgnoreCase("Oct")){
          UtilsConstants.externalDatabaseInformationRefreshMonth = 10;
        }
        if (refreshMonth.equalsIgnoreCase("11")||refreshMonth.equalsIgnoreCase("November")||refreshMonth.equalsIgnoreCase("Nov")){
          UtilsConstants.externalDatabaseInformationRefreshMonth = 11;
        }
        if (refreshMonth.equalsIgnoreCase("12")||refreshMonth.equalsIgnoreCase("December")||refreshMonth.equalsIgnoreCase("Dec")){
          UtilsConstants.externalDatabaseInformationRefreshMonth = 12;
        }
      }
      msExpPeaklistUploadCheck = true;
      String readFromFile = maspectrasProperties.getProperty("msExpPeaklistUploadCheck","true");
      if (readFromFile!=null&&(readFromFile.equalsIgnoreCase("false")||readFromFile.equalsIgnoreCase("no")))
        msExpPeaklistUploadCheck = false;
      
      /*      private static Integer externalDatabaseInformationRefreshDay;
      private static Integer externalDatabaseRefreshInformationDay;*/
       
      //only for cemm..for automatic creation of experiment to sample
      UtilsConstants.cemmImplementation= false;
      String cemmImplementation=maspectrasProperties.getProperty("cemmImplementation","false");
      if (cemmImplementation!=null&&(!cemmImplementation.equalsIgnoreCase("false"))&&(!cemmImplementation.equalsIgnoreCase("no")))
          UtilsConstants.cemmImplementation = true;
      

      //just to enable peparml metasearch
      UtilsConstants.pepArMLMetaSearch= false;
      String pepArMLMetaSearch=maspectrasProperties.getProperty("pepArMLMetaSearch","false");
      if (pepArMLMetaSearch!=null&&(!pepArMLMetaSearch.equalsIgnoreCase("false"))&&(!pepArMLMetaSearch.equalsIgnoreCase("no")))
          UtilsConstants.pepArMLMetaSearch = true;
      
      
      UtilsConstants.phenyxKeepSearchProteinseqs = false;
      String phenyxKeep=maspectrasProperties.getProperty("phenyxKeepSearchProteinseqs","false");
      if (phenyxKeep!=null&&(phenyxKeep.equalsIgnoreCase("yes")||phenyxKeep.equalsIgnoreCase("true")))
        UtilsConstants.phenyxKeepSearchProteinseqs = true;      
      
      expressoBlastServer = maspectrasProperties.getProperty("expressoBlastServer",null);
      
      
      String translateThem = properties.getProperty("translateChromatograms", "true");
      
      if (translateThem!=null&&(!translateThem.equalsIgnoreCase("true"))&&(!translateThem.equalsIgnoreCase("yes")))
        UtilsConstants.translateChromatograms = false;
      UtilsConstants.refreshOrganism = false;
      String updateOrganism= properties.getProperty("refreshOrganism", "false");
      if (updateOrganism!=null&&(updateOrganism.equalsIgnoreCase("true")||updateOrganism.equalsIgnoreCase("yes")))
        UtilsConstants.refreshOrganism = true;

      // UtilsConstants.amountOfPeptidesPerNode =
      // properties.getProperty("numberOfPeptidesAtOneNode",PEPTIDES_ONE_NODE_DYNAMIC);
      // if
      // (!UtilsConstants.amountOfPeptidesPerNode.equalsIgnoreCase(PEPTIDES_ONE_NODE_DYNAMIC))
      // Integer.parseInt(UtilsConstants.amountOfPeptidesPerNode);
      
      
      UtilsConstants.numberOfProcessors = Integer.parseInt(properties
          .getProperty("numberOfProcessors", "20"));
      UtilsConstants.annotatorURL = properties.getProperty(
          "AnnotatorServiceAdress", "");
      UtilsConstants.annotatorService = properties.getProperty(
          "AnnotatorServiceName", "");
      
      
      
      UtilsConstants.uniprotFileNames_= new Vector<String>();
      for (short i=0; i!=Short.MAX_VALUE; i++){
        String key = "UniProtDatabase_"+String.valueOf(i+1);
        if (maspectrasProperties.containsKey(key)){
          UtilsConstants.uniprotFileNames_.add(maspectrasProperties.getProperty(key));
        }else break;
      }
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
  
  public static void readAvailableParsers()
  {
    parserClasses = new Vector<ParserClassVO>();
    try {
      String path = System.getProperty("jboss.server.config.url");
      int slash = path.lastIndexOf("/"); // is the same in all Operating Systems
      if (slash != -1) {
        path = path.substring(0, slash);
      }
      slash = path.lastIndexOf("/");
      if (slash != -1) {
        path = path.substring(0, slash+1);
      }
      path = path.replaceFirst("file:", "")+"/sequenceParsers";
      File parserDirectory = new File(path);
      Vector<URL> urls = new Vector<URL>();
      if (parserDirectory.exists()&&parserDirectory.isDirectory()){
        File[] parserJars = parserDirectory.listFiles();
        for (int i=0;i!=parserJars.length;i++){
          File parserJar = parserJars[i];
          if (parserJar.isFile()&&parserJar.getAbsolutePath().endsWith(".jar")){
            JarFile jarFile = new JarFile(parserJar);
            String parserClass = jarFile.getManifest().getMainAttributes().getValue("Parser-Class");
            System.out.println("parserClass: "+parserClass);
            parserClasses.add(new ParserClassVO(parserClass.substring(parserClass.lastIndexOf(".")+1,parserClass.length()),parserClass));
          }
        }
        UtilsConstants.classLoader = new ParserPluginClassLoader(parserDirectory.getAbsolutePath()+"/",true);
//        SequenceInformationParser parser = (SequenceInformationParser)classLoader.loadClass("at.tugraz.genome.maspectras.parser.sequenceInformation.IPIParser").newInstance();
      }
/*      URL[] urlArray = new URL[urls.size()];
      urls.toArray(urlArray);
      URLClassLoader classLoader = new URLClassLoader(urlArray);
      SequenceInformationParser parser = (SequenceInformationParser)classLoader.loadClass("at.tugraz.genome.maspectras.parser.sequenceInformation.IPIParser").newInstance();
      parser.wrightSomethingOut("");*/
    }    
    catch (Exception e) {
      e.printStackTrace();
    }
  }
  /**
   * @return the generic DAO factory for the JDBC connections
   */
  public static GenericDAOFactory getDAOFactory()
  {
    return GenericDAOFactory
        .getDAOFactory("at.tugraz.genome.maspectras.utils.dao.MASPECTRASDAOFactory");
  }

  /** JNDI name of the datasource*/
  public static String DATASOURCE_JNDI = ServerSettings.getDATABASEJNDIName();

  /**
   * @return the possible file upload types
   */
  private static java.util.Vector loadFileUploadTypeXML()
  {
    log_.info("loadFileUploadTypeXML");
    Document document = null;
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    try {
      java.util.Vector eVector = new java.util.Vector();
      DocumentBuilder builder = factory.newDocumentBuilder();
      String path = "config/FileUploadTypes.xml";
      if (!getDataRootDirectory().endsWith("/")) {
        path = "/" + path;
      }
      File f = new File(getDataRootDirectory() + path);
      InputStream inStream = new FileInputStream(f);
      // builder.parse(f) is not working on Windows Systems
      document = builder.parse(inStream);
      Element root = document.getDocumentElement();
      root.normalize();
      parseXMLDocument(root, eVector);
      builder = null;
      factory = null;
      return eVector;
    }
    catch (SAXParseException spe) {
      Exception x = spe;
      if (spe.getException() != null)
        x = spe.getException();
      x.printStackTrace();
    }
    catch (SAXException sxe) {
      Exception x = sxe;
      if (sxe.getException() != null)
        x = sxe.getException();
      x.printStackTrace();
    }
    catch (ParserConfigurationException pce) {
      pce.printStackTrace();
    }
    catch (IOException ioe) {
      ioe.printStackTrace();
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
    return null;
  }
  
  private static Hashtable<String,String> loadPeptidemapperProperties(){
    String path = "config/Peptidemapper.properties";
    if (!getDataRootDirectory().endsWith("/")) {
      path = "/" + path;
    }
    File f = new File(getDataRootDirectory() + path);
    Hashtable<String,String> props = new Hashtable<String,String>();
    if (f.exists()){
      try {
        LineNumberReader reader = new LineNumberReader(new FileReader(f.getAbsolutePath()));
        String line;
        while ((line = reader.readLine()) != null) {
          int equalIndex = line.indexOf("=");
          if (equalIndex!=-1){
            String key = line.substring(0,equalIndex).trim();
            String value = line.substring(equalIndex+1).trim();
            props.put(key, value);
          }
        }
        reader.close();
      }
      catch (IOException e) {
        e.printStackTrace();
      }
    }
    return props;
  }
  
  private static Hashtable<String,String> loadModifConfiguration(){
    Hashtable<String,String> hash = new Hashtable<String,String>();
    String path = "config/modifconv.csv";
    if (!getDataRootDirectory().endsWith("/")) {
      path = "/" + path;
    }
    File f = new File(getDataRootDirectory() + path);
    if (f.exists()){
      try{
        LineNumberReader reader = new LineNumberReader(new FileReader(f.getAbsolutePath()));
        String line;
        while ((line = reader.readLine())!=null){
          if (line.startsWith("#")) continue;
          StringTokenizer tokenizer = new StringTokenizer(line,"\t");
          if (tokenizer.countTokens()==2){
            String key = tokenizer.nextToken().trim();
            String value = tokenizer.nextToken().trim();
            hash.put(key, value);
          }
        }
      }catch(Exception ex){
        ex.printStackTrace();
      }
    }
    return hash;
  }

  /**
   * @return the path to the stored data
   */
  public static String getDataRootDirectory()
  {
    String dataRootDirectory;
    if (instance_ == null) {
      instance_ = getInstance();
    }
    dataRootDirectory = serverSettings
        .getProperty(ServerSettings.PROPERTY_DATAROOTDIRECTORY);
    return dataRootDirectory;
  }

  /**
   * Parses the XML document with the file types
   * @param currentNode current Node
   * @param eVector Vector of possible file types
   */
  public static void parseXMLDocument(Node currentNode, java.util.Vector eVector)
  {
    String displayName = "";
    String pathName = "";
    if (currentNode.getNodeName().compareTo("FileUploadType") == 0) {
      displayName = currentNode.getAttributes().getNamedItem("DisplayName")
          .getNodeValue();
      pathName = currentNode.getAttributes().getNamedItem("PathName")
          .getNodeValue();
      FileUploadTypeVO fileUploadTypeVO = new FileUploadTypeVO(displayName,
          pathName);
      eVector.add(fileUploadTypeVO);
    }
    NodeList list = currentNode.getChildNodes();
    for (int k = 0; k < list.getLength(); k++) {
      Node nd = list.item(k);
      parseXMLDocument(nd, eVector);
    }
  }

  /**
   * @return the database type (Oracle,MySQL,...)
   */
  public static String getDatabase()
  {
    String databaseString = Databases.ORACLE;
    if (instance_ == null) {
      instance_ = getInstance();
    }
    databaseString = serverSettings
        .getProperty(ServerSettings.PROPERTY_DATABASE);
    return databaseString;
  }

  /**
   * @return if a guest user is allowed
   */
  public static boolean getGuestUserAllowed()
  {
    String guestUserAllowed;
    if (instance_ == null) {
      instance_ = getInstance();
    }
    guestUserAllowed = serverSettings
        .getProperty(ServerSettings.PROPERTY_GUESTUSERALLOWED);
    boolean retValue = false;
    try {
      retValue = new Boolean(guestUserAllowed).booleanValue();
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
    return retValue;
  }

  /**
   * @return the file upload types
   */
  public static FileUploadTypeVO[] getFileUploadTypes()
  {
    if (instance_ == null) {
      instance_ = getInstance();
    }
    return ENUM_FILETYPES;
  }

  /**
   * @return the guest user identity
   */
  public static Long getGuestUserId()
  {
    return new Long(2012);
  }

  /**
   * @return the search operators
   */
  public static java.util.Collection getSearchOperators()
  {
    java.util.Vector vector = new java.util.Vector();
    SimpleValueObject svo = new SimpleValueObject("Like", "Like");
    vector.add(svo);
    svo = new SimpleValueObject("Not Like", "Not Like");
    vector.add(svo);
    svo = new SimpleValueObject(">", ">");
    vector.add(svo);
    svo = new SimpleValueObject(">=", ">=");
    vector.add(svo);
    svo = new SimpleValueObject("=", "=");
    vector.add(svo);
    svo = new SimpleValueObject("<>", "<>");
    vector.add(svo);
    svo = new SimpleValueObject("<=", "<=");
    vector.add(svo);
    svo = new SimpleValueObject("<", "<");
    vector.add(svo);
    svo = new SimpleValueObject("Between", "Between");
    vector.add(svo);
    svo = new SimpleValueObject("Not Between", "Not Between");
    vector.add(svo);
    svo = new SimpleValueObject("In", "In");
    vector.add(svo);
    svo = new SimpleValueObject("Not In", "Not In");
    vector.add(svo);
    return vector;
  }

  /** file type of Mascot files */
  public static final String CATEGORY_MASCOT = "mascot";
  /** file type of SpectrumMill files */
  public static final String CATEGORY_SPECRUMMILL = "spectrummill";
  /** file type of SpectrumMill files old version */
  public static final String CATEGORY_SPECRUMMILL_OLD = "spectrummill_old";
  /** file type of SpectrumMill config file */
  public static final String CATEGORY_SM_CONF = "smconfig";
  /** file type of Combined search config file for PepARML */
  public static final String CATEGORY_SEARCH_CONF = "searchconfig";
  /** file type of SpectrumMill user config file */
  public static final String CATEGORY_SM_USER_CONF = "smcustomconfig";
  /** file type of Sequest files */
  public static final String CATEGORY_SEQUEST = "sequest";
  /** file type of X!Tandem files */
  public static final String CATEGORY_XTANDEM = "xtandem";
  /** file type of OMSSA files */
  public static final String CATEGORY_OMSSA = "omssa";
  /** file type of OMSSA modification files */
  public static final String CATEGORY_OMSSA_MOD = "omssa_mod";
  /** file type of Phenyx files */
  public static final String CATEGORY_PHENYX = "phenyx";
  /** file type of CeMM files */
  public static final String CATEGORY_CEMM = "cemm";
  /** file type of CeMM definition file */
  public static final String CATEGORY_CEMM_DEF = "cemm_def";
  /** file type of PepArML pepXML */
  public static final String CATEGORY_PEPARML_PEPXML = "peparml";
  /** file type of TPP pepXML */
  public static final String CATEGORY_TPP_PEPXML = "pepxml";
  /** file type of TPP pepXML */
  public static final String CATEGORY_TPP_PROTXML = "protxml";
  /** file type of raw data files */
  public static final String CATEGORY_RAW_DATA = "rawdata";
  /** file type of MS parameters files */
  public static final String CATEGORY_MASSSPECEXPERIMENT_PARAMETERS = "ms_parameters";
  /** file type of 1D gel annotated images */
  public static final String CATEGORY_GEL1D_ANNOTATED = "gel1d_annotated";
  /** file type of 1D gel raw images */
  public static final String CATEGORY_GEL1D_RAW = "gel1d_raw";
  /** file type of 1D gel warped images */
  public static final String CATEGORY_GEL1D_WARPED = "gel1d_warped";
  /** file type of 1D gel warping maps */
  public static final String CATEGORY_GEL1D_WARPINGMAP = "gel1d_warpingmap";
  /** file type of 2D gel annotated images */
  public static final String CATEGORY_GEL2D_ANNOTATED = "gel2d_annotated";
  /** file type of 2D gel raw images */
  public static final String CATEGORY_GEL2D_RAW = "gel2d_raw";
  /** file type of 2D gel warped images */
  public static final String CATEGORY_GEL2D_WARPED = "gel2d_warped";
  /** file type of 2D gel warping maps */
  public static final String CATEGORY_GEL2D_WARPINGMAP = "gel2d_warpingmap";
  /** file type of lc column paramers */
  public static final String CATEGORY_LCCOLUMN_PARAMETERS = "lccolumn_parameters";
  /** file type of gel mass filter */
  public static final String GEL_MASS_FILTER = "gel_mass_filter";
  /** possible upload status type: QUEUED */
  public static final String UPLOADSTATUSQUEUED = GlobalConstants.UPLOADSTATUSQUEUED;
  /** possible upload status type: LOADING */
  public static final String UPLOADSTATUSLOADING = "LOADING";
  /** possible upload status type: LOADING FINISHED */
  public static final String UPLOADSTATUSFINISHED = GlobalConstants.UPLOADSTATUSFINISHED;
  /** possible upload status type: REMOVING FINISHED */
  public static final String UPLOADSTATUSREMOVED = "REMOVING FINISHED";
  /** possible upload status type: REMOVING*/
  public static final String UPLOADSTATUSREMOVING = "REMOVING";
  /** possible upload status type: CALCULATING*/
  public static final String UPLOADSTATUSCALCULATING = "CALCULATING";
  /** possible upload status type: FAILURE*/
  public static final String UPLOADSTATUSFAILURE = GlobalConstants.UPLOADSTATUSFAILURE;
  /** possible upload status type: CALCULATION QUEUED*/
  public static final String UPLOADSTATUSCALCULATIONQUEUED = "CALCULATION QUEUED";
  /** possible upload status type: PREPARING CALCULATION AND REMOVING OLD ENTRIES*/
  public static final String UPLOADSTATUSREMOVECALCULATION = "PREPARING CALCULATION AND REMOVING OLD ENTRIES";
  /** Status when the translation to the chromatogram file is finished*/
  public static final String UPLOADSTATUSTRANSLATED = "TRANSLATION FINISHED";
  /** possible upload status type: CALCULATING*/
  public static final String UPLOADSTATUSEXPORTING = "EXPORTING";

  
  /** download category: pride xml */
  public static final String FILE_DOWNLOAD_CATEGORY_PRIDE = "pride";
  /** download category: quant info */
  public static final String FILE_DOWNLOAD_CATEGORY_QUANTINFO = "quantInfo";
  /** download category: swath */
  public static final String FILE_DOWNLOAD_CATEGORY_SWATH = "swath";
  /** download category: spectra */
  public static final String FILE_DOWNLOAD_CATEGORY_SPECTRA = "spectra";

  public static final String FILE_DOWNLOAD_CATEGORY_PEPTIDES = "peptide";

  public static final String FILE_DOWNLOAD_CATEGORY_PROTEINS = "protein";

  
  /**
   * @return the password for the cluster
   */
  public static String getClusterPassword()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return clusterPassword;
  }

  /**
   * @return the URL for the cluster
   */
  public static String getClusterURL()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }

    return clusterURL;
  }
  /**
   * @return the username for the cluster usre
   */
  public static String getClusterUsername()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return clusterUsername;
  }
  /**
   * @return the update intervall to retrieve information from the cluster jobs
   */
  public static int getClusterUpdateIntervall()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return clusterUpdateIntervall;
  }
  /**
   * @return the URL plus username and password for the connection to the cluster
   */
  public static String getClusterURLPlusUser()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return clusterURLPlusUser;
  }
  /**
   * @return threshold in amount of peptides to send a quantification to the cluster
   */
  public static int getThresholdForClusterQuantification()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return thresholdForClusterQuantification;
  }
  /**
   * @return number of processors available for the quantification
   */
  public static int getNumberOfProcessors()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return numberOfProcessors;
  }
  /**
   * @return threshold in file size of chrom file for automatic quantification using cache
   */
  public static int getMaxChromSizeForCacheInMB()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.maxChromSizeForCacheInMB;
  }
  
  /**
   * @return the file pieces for the file translation to the chrom file
   */
  public static int getmMaxFileSizeForChromTranslationAtOnceInMB()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.maxFileSizeForChromTranslationAtOnceInMB;
  }
  
  public static boolean pepArMLMetaSearch()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.pepArMLMetaSearch;
  }
  public static boolean cemmImplementation()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.cemmImplementation;
  }
  
  /**
   * @return if the translation to the chromatogram file should take place
   */
  public static boolean translateChromatograms()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.translateChromatograms;
  }
  
  /**
   * @return URL to the annotator of the IMP
   */
  public static String getAnnotatorServiceUrl()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.annotatorURL;
  }
  /**
   * @return the SOAP service name of the annotator of the IMP
   */
  public static String getAnnotatorServiceName()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.annotatorService;
  }
  
  public static int getExternalDatabaseInformationRefreshHour()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.externalDatabaseInformationRefreshHour;
  }
  
  public static int getExternalDatabaseInformationRefreshDay()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.externalDatabaseInformationRefreshDay;
  }
  
  public static int getExternalDatabaseInformationRefreshMonth()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.externalDatabaseInformationRefreshMonth;
  }
  
  public static Class getSequenceInformationParserInstance(String parserClass)throws ClassNotFoundException{
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.classLoader.loadClass(parserClass);
  }
  
  public static Vector<ParserClassVO> getExternalDatabaseParsers(){
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.parserClasses;
  }

/**
 * @return the goExternalLinkEntrezGene
 */
public static String getGoExternalLinkEntrezGene() {
	String goExternalLinkEntrezGene=UtilsConstants.goExternalLinkEntrezGene;
	return goExternalLinkEntrezGene;
}

/**
 * @param goExternalLinkEntrezGene the goExternalLinkEntrezGene to set
 */
public static void setGoExternalLinkEntrezGene(String goExternalLinkEntrezGene) {
	UtilsConstants.goExternalLinkEntrezGene = goExternalLinkEntrezGene;
}

/**
 * @return the goExternalLinkGen3D
 */
public static String getGoExternalLinkGen3D() {
	String goExternalLinkGen3D=UtilsConstants.goExternalLinkGen3D;
	return goExternalLinkGen3D;
}

/**
 * @param goExternalLinkGen3D the goExternalLinkGen3D to set
 */
public static void setGoExternalLinkGen3D(String goExternalLinkGen3D) {
	UtilsConstants.goExternalLinkGen3D = goExternalLinkGen3D;
}

/**
 * @return the goExternalLinkGo
 */
public static String getGoExternalLinkGo() {
	String goExternalLinkGo=UtilsConstants.goExternalLinkGo;
	return goExternalLinkGo;
}

/**
 * @param goExternalLinkGo the goExternalLinkGo to set
 */
public static void setGoExternalLinkGo(String goExternalLinkGo) {
	UtilsConstants.goExternalLinkGo = goExternalLinkGo;
}

/**
 * @return the goExternalLinkInterPro
 */
public static String getGoExternalLinkInterPro() {
	String goExternalLinkInterPro=UtilsConstants.goExternalLinkInterPro;
	return goExternalLinkInterPro;
}

/**
 * @param goExternalLinkInterPro the goExternalLinkInterPro to set
 */
public static void setGoExternalLinkInterPro(String goExternalLinkInterPro) {
	UtilsConstants.goExternalLinkInterPro = goExternalLinkInterPro;
}

/**
 * @return the goExternalLinkNcbiTaxId
 */
public static String getGoExternalLinkNcbiTaxId() {
	String goExternalLinkNcbiTaxId=UtilsConstants.goExternalLinkNcbiTaxId;
	return goExternalLinkNcbiTaxId;
}

/**
 * @param goExternalLinkNcbiTaxId the goExternalLinkNcbiTaxId to set
 */
public static void setGoExternalLinkNcbiTaxId(String goExternalLinkNcbiTaxId) {
	UtilsConstants.goExternalLinkNcbiTaxId = goExternalLinkNcbiTaxId;
}

/**
 * @return the goExternalLinkPathoSign
 */
public static String getGoExternalLinkPathoSign() {
	String goExternalLinkPathoSign=UtilsConstants.goExternalLinkPathoSign;
	return goExternalLinkPathoSign;
}

/**
 * @param goExternalLinkPathoSign the goExternalLinkPathoSign to set
 */
public static void setGoExternalLinkPathoSign(String goExternalLinkPathoSign) {
	UtilsConstants.goExternalLinkPathoSign = goExternalLinkPathoSign;
}

/**
 * @return the goExternalLinkPfam
 */
public static String getGoExternalLinkPfam() {
	String goExternalLinkPfam=UtilsConstants.goExternalLinkPfam;
	return goExternalLinkPfam;
}

/**
 * @param goExternalLinkPfam the goExternalLinkPfam to set
 */
public static void setGoExternalLinkPfam(String goExternalLinkPfam) {
	UtilsConstants.goExternalLinkPfam = goExternalLinkPfam;
}

/**
 * @return the goExternalLinkProsite
 */
public static String getGoExternalLinkProsite() {
	String goExternalLinkProsite=UtilsConstants.goExternalLinkProsite;
	return goExternalLinkProsite;
}

/**
 * @param goExternalLinkProsite the goExternalLinkProsite to set
 */
public static void setGoExternalLinkProsite(String goExternalLinkProsite) {
	UtilsConstants.goExternalLinkProsite = goExternalLinkProsite;
}

/**
 * @return the goExternalLinkRefSeq
 */
public static String getGoExternalLinkRefSeq() {
	String goExternalLinkRefSeq=UtilsConstants.goExternalLinkRefSeq;
	return goExternalLinkRefSeq;
}

/**
 * @param goExternalLinkRefSeq the goExternalLinkRefSeq to set
 */
public static void setGoExternalLinkRefSeq(String goExternalLinkRefSeq) {
	UtilsConstants.goExternalLinkRefSeq = goExternalLinkRefSeq;
}

/**
 * @return the goExternalLinkSmart
 */
public static String getGoExternalLinkSmart() {
	String goExternalLinkSmart=UtilsConstants.goExternalLinkSmart;
	return goExternalLinkSmart;
}

/**
 * @param goExternalLinkSmart the goExternalLinkSmart to set
 */
public static void setGoExternalLinkSmart(String goExternalLinkSmart) {
	UtilsConstants.goExternalLinkSmart = goExternalLinkSmart;
}

/**
 * @return the goExternalLinkUniprotSwissprot
 */
public static String getGoExternalLinkUniprotSwissprot() {
	String goExternalLinkUniprotSwissprot=UtilsConstants.goExternalLinkUniprotSwissprot;
	return goExternalLinkUniprotSwissprot;
}

/**
 * @param goExternalLinkUniprotSwissprot the goExternalLinkUniprotSwissprot to set
 */
public static void setGoExternalLinkUniprotSwissprot(
		String goExternalLinkUniprotSwissprot) {
	UtilsConstants.goExternalLinkUniprotSwissprot = goExternalLinkUniprotSwissprot;
}

/**
 * @return the goExternalLinkUniprotTrembl
 */
public static String getGoExternalLinkUniprotTrembl() {
	String goExternalLinkUniprotTrembl=UtilsConstants.goExternalLinkUniprotTrembl;
	return goExternalLinkUniprotTrembl;
}

/**
 * @param goExternalLinkUniprotTrembl the goExternalLinkUniprotTrembl to set
 */
public static void setGoExternalLinkUniprotTrembl(
		String goExternalLinkUniprotTrembl) {
	UtilsConstants.goExternalLinkUniprotTrembl = goExternalLinkUniprotTrembl;
}

/**
 * @return the goExternalLinkVega
 */
public static String getGoExternalLinkVega() {
	String goExternalLinkVega=UtilsConstants.goExternalLinkVega;
	return goExternalLinkVega;
}

/**
 * @param goExternalLinkVega the goExternalLinkVega to set
 */
public static void setGoExternalLinkVega(String goExternalLinkVega) {
	UtilsConstants.goExternalLinkVega = goExternalLinkVega;
}

/**
 * @return the addSuffix
 */
public static String getAddSuffix() {
	String addSuffix=UtilsConstants.addSuffix;
	return addSuffix;
}

/**
 * @param addSuffix the addSuffix to set
 */
public static void setAddSuffix(String addSuffix) {
	UtilsConstants.addSuffix = addSuffix;
}

/**
 * @return the goExternalLinkEnsembl
 */
public static String getGoExternalLinkEnsembl() {
	String goExternalLinkEnsembl=UtilsConstants.goExternalLinkEnsembl;
	return goExternalLinkEnsembl;
}

/**
 * @param goExternalLinkEnsembl the goExternalLinkEnsembl to set
 */
public static void setGoExternalLinkEnsembl(String goExternalLinkEnsembl) {
	UtilsConstants.goExternalLinkEnsembl = goExternalLinkEnsembl;
}

/**
 * @return the goExternalLinkEnsemblHavanna
 */
public static String getGoExternalLinkEnsemblHavanna() {
	String goExternalLinkEnsemblHavanna=UtilsConstants.goExternalLinkEnsemblHavanna;
	return goExternalLinkEnsemblHavanna;
}

/**
 * @param goExternalLinkEnsemblHavanna the goExternalLinkEnsemblHavanna to set
 */
public static void setGoExternalLinkEnsemblHavanna(
		String goExternalLinkEnsemblHavanna) {
	UtilsConstants.goExternalLinkEnsemblHavanna = goExternalLinkEnsemblHavanna;
}

/**
 * @return the goExternalLinkPubmed
 */
public static String getGoExternalLinkPubmed() {
	String goExternalLinkPubmed=UtilsConstants.goExternalLinkPubmed;
	return goExternalLinkPubmed;
}

/**
 * @param goExternalLinkPubmed the goExternalLinkPubmed to set
 */
public static void setGoExternalLinkPubmed(String goExternalLinkPubmed) {
		UtilsConstants.goExternalLinkPubmed = goExternalLinkPubmed;
}

/**
 * @return the goExternalLinkKegg
 */
public static String getGoExternalLinkKegg() {
	String goExternalLinkKegg=UtilsConstants.goExternalLinkKegg;
	return goExternalLinkKegg;
}

/**
 * @param goExternalLinkKegg the goExternalLinkKegg to set
 */
public static void setGoExternalLinkKegg(String goExternalLinkKegg) {
	UtilsConstants.goExternalLinkKegg = goExternalLinkKegg;
}

/**
 * @return the goExternalLinkIhop
 */
public static String getGoExternalLinkIhop() {
	String goExternalLinkIhop=UtilsConstants.goExternalLinkIhop;
	return goExternalLinkIhop;
}

/**
 * @param goExternalLinkIhop the goExternalLinkIhop to set
 */
public static void setGoExternalLinkIhop(String goExternalLinkIhop) {
	UtilsConstants.goExternalLinkIhop = goExternalLinkIhop;
}

/**
 * @return the goExternalLinkGeneCard
 */
public static String getGoExternalLinkGeneCard() {
	String goExternalLinkGeneCard=UtilsConstants.goExternalLinkGeneCard;
	return goExternalLinkGeneCard;
}

/**
 * @param goExternalLinkGeneCard the goExternalLinkGeneCard to set
 */
public static void setGoExternalLinkGeneCard(String goExternalLinkGeneCard) {
	UtilsConstants.goExternalLinkGeneCard = goExternalLinkGeneCard;
}  

/**
 * @return the addSuffixForGO
 */
public static String getAddSuffixForGO() {
	UtilsConstants.addSuffixForGO = addSuffixForGO;
	return addSuffixForGO;
}

/**
 * @param addSuffixForGO the addSuffixForGO to set
 */
public static void setAddSuffixForGO(String addSuffixForGO) {
	UtilsConstants.addSuffixForGO = addSuffixForGO;
}

/**
 * @return the goUniprotUrl
 */
public static String getGoUniprotUrl() {
	UtilsConstants.goUniprotUrl = goUniprotUrl;
	return goUniprotUrl;
}

/**
 * @param goUniprotUrl the goUniprotUrl to set
 */
public static void setGoUniprotUrl(String goUniprotUrl) {
	UtilsConstants.goUniprotUrl = goUniprotUrl;
}

/**
 * @return the kalignURL
 */
public static String getKalignURL() {
	UtilsConstants.kalignURL=kalignURL;
	return kalignURL;
}

/**
 * @param kalignURL the kalignURL to set
 */
public static void setKalignURL(String kalignURL) {
	UtilsConstants.kalignURL = kalignURL;
}

  public static boolean getMsExpPeaklistUploadCheck(){
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.msExpPeaklistUploadCheck;
  }
  
  public static boolean getRefreshSampleMSExpCache(){
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.refreshSampleMSExpCache;
  }
  public static void setRefreshSampleMSExpCache(boolean refreshSampleMSExpCache){
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    UtilsConstants.refreshSampleMSExpCache = refreshSampleMSExpCache;
  }
  
  public static boolean getUpdateMSMachine(){
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.updateMSMachine;
  }
  
  public static void setUpdateMSMachine(boolean updateMSMachine){
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    UtilsConstants.updateMSMachine = updateMSMachine;
  }
  
  public static boolean getUpdateModIdentifiers(){
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.updateModIdentifiers;
  }
  
  public static void setUpdateModIdentifiers(boolean updateModIdentifiers){
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    UtilsConstants.updateModIdentifiers = updateModIdentifiers;
  }

/**
 * @return the muscleURL
 */
public static String getMuscleURL() {
	UtilsConstants.muscleURL=muscleURL;
	return muscleURL;
}

/**
 * @param muscleURL the muscleURL to set
 */
public static void setMuscleURL(String muscleURL) {
	UtilsConstants.muscleURL = muscleURL;
}

/**
 * @return the tCoffeeURL
 */
public static String getTCoffeeURL() {
	UtilsConstants.tCoffeeURL=tCoffeeURL;
	return tCoffeeURL;
}

/**
 * @param coffeeURL the tCoffeeURL to set
 */
public static void setTCoffeeURL(String coffeeURL) {
	UtilsConstants.tCoffeeURL=tCoffeeURL;
}

/**
 * @return if the translation to the chromatogram file should take place
 */
public static boolean refreshOrganism()
{
  if (instance_ == null) {
    UtilsConstants.getInstance();
  }
  return UtilsConstants.refreshOrganism;
}

/**
 * @return the oboURL
 */
public static String getOboURL() {
	UtilsConstants.oboURL=oboURL;
	return oboURL;
}

/**
 * @param oboURL the oboURL to set
 */
public static void setOboURL(String oboURL) {
	UtilsConstants.oboURL=oboURL;
}

/**
 * @return the ontologySourceURL
 */
public static String getOntologySourceURL() {
	UtilsConstants.ontologySourceURL = ontologySourceURL;
	return ontologySourceURL;
}

/**
 * @param ontologySourceURL the ontologySourceURL to set
 */
public static void setOntologySourceURL(String ontologySourceURL) {
	UtilsConstants.ontologySourceURL = ontologySourceURL;
}

/**
 * @return the ontologySourcefile
 */
public static String getOntologySourcefile() {
	UtilsConstants.ontologySourcefile = ontologySourcefile;
	return ontologySourcefile;
}

/**
 * @param ontologySourcefile the ontologySourcefile to set
 */
public static void setOntologySourcefile(String ontologySourcefile) {
	UtilsConstants.ontologySourcefile = ontologySourcefile;
}

/**
 * @return the goMinimumLevel
 */
public static String getGoMinimumLevel() {
	UtilsConstants.goMinimumLevel = goMinimumLevel;
	return goMinimumLevel;
}

/**
 * @param goMinimumLevel the goMinimumLevel to set
 */
public static void setGoMinimumLevel(String goMinimumLevel) {
	UtilsConstants.goMinimumLevel = goMinimumLevel;
}

/**
 * @return the goMaximumLevel
 */
public static String getGoMaximumLevel() {
	UtilsConstants.goMaximumLevel = goMaximumLevel;
	return goMaximumLevel;
}

/**
 * @param goMaximumLevel the goMaximumLevel to set
 */
public static void setGoMaximumLevel(String goMaximumLevel) {
	UtilsConstants.goMaximumLevel = goMaximumLevel;
}

  public static String getExpressoBlastServer()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.expressoBlastServer;
  }

  public static boolean isPhenyxKeepSearchProteinseqs()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.phenyxKeepSearchProteinseqs;
  }
  
  /**
   * Returns corresponding PeptideMapper Property.
   * If there is no entry for the key, null is returned.
   * @param key
   * @return property
   */
  public static String getPepmapperProperty(String key){
    if (instance_ == null) {
      instance_ = getInstance();
    }
    String prop = null;
    if (pepMapperProps_.containsKey(key)) prop = pepMapperProps_.get(key); 
    return prop;
  }
  
  /**
   * Returns corresponding modification for the quantitation info export.
   * If there is no entry for the key, null is returned.
   * @param key
   * @return property
   */
  public static String getModificationCompatibleForExport(String key){
    if (instance_ == null) {
      instance_ = getInstance();
    }
    String prop = null;
    if (modifConfLookup_.containsKey(key)) prop = modifConfLookup_.get(key); 
    return prop;
  }
  
  public static Vector<String> getUniprotFileNames()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.uniprotFileNames_;
  }
  
  public static String getUniprotDirectory()
  {
    if (instance_ == null) {
      UtilsConstants.getInstance();
    }
    return UtilsConstants.uniprotDirectory_;
  }
}