package at.tugraz.genome.voutils;

/*
 * <p> Title: Template Struts Project </p><p> Description: </p><p> Copyright:
 * Copyright (c) 2002 </p><p> Company: </p> @author not attributable
 * 
 * @version 1.0
 */

import java.lang.reflect.*;
import java.util.Comparator;

public class GeneralComparator implements Comparator
{
  private Method getterMethod = null;

  private Method getterMethodParentClass = null;

  private Method compareMethod = null;

  public GeneralComparator(String getterClassName, String getterFunctionName,
      String compareClassName)
  {
    this(getterClassName, getterFunctionName, null, null, compareClassName);
  }

  public GeneralComparator(String getterClassName, String getterFunctionName,
      String getterNameParentClass, String getterFunctionNameParentClass,
      String compareClassName)
  {
    Class[] compareParameters = { (new Object()).getClass() };
    try {
      getterMethod = Class.forName(getterClassName).getMethod(
          getterFunctionName, new Class[0]);
      compareMethod = Class.forName(compareClassName).getMethod("compareTo",
          compareParameters);
      if (getterNameParentClass != null) {
        getterMethodParentClass = Class.forName(getterNameParentClass)
            .getMethod(getterFunctionNameParentClass, new Class[0]);
      }
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
  }

  public int compare(Object o1, Object o2)
  {
    if ((o1 == null) && (o2 == null))
      return 0;
    if (o1 == null)
      return 1;
    if (o2 == null)
      return -1;
    Object[] getterParameters = new Object[0];
    Object[] compareParameters = new Object[1];
    int result = Integer.MIN_VALUE;
    try {
      if (this.getterMethodParentClass != null) {
        o1 = getterMethodParentClass.invoke(o1, new Object[0]);
        o2 = getterMethodParentClass.invoke(o2, new Object[0]);
        if ((o1 == null) && (o2 == null))
          return 0;
        if (o1 == null)
          return 1;
        if (o2 == null)
          return -1;
      }
      Object value1 = getterMethod.invoke(o1, getterParameters);
      Object value2 = getterMethod.invoke(o2, getterParameters);
      if ((value1 == null) && (value2 == null))
        return 0;
      if (value1 == null)
        return 1;
      if (value2 == null)
        return -1;
      compareParameters[0] = (Object) value2;
      result = ((Integer) compareMethod.invoke(value1, compareParameters))
          .intValue();
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
    return result;
  }

  public boolean equals(Object obj)
  {
    return obj.equals(this);
  }
}
