/*
 * Directory-Utils functions for MPI-Swarm
 * (C) 2002 Gernot Stocker gernot.stocker@tugraz.at
 *
 * Released under GPL
 */
#include <dirent.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "dirutil.h"

extern int alphasort();

int select_function(const struct dirent *entry)
{
 if (strcmp(entry->d_name,".")==0) return(0);
 if (strcmp(entry->d_name,"..")==0) return(0);
 return(1);
}

directory_handle_ptr new_directory_handle(char *directory_path)
{
  directory_handle_ptr new_directory_handle;
  int entry_nr;
  new_directory_handle=(directory_handle_ptr) calloc(1, sizeof(directory_handle));

  if (directory_path==NULL || new_directory_handle==NULL)
  {
    return NULL;
  }
  new_directory_handle->path=strdup(directory_path);
  new_directory_handle->entry_nr=scandir(directory_path, &new_directory_handle->entry_store, select_function, alphasort);
  entry_nr=new_directory_handle->entry_nr;
  if (entry_nr < 0)
  {
     free(new_directory_handle);
     return NULL;
  }
  new_directory_handle->actual_entry=-1;
  return(new_directory_handle);
}

void delete_directory_handle(directory_handle_ptr actual_directory_handle)
{
  int lauf=0;
  if (actual_directory_handle == NULL) return;
  lauf=actual_directory_handle->entry_nr;
  while(lauf-- > 0)
  {
       free( actual_directory_handle->entry_store[lauf] );
  }
  free(actual_directory_handle->entry_store);
  if(actual_directory_handle) free(actual_directory_handle);
}

void reset_directory_handle(directory_handle_ptr actual_directory_handle)
{
  if(actual_directory_handle == NULL) return;
  actual_directory_handle->actual_entry=-1;
}

void print_directory_handle(directory_handle_ptr actual_directory_handle)
{
     int entry_nr=0;
     if(actual_directory_handle == NULL) return;
     entry_nr=actual_directory_handle->entry_nr;
     while(entry_nr-- > 0)
     {
       printf("%s\n", actual_directory_handle->entry_store[entry_nr]->d_name);
     }
}

int is_a_file(char *path, char *filename)
{
  struct stat file_stat;

  char *full_path;
  int ret_val=-1;
  full_path=(char *)calloc((strlen(path)+strlen(filename)+3), sizeof(char));
  snprintf(full_path, (strlen(path)+strlen(filename)+2),"%s/%s",path,filename);
  lstat(full_path, &file_stat);
  
  if (S_ISREG(file_stat.st_mode))
    ret_val=0;
  else
    ret_val=1;
    
  free(full_path);
  return(ret_val);
}

char * prepare_filename_for_return(char* input_filename, int mode)
{
  char *file_name;
  file_name=input_filename;
  if (mode==ALLOC_STRING_MODE)
     {
       file_name=strdup(input_filename);
     }
     else
     {
       file_name=input_filename;
     }
  return file_name;
}

/*
 * Returns only readable files and no directoriey
 */
char * get_next_filename(directory_handle_ptr actual_directory_handle, int mode)
{
  char *file_name=NULL;
#ifdef DEBUG
  FILE *logfile;
#endif
  if(actual_directory_handle == NULL) return NULL;
  actual_directory_handle->actual_entry++;

  while((actual_directory_handle->actual_entry >= 0) && (actual_directory_handle->actual_entry < actual_directory_handle->entry_nr) && (file_name == NULL))
  {
   if (is_a_file(actual_directory_handle->path, actual_directory_handle->entry_store[actual_directory_handle->actual_entry]->d_name)==0)
   {
     file_name=prepare_filename_for_return(actual_directory_handle->entry_store[actual_directory_handle->actual_entry]->d_name, mode);
   }
   else
   actual_directory_handle->actual_entry++;
  }
#ifdef DEBUG
  logfile=fopen("/tmp/dirutil.log", "a+");
  fprintf(logfile, "LOG: (%s)\n", file_name);
  fflush(logfile);
  fclose(logfile);
#endif
  return(file_name);
}

/*
 * Returns all entries of the directory
 */
char * get_next_entry(directory_handle_ptr actual_directory_handle, int mode)
{
  char *file_name=NULL;
#ifdef DEBUG
  FILE *logfile;
#endif
  if(actual_directory_handle == NULL) return NULL;
  actual_directory_handle->actual_entry++;
  if ((actual_directory_handle->actual_entry >= 0) && (actual_directory_handle->actual_entry < actual_directory_handle->entry_nr))
  {
    file_name=prepare_filename_for_return(actual_directory_handle->entry_store[actual_directory_handle->actual_entry]->d_name, mode);
  }
#ifdef DEBUG
  logfile=fopen("/tmp/dirutil.log", "a+");
  fprintf(logfile, "LOG: (%s)\n", file_name);
  fflush(logfile);
  fclose(logfile);
#endif
  return(file_name);
}

