/*
 * String-Utils functions for MPI-Swarm
 * (C) 2002 Gernot Stocker gernot.stocker@tugraz.at
 *
 * Released under GPL
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/*
 * dynamic allocation
 */
char *str_replace(char *input_str, char*search_str, char *replace_str)
{
  char *position=NULL, *new_str=NULL, *lauf=NULL, *tmp_str=NULL;
  int input_length, search_length, replace_length, index=0, counter=0;  
  if ((input_str == NULL) || ( search_str==NULL ) || ( replace_str==NULL)) return input_str;
  input_length=strlen(input_str);
  search_length=strlen(search_str);
  replace_length=strlen(replace_str); 
  position=strstr(input_str, search_str);
  if(position == NULL)
  {
    return input_str;
  }
  else
  {
    new_str=calloc((input_length+(replace_length-search_length)+1), sizeof(char));
    lauf=input_str;
    tmp_str=new_str;     
    while(lauf != position) { *tmp_str++=*lauf++; counter++;}
    if ( replace_length>0 )
    {
      while((*tmp_str++=*replace_str++)!='\0') counter++;
      if (tmp_str!=input_str) tmp_str--;
    }
    for (index=search_length; index>0; index--) position++;
    if (counter < (input_length+(replace_length-search_length)))  while((*tmp_str++=*position++)!='\0') counter++;  
    free(input_str);
  }
  return new_str;
}

char *str_replace_all(char *input_str, char*search_str, char *replace_str)
{
  char *to_test;
  to_test=strdup(input_str);
  do
  {
      free(to_test);
      to_test=strdup(input_str);
      input_str=str_replace(input_str, search_str, replace_str);    
  } while (strcmp(input_str, to_test)!=0);
  free(to_test);    
  return input_str;
}

