/*
 * Directory-Utils functions for MPI-Swarm
 * (C) 2002 Gernot Stocker gernot.stocker@tugraz.at
 *
 * Released under GPL
 */
#include <dirent.h>
#include <stdlib.h>
#define ALLOC_STRING_MODE 0
#define RETURN_STRING_PTR_MODE 1

typedef struct {
  int entry_nr;
  int actual_entry;
  char *path;
  struct dirent ** entry_store;
} directory_handle, *directory_handle_ptr;

directory_handle_ptr new_directory_handle(char *directory_path);
void delete_directory_handle(directory_handle_ptr actual_directory_handle);
void print_directory_handle(directory_handle_ptr actual_directory_handle);
void reset_directory_handle(directory_handle_ptr actual_directory_handle);
char * get_next_filename(directory_handle_ptr actual_directory_handle, int mode);
char * get_next_entry(directory_handle_ptr actual_directory_handle, int mode);
int select_function(const struct dirent *entry);
