/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployment;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.resource.metadata.AdminObjectMetaData;
import org.jboss.resource.metadata.ConfigPropertyMetaData;

public class AdminObjectFactory {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$resource$deployment$AdminObjectFactory == null ? (class$org$jboss$resource$deployment$AdminObjectFactory = AdminObjectFactory.class$("org.jboss.resource.deployment.AdminObjectFactory")) : class$org$jboss$resource$deployment$AdminObjectFactory));
    static /* synthetic */ Class class$org$jboss$resource$deployment$AdminObjectFactory;

    public static Object createAdminObject(ObjectName rarName, AdminObjectMetaData aomd, Properties properties) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String interfaceName = aomd.getAdminObjectInterfaceClass();
        Class<?> interfaceClass = cl.loadClass(interfaceName);
        String implName = aomd.getAdminObjectImplementationClass();
        if (implName == null) {
            throw new DeploymentException("No implementation class for admin object '" + interfaceClass + "' ra=" + rarName);
        }
        Class<?> implClass = cl.loadClass(implName);
        if (!interfaceClass.isAssignableFrom(implClass)) {
            throw new DeploymentException(implClass.getName() + " is not a '" + interfaceClass + "' ra=" + rarName);
        }
        Object result = implClass.newInstance();
        if (properties != null) {
            Iterator<Map.Entry<Object, Object>> i = properties.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> property = i.next();
                String name = (String)property.getKey();
                String value = (String)property.getValue();
                ConfigPropertyMetaData cpmd = aomd.getProperty(name);
                if (cpmd == null) {
                    throw new DeploymentException("No property '" + name + "' for admin object '" + interfaceClass + "' ra=" + rarName);
                }
                String typeName = cpmd.getType();
                Class<?> type = cl.loadClass(typeName);
                PropertyEditor editor = PropertyEditorManager.findEditor(type);
                if (editor == null) {
                    throw new DeploymentException("No property editor found for property '" + name + " class='" + type + "' for admin object '" + interfaceClass + "' ra=" + rarName);
                }
                editor.setAsText(value);
                Object object = editor.getValue();
                try {
                    String setter = "set" + Character.toUpperCase(name.charAt(0));
                    if (name.length() > 1) {
                        setter = setter.concat(name.substring(1));
                    }
                    Method method = implClass.getMethod(setter, type);
                    method.invoke(result, object);
                }
                catch (InvocationTargetException e) {
                    DeploymentException.rethrowAsDeploymentException((String)("Error for property '" + name + "' class=" + implClass + "' for admin object '" + interfaceClass + "' ra=" + rarName), (Throwable)e.getTargetException());
                }
                catch (Throwable t) {
                    DeploymentException.rethrowAsDeploymentException((String)("Error for property '" + name + "' class=" + implClass + "' for admin object '" + interfaceClass + "' ra=" + rarName), (Throwable)t);
                }
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

