/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.axis;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.utils.XMLUtils;
import org.jboss.net.axis.Deployment;

public class XMLResourceProvider
extends FileProvider {
    protected final URL resource;
    protected InputStream is;
    protected ClassLoader contextLoader;

    public XMLResourceProvider(URL resource, ClassLoader loader) {
        super((InputStream)null);
        this.contextLoader = loader;
        this.resource = resource;
    }

    public void setInputStream(InputStream stream) {
        super.setInputStream(stream);
        this.is = stream;
    }

    public void configureEngine(AxisEngine engine) throws ConfigurationException {
        this.buildDeployment().configureEngine(engine);
        engine.refreshGlobalOptions();
    }

    public synchronized Deployment buildDeployment() throws ConfigurationException {
        if (this.getDeployment() == null) {
            try {
                if (this.is == null) {
                    this.setInputStream(this.resource.openStream());
                }
                this.setDeployment(Deployment.makeSafeDeployment(XMLUtils.newDocument((InputStream)this.is).getDocumentElement(), this.contextLoader));
                this.setInputStream(null);
                if (this.getDeployment().getGlobalConfiguration() == null) {
                    WSDDGlobalConfiguration config = new WSDDGlobalConfiguration();
                    config.setOptionsHashtable(new Hashtable());
                    this.getDeployment().setGlobalConfiguration(config);
                }
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        return this.getMyDeployment();
    }

    public Deployment getMyDeployment() {
        return (Deployment)this.getDeployment();
    }

    public void writeEngineConfig(AxisEngine engine) {
    }
}

