/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.axis.server;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.Target;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.jboss.net.axis.ParameterizableDeserializer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EntityBeanDeserializer
extends DeserializerImpl
implements ParameterizableDeserializer {
    protected Map options;
    protected Object home;
    protected Method findMethod;
    protected List findElements = new ArrayList(1);
    protected Object[] findObjects;
    protected TypeDesc typeDesc;
    protected QName xmlType;
    protected Class javaType;
    protected Map propertyMap = new HashMap(4);
    protected int collectionIndex = -1;
    protected Collection fieldSetters = new ArrayList(4);
    protected boolean initialized = false;

    public EntityBeanDeserializer(Class remoteType, QName xmlType) throws Exception {
        this.xmlType = xmlType;
        this.javaType = remoteType;
    }

    protected String getStringOption(String key, String def) {
        String value = (String)this.options.get(key);
        if (value == null) {
            value = def;
        }
        return value;
    }

    protected void initialize(MessageContext ctx) throws SAXException {
        if (!this.initialized) {
            this.initialized = true;
            try {
                this.home = new InitialContext().lookup(this.getStringOption("JndiName", this.javaType.getName() + "Home"));
                String findMethodName = this.getStringOption("FindMethodName", "findByPrimaryKey");
                String findMethodSignatureString = this.getStringOption("FindMethodSignature", "java.lang.String");
                ArrayList findMethodSignatureClasses = new ArrayList(1);
                StringTokenizer tokenizer = new StringTokenizer(findMethodSignatureString, ";");
                while (tokenizer.hasMoreTokens()) {
                    findMethodSignatureClasses.add(ctx.getClassLoader().loadClass(tokenizer.nextToken()));
                }
                this.findMethod = this.home.getClass().getMethod(findMethodName, findMethodSignatureClasses.toArray(new Class[findMethodSignatureClasses.size()]));
                BeanPropertyDescriptor[] pd = EntityBeanDeserializer.getPd(this.javaType);
                for (int i = 0; i < pd.length; ++i) {
                    BeanPropertyDescriptor descriptor = pd[i];
                    this.propertyMap.put(descriptor.getName(), descriptor);
                    this.propertyMap.put(JavaUtils.xmlNameToJava((String)descriptor.getName()), descriptor);
                }
                this.typeDesc = TypeDesc.getTypeDescForClass((Class)this.javaType);
                String findMethodElements = this.getStringOption("FindMethodElements", "name");
                tokenizer = new StringTokenizer(findMethodElements, ";");
                while (tokenizer.hasMoreElements()) {
                    if (this.typeDesc != null) {
                        this.findElements.add(this.typeDesc.getAttributeNameForField(tokenizer.nextToken()));
                        continue;
                    }
                    this.findElements.add(new QName("", tokenizer.nextToken()));
                }
                this.findObjects = new Object[this.findElements.size()];
            }
            catch (NamingException e) {
                throw new SAXException("Could not lookup home.", e);
            }
            catch (ClassNotFoundException e) {
                throw new SAXException("Could not find signature class.", e);
            }
            catch (NoSuchMethodException e) {
                throw new SAXException("Could not find finder method.", e);
            }
        }
    }

    public void setOptions(Map options) {
        this.options = options;
    }

    public Map getOptions() {
        return this.options;
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        QName elementQName;
        BeanPropertyDescriptor propDesc = null;
        if (this.typeDesc != null) {
            QName elemQName = new QName(namespace, localName);
            String fieldName = this.typeDesc.getFieldNameForElement(elemQName);
            propDesc = (BeanPropertyDescriptor)this.propertyMap.get(fieldName);
        }
        if (propDesc == null) {
            propDesc = (BeanPropertyDescriptor)this.propertyMap.get(localName);
        }
        if (propDesc == null) {
            propDesc = (BeanPropertyDescriptor)this.propertyMap.get(JavaUtils.xmlNameToJava((String)localName));
        }
        if (propDesc == null) {
            throw new SAXException(Messages.getMessage((String)"badElem00", (String)this.javaType.getName(), (String)localName));
        }
        QName qn = context.getTypeFromAttributes(namespace, localName, attributes);
        Deserializer dSer = context.getDeserializerForType(qn);
        if (dSer == null) {
            dSer = new DeserializerImpl();
            TypeMapping tm = context.getTypeMapping();
            Class type = propDesc.getType();
            dSer.setDefaultType(tm.getTypeQName(type));
        }
        if (this.findElements.contains(elementQName = new QName(namespace, localName))) {
            dSer.registerValueTarget((Target)new FindPropertyTarget(this.findElements.indexOf(elementQName)));
        } else if (propDesc.getWriteMethod().getParameterTypes().length == 1) {
            this.collectionIndex = -1;
            dSer.registerValueTarget((Target)new BeanPropertyTarget(propDesc));
        } else {
            ++this.collectionIndex;
            dSer.registerValueTarget((Target)new BeanPropertyTarget(propDesc, this.collectionIndex));
        }
        return (SOAPHandler)dSer;
    }

    public void onStartElement(String namespace, String localName, String qName, Attributes attributes, DeserializationContext context) throws SAXException {
        this.initialize(context.getMessageContext());
        if (this.typeDesc == null) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Class type;
            BeanPropertyDescriptor bpd;
            QName attrQName = new QName(attributes.getURI(i), attributes.getLocalName(i));
            String fieldName = this.typeDesc.getFieldNameForAttribute(attrQName);
            if (fieldName == null || (bpd = (BeanPropertyDescriptor)this.propertyMap.get(fieldName)) == null || bpd.getWriteMethod() == null) continue;
            TypeMapping tm = context.getTypeMapping();
            QName qn = tm.getTypeQName(type = bpd.getType());
            if (qn == null) {
                throw new SAXException(Messages.getMessage((String)"unregistered00", (String)type.toString()));
            }
            Deserializer dSer = context.getDeserializerForType(qn);
            if (dSer == null) {
                throw new SAXException(Messages.getMessage((String)"noDeser00", (String)type.toString()));
            }
            if (!(dSer instanceof SimpleDeserializer)) {
                throw new SAXException(Messages.getMessage((String)"AttrNotSimpleType00", (String)bpd.getName(), (String)type.toString()));
            }
            if (this.findElements.contains(attrQName)) {
                dSer.registerValueTarget((Target)new FindPropertyTarget(this.findElements.indexOf(attrQName)));
                continue;
            }
            if (bpd.getWriteMethod().getParameterTypes().length != 1) continue;
            try {
                Object val = ((SimpleDeserializer)dSer).makeValue(attributes.getValue(i));
                bpd.getWriteMethod().invoke(this.value, val);
                continue;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        try {
            this.value = this.findMethod.invoke(this.home, this.findObjects);
            Iterator allSetters = this.fieldSetters.iterator();
            while (allSetters.hasNext()) {
                ((BeanPropertyTarget)allSetters.next()).setReal(this.value);
            }
            this.fieldSetters = null;
        }
        catch (InvocationTargetException e) {
            throw new SAXException("Encountered exception " + e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new SAXException("Encountered exception " + e);
        }
        super.onEndElement(namespace, localName, context);
    }

    public static BeanPropertyDescriptor[] getPd(Class javaType) {
        BeanPropertyDescriptor[] pd;
        try {
            PropertyDescriptor[] rawPd = Introspector.getBeanInfo(javaType).getPropertyDescriptors();
            pd = BeanPropertyDescriptor.processPropertyDescriptors(rawPd, javaType);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return pd;
    }

    static class BeanPropertyDescriptor {
        private String name;
        private Method getter;
        private Method setter;

        public BeanPropertyDescriptor(String _name, Method _getter, Method _setter) {
            this.name = _name;
            this.getter = _getter;
            this.setter = _setter;
        }

        public Method getReadMethod() {
            return this.getter;
        }

        public Method getWriteMethod() {
            return this.setter;
        }

        public String getName() {
            return this.name;
        }

        public Class getType() {
            return this.getter.getReturnType();
        }

        static BeanPropertyDescriptor[] processPropertyDescriptors(PropertyDescriptor[] rawPd, Class cls) {
            BeanPropertyDescriptor[] myPd = new BeanPropertyDescriptor[rawPd.length];
            for (int i = 0; i < rawPd.length; ++i) {
                myPd[i] = new BeanPropertyDescriptor(rawPd[i].getName(), rawPd[i].getReadMethod(), rawPd[i].getWriteMethod());
            }
            try {
                int i;
                int index = 0;
                BeanPropertyDescriptor[] newPd = new BeanPropertyDescriptor[rawPd.length];
                Method[] methods = cls.getMethods();
                for (i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    if (!method.getName().startsWith("set")) continue;
                    boolean found = false;
                    for (int j = 0; j < myPd.length && !found; ++j) {
                        if (myPd[j].getWriteMethod() == null || !myPd[j].getWriteMethod().equals(method)) continue;
                        found = true;
                        newPd[index] = myPd[j];
                        ++index;
                    }
                }
                if (index < myPd.length) {
                    for (int m = 0; m < myPd.length && index < myPd.length; ++m) {
                        boolean found = false;
                        for (int n = 0; n < index && !found; ++n) {
                            found = myPd[m] == newPd[n];
                        }
                        if (found) continue;
                        newPd[index] = myPd[m];
                        ++index;
                    }
                }
                if (index == myPd.length) {
                    myPd = newPd;
                }
                for (i = 0; i < methods.length; ++i) {
                    if (!methods[i].getName().startsWith("set") || methods[i].getParameterTypes().length != 2) continue;
                    for (int j = 0; j < methods.length; ++j) {
                        if (!methods[j].getName().startsWith("get") && !methods[j].getName().startsWith("is") || methods[j].getParameterTypes().length != 1 || methods[j].getReturnType() != methods[i].getParameterTypes()[1] || methods[j].getParameterTypes()[0] != Integer.TYPE || methods[i].getParameterTypes()[0] != Integer.TYPE) continue;
                        for (int k = 0; k < myPd.length; ++k) {
                            if (myPd[k].getReadMethod() == null || myPd[k].getWriteMethod() == null || !myPd[k].getReadMethod().getName().equals(methods[j].getName()) || !myPd[k].getWriteMethod().getName().equals(methods[i].getName())) continue;
                            myPd[k] = new BeanPropertyDescriptor(myPd[k].getName(), methods[j], methods[i]);
                        }
                    }
                }
            }
            catch (Exception e) {
                return myPd;
            }
            return myPd;
        }
    }

    public class BeanPropertyTarget
    implements Target {
        private BeanPropertyDescriptor pd;
        private int index = -1;
        Object value;

        public BeanPropertyTarget(BeanPropertyDescriptor pd) {
            this.pd = pd;
            this.index = -1;
        }

        public BeanPropertyTarget(BeanPropertyDescriptor pd, int i) {
            this.pd = pd;
            this.index = i;
        }

        public void set(Object value) throws SAXException {
            this.value = value;
            if (EntityBeanDeserializer.this.fieldSetters != null) {
                EntityBeanDeserializer.this.fieldSetters.add(this);
            } else {
                this.setReal(EntityBeanDeserializer.this.value);
            }
        }

        public void setReal(Object target) throws SAXException {
            try {
                if (this.index < 0) {
                    this.pd.getWriteMethod().invoke(target, this.value);
                } else {
                    this.pd.getWriteMethod().invoke(target, new Integer(this.index), this.value);
                }
            }
            catch (Exception e) {
                Class<?> type = this.pd.getReadMethod().getReturnType();
                this.value = JavaUtils.convert((Object)this.value, type);
                try {
                    if (this.index < 0) {
                        this.pd.getWriteMethod().invoke(target, this.value);
                    } else {
                        this.pd.getWriteMethod().invoke(target, new Integer(this.index), this.value);
                    }
                }
                catch (Exception ex) {
                    throw new SAXException(ex);
                }
            }
        }
    }

    public class FindPropertyTarget
    implements Target {
        int position;

        public FindPropertyTarget(int index) {
            this.position = index;
        }

        public void set(Object value) throws SAXException {
            EntityBeanDeserializer.this.findObjects[this.position] = value;
        }
    }
}

