/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.axis.server;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;

public class TransactionResponseHandler
extends BasicHandler {
    protected final UserTransaction userTransaction = (UserTransaction)new InitialContext().lookup("UserTransaction");

    protected void endTransaction(MessageContext msgContext, boolean commit) throws AxisFault {
        Object tx = msgContext.getProperty("transaction");
        if (tx != null) {
            try {
                if (commit) {
                    this.userTransaction.commit();
                } else {
                    this.userTransaction.rollback();
                }
            }
            catch (RollbackException e) {
                throw new AxisFault("Could not rollback tx.", (Throwable)e);
            }
            catch (SystemException e) {
                throw new AxisFault("Could not influence tx setting.", (Throwable)e);
            }
            catch (HeuristicMixedException e) {
                throw new AxisFault("Could not commit tx.", (Throwable)e);
            }
            catch (HeuristicRollbackException e) {
                throw new AxisFault("Could not commit tx.", (Throwable)e);
            }
            finally {
                msgContext.setProperty("transaction", null);
            }
        }
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        this.endTransaction(msgContext, true);
    }

    public void onFault(MessageContext msgContext) {
        try {
            this.endTransaction(msgContext, false);
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }
}

