/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javassist.ByteArrayClassPath;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.AOPClassPoolFactory;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectNotificationHandler;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassPoolFactory;
import org.jboss.aop.Deployment;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.DynamicCFlowDefinition;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.metadata.SimpleClassMetaDataLoader;
import org.jboss.aop.pointcut.CFlowStack;
import org.jboss.aop.pointcut.DynamicCFlow;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.Typedef;
import org.jboss.util.loading.Translatable;
import org.jboss.util.loading.Translator;

public class AspectManager
implements Translator {
    private static ThreadLocal REENTRY = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private final CtClass advised;
    protected ClassPool classpool;
    protected HashMap registeredCLs = new HashMap();
    protected HashMap ucl2classes = new HashMap();
    protected LinkedHashMap interfaceIntroductions = new LinkedHashMap();
    protected LinkedHashMap annotationIntroductions = new LinkedHashMap();
    protected LinkedHashMap bindings = new LinkedHashMap();
    protected LinkedHashMap typedefs = new LinkedHashMap();
    protected HashMap interceptorFactories = new HashMap();
    protected HashMap advisors = new HashMap();
    protected Hashtable classMetaDataLoaders = new Hashtable();
    protected HashMap interceptorStacks = new HashMap();
    protected ConcurrentReaderHashMap cflowStacks = new ConcurrentReaderHashMap();
    protected ConcurrentReaderHashMap dynamicCFlows = new ConcurrentReaderHashMap();
    protected ConcurrentReaderHashMap aspectDefinitions = new ConcurrentReaderHashMap();
    protected ConcurrentReaderHashMap perVMAspects = new ConcurrentReaderHashMap();
    protected LinkedHashMap pointcuts = new LinkedHashMap();
    protected LinkedHashMap classMetaData = new LinkedHashMap();
    protected static AspectManager manager;
    public static boolean optimize;
    public static boolean verbose;
    public static ClassPoolFactory classPoolFactory;
    public static AspectNotificationHandler notificationHandler;
    public static boolean suppressTransformationErrors;

    public static synchronized AspectManager instance() {
        if (manager != null) {
            return manager;
        }
        String optimized = System.getProperty("jboss.aop.optimized", null);
        if (optimized != null) {
            optimize = new Boolean(optimized);
        }
        manager = new AspectManager();
        if (!verbose) {
            verbose = new Boolean(System.getProperty("jboss.aop.verbose", "false"));
        }
        Deployment.deploy();
        return manager;
    }

    public LinkedHashMap getPointcuts() {
        return this.pointcuts;
    }

    public CFlowStack getCFlowStack(String name) {
        return (CFlowStack)this.cflowStacks.get((Object)name);
    }

    public void addCFlowStack(CFlowStack stack) {
        this.cflowStacks.put((Object)stack.getName(), (Object)stack);
    }

    public void removeCFlowStack(String name) {
        this.cflowStacks.remove((Object)name);
    }

    public DynamicCFlow getDynamicCFlow(String name) {
        DynamicCFlowDefinition def = (DynamicCFlowDefinition)this.dynamicCFlows.get((Object)name);
        return def.create();
    }

    public void addDynamicCFlow(String name, DynamicCFlowDefinition cflow) {
        this.dynamicCFlows.put((Object)name, (Object)cflow);
    }

    public void removeDynamicCFlow(String name) {
        this.dynamicCFlows.remove((Object)name);
    }

    public AspectManager() {
        this.classpool = ClassPool.getDefault();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.classpool.insertClassPath((ClassPath)new LoaderClassPath(cl));
        try {
            this.advised = this.classpool.get("org.jboss.aop.Advised");
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ClassMetaDataLoader findClassMetaDataLoader(String group) {
        ClassMetaDataLoader loader = (ClassMetaDataLoader)this.classMetaDataLoaders.get(group);
        if (loader == null) {
            loader = SimpleClassMetaDataLoader.singleton;
        }
        return loader;
    }

    public void addClassMetaDataLoader(String group, ClassMetaDataLoader loader) {
        this.classMetaDataLoaders.put(group, loader);
    }

    public void removeClassMetaDataLoader(String group) {
        this.classMetaDataLoaders.remove(group);
    }

    public HashMap getAdvisors() {
        return this.advisors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Advisor getAdvisor(String name) {
        HashMap hashMap = this.advisors;
        synchronized (hashMap) {
            return (Advisor)this.advisors.get(name);
        }
    }

    public LinkedHashMap getBindings() {
        return this.bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassAdvisor getAdvisorIfAdvised(Class clazz) {
        try {
            ClassAdvisor advisor;
            HashMap hashMap = this.advisors;
            synchronized (hashMap) {
                advisor = (ClassAdvisor)this.advisors.get(clazz.getName());
            }
            if (advisor == null) {
                return null;
            }
            advisor.attachClass(clazz);
            if (notificationHandler != null) {
                notificationHandler.attachClass(clazz.getName());
            }
            return advisor;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassAdvisor getAdvisor(Class clazz) {
        ClassAdvisor advisor = null;
        HashMap hashMap = this.advisors;
        synchronized (hashMap) {
            advisor = (ClassAdvisor)this.advisors.get(clazz.getName());
        }
        if (advisor == null) {
            advisor = new ClassAdvisor(clazz.getName());
            hashMap = this.advisors;
            synchronized (hashMap) {
                this.advisors.put(clazz.getName(), advisor);
            }
            if (clazz.getClassLoader() instanceof Translatable) {
                this.registerClassLoader(clazz.getClassLoader());
                this.registerClassName(clazz.getClassLoader(), clazz.getName());
            }
        }
        advisor.attachClass(clazz);
        if (notificationHandler != null) {
            notificationHandler.attachClass(clazz.getName());
        }
        return advisor;
    }

    public Map getRegisteredCLs() {
        return this.registeredCLs;
    }

    public ClassPool findClassPool(ClassLoader cl) {
        if (!(cl instanceof Translatable)) {
            return this.registerClassLoader(Thread.currentThread().getContextClassLoader());
        }
        return this.registerClassLoader(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPool registerClassLoader(ClassLoader ucl) {
        HashMap hashMap = this.registeredCLs;
        synchronized (hashMap) {
            if (this.registeredCLs.containsKey(ucl)) {
                return (ClassPool)this.registeredCLs.get(ucl);
            }
            AOPClassPool pool = AOPClassPool.createAOPClassPool(ucl, this.classpool, this);
            this.registeredCLs.put(ucl, pool);
            return pool;
        }
    }

    protected void registerClassName(ClassLoader ucl, String classname) {
        HashSet<String> classes = (HashSet<String>)this.ucl2classes.get(ucl);
        if (classes == null) {
            classes = new HashSet<String>();
            this.ucl2classes.put(ucl, classes);
        }
        classes.add(classname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClassLoader(ClassLoader cl) {
        HashMap hashMap = this.registeredCLs;
        synchronized (hashMap) {
            HashSet classes;
            AOPClassPool pool = (AOPClassPool)((Object)this.registeredCLs.remove(cl));
            if (pool != null) {
                pool.close();
            }
            if ((classes = (HashSet)this.ucl2classes.remove(cl)) != null) {
                Iterator it = classes.iterator();
                while (it.hasNext()) {
                    Object clazz = it.next();
                    HashMap hashMap2 = this.advisors;
                    synchronized (hashMap2) {
                        this.advisors.remove(clazz);
                    }
                }
            }
        }
    }

    public boolean isNonAdvisableClassName(String classname) {
        return classname.startsWith("org.jboss.aop") || classname.endsWith("$aop") || classname.startsWith("javassist") || classname.startsWith("org.jboss.util.") || classname.startsWith("gnu.trove.") || classname.startsWith("EDU.oswego.cs.dl.util.concurrent.") || classname.startsWith("org.apache.crimson") || classname.startsWith("org.apache.xalan") || classname.startsWith("org.apache.xml") || classname.startsWith("org.apache.xpath") || classname.startsWith("org.ietf.") || classname.startsWith("org.omg.") || classname.startsWith("org.w3c.") || classname.startsWith("org.xml.sax.") || classname.startsWith("sunw.") || classname.startsWith("sun.") || classname.startsWith("java.") || classname.startsWith("javax.") || classname.startsWith("com.sun.");
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws Exception {
        return this.translate(className, loader, classfileBuffer);
    }

    public byte[] translate(String className, ClassLoader loader) throws Exception {
        return this.translate(className, loader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] translate(String className, ClassLoader loader, byte[] classfileBuffer) throws Exception {
        if (AspectManager.isReEntry()) {
            return null;
        }
        AspectManager.setReEntry();
        try {
            Object object;
            if (this.isNonAdvisableClassName(className)) {
                byte[] byArray = null;
                return byArray;
            }
            AOPClassPool pool = (AOPClassPool)this.registerClassLoader(loader);
            CtClass clazz = null;
            try {
                clazz = pool.getLocally(className);
            }
            catch (NotFoundException e) {
                ByteArrayClassPath cp = new ByteArrayClassPath(className, classfileBuffer);
                pool.insertClassPath((ClassPath)cp);
                clazz = pool.getLocally(className);
            }
            if (clazz.isArray()) {
                if (verbose) {
                    System.out.println("[cannot compile] isArray: " + className);
                }
                pool.flushClass(className);
                byte[] e = null;
                return e;
            }
            if (clazz.isInterface()) {
                if (verbose) {
                    System.out.println("[cannot compile] isInterface: " + className);
                }
                pool.flushClass(className);
                byte[] e = null;
                return e;
            }
            if (clazz.isFrozen()) {
                if (verbose) {
                    System.out.println("[warning] isFrozen: " + className);
                }
                clazz.defrost();
            }
            ClassAdvisor advisor = new ClassAdvisor(className);
            Instrumentor instrumentor = new Instrumentor(pool);
            if (!instrumentor.isTransformable(clazz)) {
                if (verbose) {
                    System.out.println("[cannot compile] implements Untransformable: " + className);
                }
                pool.flushClass(className);
                byte[] byArray = null;
                return byArray;
            }
            boolean register = this.attachMetaData(advisor, clazz, true);
            this.applyInterfaceIntroductions(advisor, clazz);
            boolean transformed = instrumentor.transform(clazz, advisor);
            if (transformed) {
                register = true;
            }
            if (register) {
                object = this.advisors;
                synchronized (object) {
                    this.advisors.put(className, advisor);
                }
                this.registerClassName(loader, className);
            }
            if (transformed) {
                object = clazz.toBytecode();
                return object;
            }
            object = null;
            return object;
        }
        catch (Exception ex) {
            if (!(ex instanceof NotFoundException)) {
                if (verbose) {
                    ex.printStackTrace();
                } else {
                    System.err.println("[error] " + ex.getMessage() + ".. Do verbose mode if you want full stack trace.");
                }
            }
            throw ex;
        }
        finally {
            AspectManager.clearReEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterceptorFactory(String name, InterceptorFactory factory) {
        HashMap hashMap = this.interceptorFactories;
        synchronized (hashMap) {
            this.interceptorFactories.put(name, factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterceptorFactory(String name) {
        HashMap hashMap = this.interceptorFactories;
        synchronized (hashMap) {
            this.interceptorFactories.remove(name);
        }
    }

    public Map getInterceptorFactories() {
        return this.interceptorFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterceptorFactory getInterceptorFactory(String name) {
        HashMap hashMap = this.interceptorFactories;
        synchronized (hashMap) {
            return (InterceptorFactory)this.interceptorFactories.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdviceStack(AdviceStack stack) {
        HashMap hashMap = this.interceptorStacks;
        synchronized (hashMap) {
            this.interceptorStacks.put(stack.getName(), stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterceptorStack(String name) {
        HashMap hashMap = this.interceptorStacks;
        synchronized (hashMap) {
            this.interceptorStacks.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdviceStack getAdviceStack(String name) {
        HashMap hashMap = this.interceptorStacks;
        synchronized (hashMap) {
            return (AdviceStack)this.interceptorStacks.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean attachMetaData(ClassAdvisor advisor, CtClass clazz, boolean addAdvisor) throws Exception {
        boolean attached = false;
        LinkedHashMap linkedHashMap = this.classMetaData;
        synchronized (linkedHashMap) {
            Iterator it = this.classMetaData.values().iterator();
            while (it.hasNext()) {
                ClassMetaDataBinding data = (ClassMetaDataBinding)it.next();
                if (!data.matches((Advisor)advisor, clazz)) continue;
                attached = true;
                if (addAdvisor) {
                    data.addAdvisor(advisor);
                }
                ClassMetaDataLoader loader = data.getLoader();
                loader.bind(advisor, data, clazz.getDeclaredMethods(), clazz.getDeclaredFields(), clazz.getDeclaredConstructors());
            }
        }
        return attached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachMetaData(ClassAdvisor advisor, Class clazz) {
        LinkedHashMap linkedHashMap = this.classMetaData;
        synchronized (linkedHashMap) {
            Iterator it = this.classMetaData.values().iterator();
            while (it.hasNext()) {
                ClassMetaDataBinding data = (ClassMetaDataBinding)it.next();
                if (!data.matches((Advisor)advisor, clazz)) continue;
                data.addAdvisor(advisor);
            }
        }
    }

    public ClassAdvisor getTempClassAdvisor(CtClass clazz) throws Exception {
        String classname = clazz.getName();
        ClassAdvisor advisor = new ClassAdvisor(classname);
        this.attachMetaData(advisor, clazz, false);
        return advisor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointcut getPointcut(String name) {
        LinkedHashMap linkedHashMap = this.pointcuts;
        synchronized (linkedHashMap) {
            return (Pointcut)this.pointcuts.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePointcut(String name) {
        LinkedHashMap linkedHashMap = this.pointcuts;
        synchronized (linkedHashMap) {
            this.pointcuts.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addPointcut(Pointcut pointcut) {
        this.removePointcut(pointcut.getName());
        LinkedHashMap linkedHashMap = this.pointcuts;
        synchronized (linkedHashMap) {
            this.pointcuts.put(pointcut.getName(), pointcut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBinding(String name) {
        LinkedHashMap linkedHashMap = this.bindings;
        synchronized (linkedHashMap) {
            AdviceBinding binding = (AdviceBinding)this.bindings.remove(name);
            if (binding == null) {
                return;
            }
            binding.clearAdvisors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addBinding(AdviceBinding binding) {
        this.removeBinding(binding.getName());
        HashMap hashMap = this.bindings;
        synchronized (hashMap) {
            this.bindings.put(binding.getName(), binding);
        }
        hashMap = this.advisors;
        synchronized (hashMap) {
            Iterator it = this.advisors.values().iterator();
            while (it.hasNext()) {
                Advisor advisor = (Advisor)it.next();
                if (binding.getPointcut().softMatch(advisor)) {
                    if (verbose) {
                        System.out.println("[debug] softmatch succeeded for : " + binding);
                    }
                    advisor.newBindingAdded();
                    continue;
                }
                if (!verbose) continue;
                System.out.println("[debug] softmatch failed for : " + binding);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassMetaData(String name) {
        LinkedHashMap linkedHashMap = this.classMetaData;
        synchronized (linkedHashMap) {
            ClassMetaDataBinding meta = (ClassMetaDataBinding)this.classMetaData.remove(name);
            if (meta == null) {
                return;
            }
            meta.clearAdvisors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassMetaData(ClassMetaDataBinding meta) {
        this.removeClassMetaData(meta.getName());
        HashMap hashMap = this.advisors;
        synchronized (hashMap) {
            Iterator it = this.advisors.values().iterator();
            while (it.hasNext()) {
                Class clazz;
                Advisor advisor = (Advisor)it.next();
                if (!meta.matches(advisor, clazz = ((ClassAdvisor)advisor).getClazz())) continue;
                meta.addAdvisor(advisor);
            }
        }
        hashMap = this.classMetaData;
        synchronized (hashMap) {
            this.classMetaData.put(meta.getName(), meta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceIntroduction getInterfaceIntroduction(String name) {
        LinkedHashMap linkedHashMap = this.interfaceIntroductions;
        synchronized (linkedHashMap) {
            return (InterfaceIntroduction)this.interfaceIntroductions.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addInterfaceIntroduction(InterfaceIntroduction pointcut) {
        this.removeInterfaceIntroduction(pointcut.getName());
        LinkedHashMap linkedHashMap = this.interfaceIntroductions;
        synchronized (linkedHashMap) {
            this.interfaceIntroductions.put(pointcut.getName(), pointcut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterfaceIntroduction(String name) {
        LinkedHashMap linkedHashMap = this.interfaceIntroductions;
        synchronized (linkedHashMap) {
            InterfaceIntroduction pointcut = (InterfaceIntroduction)this.interfaceIntroductions.remove(name);
            if (pointcut == null) {
                return;
            }
            pointcut.clearAdvisors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addAnnotationIntroduction(AnnotationIntroduction pointcut) {
        String name = pointcut.getOriginalAnnotationExpr() + pointcut.getOriginalExpression();
        this.removeInterfaceIntroduction(name);
        LinkedHashMap linkedHashMap = this.annotationIntroductions;
        synchronized (linkedHashMap) {
            this.annotationIntroductions.put(name, pointcut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationIntroduction(AnnotationIntroduction pointcut) {
        String name = pointcut.getOriginalAnnotationExpr() + pointcut.getOriginalExpression();
        LinkedHashMap linkedHashMap = this.annotationIntroductions;
        synchronized (linkedHashMap) {
            this.annotationIntroductions.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getAnnotationIntoductions() {
        LinkedHashMap linkedHashMap = this.annotationIntroductions;
        synchronized (linkedHashMap) {
            return new ArrayList(this.annotationIntroductions.values()).iterator();
        }
    }

    protected void applyInterfaceIntroductions(ClassAdvisor advisor, Class clazz) {
        Iterator it = this.interfaceIntroductions.values().iterator();
        while (it.hasNext()) {
            InterfaceIntroduction pointcut = (InterfaceIntroduction)it.next();
            if (!pointcut.matches((Advisor)advisor, clazz)) continue;
            pointcut.addAdvisor(advisor);
        }
    }

    protected void applyInterfaceIntroductions(ClassAdvisor advisor, CtClass clazz) throws Exception {
        Iterator it = this.interfaceIntroductions.values().iterator();
        while (it.hasNext()) {
            InterfaceIntroduction pointcut = (InterfaceIntroduction)it.next();
            if (!pointcut.matches((Advisor)advisor, clazz)) continue;
            pointcut.addAdvisor(advisor);
        }
    }

    public Object getPerVMAspect(AspectDefinition def) {
        return this.getPerVMAspect(def.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerVMAspect(String def) {
        Object aspect = this.perVMAspects.get((Object)def);
        if (aspect instanceof AspectDefinition) {
            Object object = aspect;
            synchronized (object) {
                AspectDefinition adef = (AspectDefinition)aspect;
                aspect = adef.getFactory().createPerVM();
                this.perVMAspects.put((Object)def, aspect);
            }
        }
        return aspect;
    }

    public void addAspectDefinition(AspectDefinition def) throws Exception {
        this.removeAspectDefinition(def.getName());
        if (def.getScope() == Scope.PER_VM) {
            this.perVMAspects.put((Object)def.getName(), (Object)def);
        }
        this.aspectDefinitions.put((Object)def.getName(), (Object)def);
    }

    public void removeAspectDefinition(String name) {
        AspectDefinition def = (AspectDefinition)this.aspectDefinitions.remove((Object)name);
        if (def != null) {
            def.undeploy();
            def.clearAdvisors();
            if (def.getScope() == Scope.PER_VM) {
                this.perVMAspects.remove((Object)def.getName());
            }
        }
    }

    public Map getAspectDefinitions() {
        return this.aspectDefinitions;
    }

    public AspectDefinition getAspectDefinition(String name) {
        return (AspectDefinition)this.aspectDefinitions.get((Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTypedef(Typedef def) throws Exception {
        this.removeTypedef(def.getName());
        LinkedHashMap linkedHashMap = this.typedefs;
        synchronized (linkedHashMap) {
            this.typedefs.put(def.getName(), def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTypedef(String name) {
        LinkedHashMap linkedHashMap = this.typedefs;
        synchronized (linkedHashMap) {
            this.typedefs.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Typedef getTypedef(String name) {
        LinkedHashMap linkedHashMap = this.typedefs;
        synchronized (linkedHashMap) {
            return (Typedef)this.typedefs.get(name);
        }
    }

    public Map getUcl2classes() {
        return this.ucl2classes;
    }

    public Map getInterfaceIntroductions() {
        return this.interfaceIntroductions;
    }

    public Map getAnnotationIntroductions() {
        return this.annotationIntroductions;
    }

    public Map getTypedefs() {
        return this.typedefs;
    }

    public Map getInterceptorStacks() {
        return this.interceptorStacks;
    }

    public Map getClassMetaDataLoaders() {
        return this.classMetaDataLoaders;
    }

    public Map getCflowStacks() {
        return this.cflowStacks;
    }

    public Map getDynamicCFlows() {
        return this.dynamicCFlows;
    }

    public Map getPerVMAspects() {
        return this.perVMAspects;
    }

    public Map getClassMetaData() {
        return this.classMetaData;
    }

    public byte[] getInstrumentedClassLoader() throws NotFoundException, IOException, CannotCompileException {
        CtClass clazz = this.classpool.get(ClassLoader.class.getName());
        ExprEditor defineClassEditor = new ExprEditor(){

            public void edit(MethodCall methodCall) throws CannotCompileException {
                String methodName = methodCall.getMethodName();
                if ("defineClass0".equals(methodName)) {
                    methodCall.replace("{  final byte[] newBytes = org.jboss.aop.AspectManager.instance().translate($1, $0) ;  if (newBytes != (byte[])null) {    $_ = $proceed($1, newBytes, 0, newBytes.length, $5) ;  } else {    $_ = $proceed($$);  }}");
                }
            }
        };
        clazz.instrument(defineClassEditor);
        return clazz.toBytecode();
    }

    private static boolean isReEntry() {
        return (Boolean)REENTRY.get();
    }

    private static void setReEntry() {
        REENTRY.set(Boolean.TRUE);
    }

    private static void clearReEntry() {
        REENTRY.set(Boolean.FALSE);
    }

    static {
        optimize = true;
        verbose = false;
        classPoolFactory = new AOPClassPoolFactory();
        notificationHandler = null;
        suppressTransformationErrors = false;
    }
}

