/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.CtMember;

public class AnnotationRepository {
    Map annotations = new ConcurrentReaderHashMap();

    public Object resolveAnnotation(Member m, Class annotation) {
        return this.resolveAnnotation(m, annotation.getName());
    }

    public Object resolveAnnotation(Member m, String annotation) {
        Map map = (Map)this.annotations.get(m);
        if (map != null) {
            return map.get(annotation);
        }
        return null;
    }

    public void addAnnotation(Member m, Class annotation, Object value) {
        HashMap<String, Object> map = (HashMap<String, Object>)this.annotations.get(m);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.annotations.put(m, map);
        }
        map.put(annotation.getName(), value);
    }

    public boolean hasAnnotation(Member m, Class annotation) {
        return this.resolveAnnotation(m, annotation) != null;
    }

    public boolean hasAnnotation(Member m, String annotation) {
        return this.resolveAnnotation(m, annotation) != null;
    }

    public boolean hasAnnotation(CtMember m, String annotation) {
        Set set = (Set)this.annotations.get(m);
        if (set != null) {
            return set.contains(annotation);
        }
        return false;
    }

    public void addAnnotation(CtMember m, String annotation) {
        HashSet<String> set = (HashSet<String>)this.annotations.get(m);
        if (set == null) {
            set = new HashSet<String>();
        }
        set.add(annotation);
    }
}

