/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.hook;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jboss.aop.AspectManager;

public class GenerateInstrumentedClassLoader {
    public static void main(String[] args) {
        byte[] bytes;
        String filename;
        File file;
        if (args.length != 1) {
            System.err.println("Usage: java " + GenerateInstrumentedClassLoader.class.getName() + " <output directory>");
            System.exit(1);
        }
        if ((file = new File(filename = args[0] + File.separatorChar + "java" + File.separatorChar + "lang" + File.separatorChar + "ClassLoader.class")).exists()) {
            if (!file.canWrite()) {
                System.err.println("Cannot write to existing file: " + file.getAbsolutePath());
                System.exit(2);
            }
        } else {
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!dir.canWrite()) {
                System.err.println("Cannot write to parent directory: " + dir.getAbsolutePath());
            }
        }
        try {
            bytes = AspectManager.instance().getInstrumentedClassLoader();
        }
        catch (Throwable th) {
            System.err.println("Unexpected exception caught during instrumentation: " + th.getMessage());
            th.printStackTrace(System.err);
            System.exit(5);
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.close();
        }
        catch (IOException ioe) {
            System.err.println("Unexpected exception caught while writing class file: " + ioe.getMessage());
            ioe.printStackTrace(System.err);
            System.exit(6);
        }
    }
}

