/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.CtPrimitiveType;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.MethodInfo;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.util.JavassistMethodHashing;

public class MethodExecutionTransformer {
    private Instrumentor instrumentor;

    public MethodExecutionTransformer(Instrumentor instrumentor) {
        this.instrumentor = instrumentor;
    }

    private String addMethodInfoField(CtClass clazz, String methodName, long methodHash) throws Exception {
        CtClass type = this.instrumentor.forName("org.jboss.aop.MethodInfo");
        String name = MethodExecutionTransformer.getMethodInfoFieldName(methodName, methodHash);
        CtField field = new CtField(type, name, clazz);
        field.setModifiers(10);
        clazz.addField(field);
        return name;
    }

    public static String getMethodInfoFieldName(String methodName, long methodHash) {
        String hash = methodHash < 0L ? "_N_" + -1L * methodHash : "" + methodHash;
        String name = "aop$MethodInfo_" + methodName + hash;
        return name;
    }

    private List getAdvisableMethods(CtClass clazz, ClassAdvisor advisor) throws NotFoundException {
        ArrayList<CtMethod> list = new ArrayList<CtMethod>();
        CtMethod[] methods = clazz.getDeclaredMethods();
        block0: for (int i = 0; i < methods.length; ++i) {
            if (!Instrumentor.isAdvisable(methods[i])) continue;
            if (AspectManager.verbose) {
                System.out.println("[debug] is advisable method: " + methods[i].getName());
            }
            Iterator pointcuts = AspectManager.instance().getPointcuts().values().iterator();
            while (pointcuts.hasNext()) {
                Pointcut pointcut = (Pointcut)pointcuts.next();
                boolean matches = pointcut.matchesExecution((Advisor)advisor, methods[i]);
                if (AspectManager.verbose) {
                    System.out.println("[debug] does " + methods[i].getName() + " match " + pointcut.getExpr() + ": " + matches);
                }
                if (!matches) continue;
                list.add(methods[i]);
                continue block0;
            }
        }
        return list;
    }

    public static String getOptimizedInvocationClassName(CtClass clazz, CtMethod method) throws Exception {
        long hash = JavassistMethodHashing.methodHash(method);
        String className = clazz.getName() + "_" + method.getName() + "_" + hash + "_OptimizedMethodInvocation";
        className = className.replace('-', 'N');
        return className;
    }

    protected String createOptimizedInvocationClass(CtClass clazz, CtMethod method) throws Exception {
        String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
        AOPClassPool pool = (AOPClassPool)this.instrumentor.getClassPool();
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodInvocation");
        String className = MethodExecutionTransformer.getOptimizedInvocationClassName(clazz, method);
        boolean makeInnerClass = !Modifier.isPublic((int)method.getModifiers());
        CtClass invocation = TransformerCommon.makeInvocationClass(pool, makeInnerClass, clazz, className, methodInvocation);
        CtClass[] params = method.getParameterTypes();
        TransformerCommon.addArgumentFieldsToInvocation(invocation, params);
        boolean isStatic = Modifier.isStatic((int)method.getModifiers());
        if (!isStatic) {
            CtField target = new CtField(method.getDeclaringClass(), "typedTargetObject", invocation);
            target.setModifiers(1);
            invocation.addField(target);
        }
        CtMethod in = methodInvocation.getDeclaredMethod("invokeNext");
        CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
        invokeNext.setModifiers(in.getModifiers());
        String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)        {           currentInterceptor--;           throw t;       }    } ";
        String returnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ($w)";
        code = isStatic ? code + "   " + returnStr + " " + method.getDeclaringClass().getName() + "." : code + "   " + returnStr + " typedTargetObject.";
        code = code + wrappedName + "(";
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                code = code + ", ";
            }
            code = code + "arg" + i;
        }
        code = code + ");  ";
        if (method.getReturnType().equals(CtClass.voidType)) {
            code = code + " return null; ";
        }
        code = code + "}";
        try {
            invokeNext.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw e;
        }
        invocation.addMethod(invokeNext);
        TransformerCommon.addGetArguments(pool, invocation, method.getParameterTypes());
        MethodExecutionTransformer.addSetArguments(pool, invocation, method.getParameterTypes());
        this.addCopy(pool, invocation, method.getParameterTypes(), isStatic);
        TransformerCommon.compileOrLoadClass(method.getDeclaringClass(), invocation);
        return invocation.getName();
    }

    public void instrument(CtClass clazz, ClassAdvisor advisor) throws Exception {
        Iterator iterator = this.getAdvisableMethods(clazz, advisor).iterator();
        while (iterator.hasNext()) {
            this.instrumentor.setupBasics(clazz);
            CtMethod method = (CtMethod)iterator.next();
            long hash = JavassistMethodHashing.methodHash(method);
            String name = method.getName();
            String methodInfoField = this.addMethodInfoField(clazz, name, hash);
            if (AspectManager.optimize) {
                this.optimized(method, clazz, name, methodInfoField);
                continue;
            }
            this.unoptimized(method, clazz, name, hash, methodInfoField);
        }
    }

    public static String setArguments(CtClass[] params) throws Exception {
        String code = "";
        for (int i = 0; i < params.length; ++i) {
            code = code + "   invocation.arg" + i + " = $" + (i + 1) + "; ";
        }
        return code;
    }

    public static void addSetArguments(ClassPool pool, CtClass invocation, CtClass[] params) throws Exception {
        if (params == null || params.length == 0) {
            return;
        }
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodInvocation");
        CtMethod template = methodInvocation.getDeclaredMethod("setArguments");
        String code = "public void setArguments(java.lang.Object[] args){ ";
        code = code + "   arguments = args; ";
        for (int i = 0; i < params.length; ++i) {
            if (params[i].isPrimitive()) {
                CtPrimitiveType primitive = (CtPrimitiveType)params[i];
                code = code + "   arg" + i + " = ((" + primitive.getWrapperName() + ")args[" + i + "])." + primitive.getGetMethodName() + "(); ";
                continue;
            }
            code = code + "   Object warg" + i + " = args[" + i + "]; ";
            code = code + "   arg" + i + " = (" + params[i].getName() + ")warg" + i + "; ";
        }
        code = code + "}";
        CtMethod setArguments = CtNewMethod.make((String)code, (CtClass)invocation);
        setArguments.setModifiers(template.getModifiers());
        invocation.addMethod(setArguments);
    }

    private void addCopy(ClassPool pool, CtClass invocation, CtClass[] params, boolean isStatic) throws Exception {
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodInvocation");
        CtMethod template = methodInvocation.getDeclaredMethod("copy");
        CtMethod copy = CtNewMethod.make((CtClass)template.getReturnType(), (String)"copy", (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), null, (CtClass)invocation);
        copy.setModifiers(template.getModifiers());
        String code = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.info, this.interceptors); " + "   wrapper.arguments = this.arguments; " + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; " + "   wrapper.instanceResolver = this.instanceResolver; ";
        if (!isStatic) {
            code = code + "   wrapper.typedTargetObject = this.typedTargetObject; ";
            code = code + "   wrapper.targetObject = this.targetObject; ";
        }
        for (int i = 0; i < params.length; ++i) {
            code = code + "   wrapper.arg" + i + " = this.arg" + i + "; ";
        }
        code = code + "   return wrapper; }";
        copy.setBody(code);
        invocation.addMethod(copy);
    }

    private void copyAnnotations(CtMethod src, CtMethod dest) {
        AnnotationsAttribute visible;
        MethodInfo mi = src.getMethodInfo2();
        MethodInfo wmi = dest.getMethodInfo2();
        AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
        if (invisible != null) {
            wmi.addAttribute(invisible.copy(wmi.getConstPool(), new HashMap()));
        }
        if ((visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations")) != null) {
            wmi.addAttribute(visible.copy(wmi.getConstPool(), new HashMap()));
        }
    }

    private void optimized(CtMethod method, CtClass clazz, String name, String methodInfoField) throws Exception {
        boolean isStatic = Modifier.isStatic((int)method.getModifiers());
        String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
        CtMethod wmethod = CtNewMethod.copy((CtMethod)method, (CtClass)clazz, null);
        String originalName = method.getName();
        wmethod.setName(wrappedName);
        clazz.addMethod(wmethod);
        this.copyAnnotations(method, wmethod);
        String optimizedInvocation = this.createOptimizedInvocationClass(clazz, method);
        method.setName(wrappedName);
        wmethod.setName(originalName);
        String code = null;
        String aopReturnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
        String returnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ";
        code = !isStatic ? "{     if (aop$classAdvisor$aop.doesHaveAspects || (_instanceAdvisor != null && _instanceAdvisor.hasInstanceAspects))     {        org.jboss.aop.advice.Interceptor[] interceptors = " + methodInfoField + ".interceptors;" + "       if (_instanceAdvisor != null) " + "       { " + "          interceptors = _instanceAdvisor.getInterceptors(" + methodInfoField + ".interceptors); " + "       } " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + methodInfoField + ", interceptors); " + MethodExecutionTransformer.setArguments(method.getParameterTypes()) + "       invocation.setTargetObject(this); " + "       invocation.typedTargetObject = this; " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       " + aopReturnStr + "invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       " + returnStr + " " + wrappedName + "($$); " + "    }" + "}" : "{     if (aop$classAdvisor$aop.doesHaveAspects)     {        org.jboss.aop.advice.Interceptor[] interceptors = " + methodInfoField + ".interceptors;" + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + methodInfoField + ", interceptors); " + MethodExecutionTransformer.setArguments(method.getParameterTypes()) + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       " + aopReturnStr + "invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       " + returnStr + " " + wrappedName + "($$); " + "    }" + "}";
        try {
            wmethod.setBody(code);
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
            throw new RuntimeException("code was: " + code + " for method " + name);
        }
    }

    private void unoptimized(CtMethod method, CtClass clazz, String name, long hash, String methodInfoField) throws NotFoundException, CannotCompileException {
        boolean isStatic = Modifier.isStatic((int)method.getModifiers());
        String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
        CtMethod wmethod = CtNewMethod.copy((CtMethod)method, (CtClass)clazz, null);
        String originalName = method.getName();
        wmethod.setName(wrappedName);
        clazz.addMethod(wmethod);
        this.copyAnnotations(method, wmethod);
        method.setName(wrappedName);
        wmethod.setName(originalName);
        String code = null;
        String aopReturnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
        String returnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ";
        String args = "null";
        if (method.getParameterTypes().length > 0) {
            args = "$args";
        }
        code = !isStatic ? "{     if (aop$classAdvisor$aop.doesHaveAspects || (_instanceAdvisor != null && _instanceAdvisor.hasInstanceAspects))     {        Object[] ags = " + args + "; " + "       " + aopReturnStr + "aop$classAdvisor$aop" + ".invokeMethod(_instanceAdvisor, this, " + hash + "L, ags, " + methodInfoField + "); " + "    } " + "    else " + "    {" + "       " + returnStr + " " + wrappedName + "($$); " + "    }" + "}" : "{     if (aop$classAdvisor$aop.doesHaveAspects)     {        org.jboss.aop.ClassInstanceAdvisor ia = null;        Object[] ags = " + args + "; " + "       Object target = null; " + "       " + aopReturnStr + "aop$classAdvisor$aop" + ".invokeMethod(ia, target, " + hash + "L, ags, " + methodInfoField + "); " + "    } " + "    else " + "    {" + "       " + returnStr + " " + wrappedName + "($$); " + "    }" + "}";
        try {
            wmethod.setBody(code);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("code was: " + code + " for method " + name, e);
        }
    }
}

