/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URL;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.standalone.Compiler;

public class TransformerCommon {
    static final String STANDARD_INTERCEPTOR_CODE = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)        {           currentInterceptor--;           throw t;       }    } ";

    public static CtClass makeInvocationClass(AOPClassPool pool, boolean makeInnerClass, CtClass outerClass, String className, CtClass superInvocation) throws CannotCompileException, NotFoundException {
        CtClass invocation;
        CtClass untransformable = pool.get("org.jboss.aop.instrument.Untransformable");
        if (makeInnerClass) {
            String innerClassName = className.substring(className.lastIndexOf(46) + 1);
            boolean classStatic = true;
            invocation = outerClass.makeNestedClass(innerClassName, classStatic);
            invocation.setSuperclass(superInvocation);
        } else {
            invocation = pool.makeClass(className, superInvocation);
        }
        invocation.addInterface(untransformable);
        CtConstructor conTemplate = superInvocation.getDeclaredConstructors()[0];
        CtConstructor icon = CtNewConstructor.make((CtClass[])conTemplate.getParameterTypes(), (CtClass[])conTemplate.getExceptionTypes(), (CtClass)invocation);
        invocation.addConstructor(icon);
        return invocation;
    }

    public static void compileOrLoadClass(CtClass classForPackage, CtClass invocation) throws Exception {
        if (Compiler.loader != null) {
            URL url = Compiler.loader.getResource(classForPackage.getName().replace('.', '/') + ".class");
            String path = url.toString();
            path = path.substring(0, path.lastIndexOf(47) + 1);
            path = path + invocation.getSimpleName() + ".class";
            URI newUrl = new URI(path);
            File file = new File(newUrl);
            FileOutputStream fp = new FileOutputStream(file);
            fp.write(invocation.toBytecode());
            fp.close();
        } else {
            invocation.toClass();
        }
    }

    public static void addArgumentFieldsToInvocation(CtClass invocation, CtClass[] params) throws CannotCompileException {
        for (int i = 0; i < params.length; ++i) {
            CtField field = new CtField(params[i], "arg" + i, invocation);
            field.setModifiers(1);
            invocation.addField(field);
        }
    }

    public static void addGetArguments(ClassPool pool, CtClass invocation, CtClass[] params) throws Exception {
        if (params == null || params.length == 0) {
            return;
        }
        try {
            CtClass superInvocation = invocation.getSuperclass();
            CtMethod template = superInvocation.getDeclaredMethod("getArguments");
            String code = "public Object[] getArguments(){    if (arguments != (Object[])null) { return (Object[])arguments; }    arguments = new Object[" + params.length + "]; " + "";
            for (int i = 0; i < params.length; ++i) {
                code = code + "   arguments[" + i + "] = ($w)arg" + i + "; ";
            }
            code = code + "   return arguments; }";
            CtMethod getArguments = CtNewMethod.make((String)code, (CtClass)invocation);
            getArguments.setModifiers(template.getModifiers());
            invocation.addMethod(getArguments);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

