/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.metadata;

import java.util.ArrayList;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.ast.ClassExpression;

public abstract class ClassMetaDataBinding {
    protected ClassExpression classExpr;
    protected String expr;
    protected String name;
    protected String tag;
    protected ArrayList advisors = new ArrayList();
    protected ClassMetaDataLoader loader;

    public ClassMetaDataBinding(ClassMetaDataLoader loader, String name, String tag, String exp) {
        this.name = name;
        this.tag = tag;
        this.loader = loader;
        this.expr = exp;
        this.classExpr = new ClassExpression(this.expr);
    }

    public ClassMetaDataLoader getLoader() {
        return this.loader;
    }

    public String getName() {
        return this.name;
    }

    public void addAdvisor(Advisor advisor) {
        this.advisors.add(advisor.getName());
        advisor.addClassMetaData(this);
    }

    public void clearAdvisors() {
        for (int i = 0; i < this.advisors.size(); ++i) {
            String advisorName = (String)this.advisors.get(i);
            Advisor advisor = AspectManager.instance().getAdvisor(advisorName);
            if (advisor == null) continue;
            advisor.removeClassMetaData(this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClassMetaDataBinding)) {
            return false;
        }
        return ((ClassMetaDataBinding)obj).getName().equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean matches(Advisor advisor, Class clazz) {
        return Util.matchesClassExpr(this.classExpr, clazz, advisor);
    }

    public boolean matches(Advisor advisor, CtClass clazz) throws NotFoundException {
        return Util.matchesClassExpr(this.classExpr, clazz, advisor);
    }

    public String getClassExpr() {
        return this.expr;
    }
}

