/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.expr.NewExpr;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.pointcut.ConstructorMatcher;
import org.jboss.aop.pointcut.MatcherHelper;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.WithinMatcher;
import org.jboss.aop.pointcut.ast.ASTCall;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTField;
import org.jboss.aop.pointcut.ast.ASTHas;
import org.jboss.aop.pointcut.ast.ASTHasField;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ASTWithin;
import org.jboss.aop.pointcut.ast.ASTWithincode;
import org.jboss.aop.pointcut.ast.Node;

public class NewExprMatcher
extends MatcherHelper {
    NewExpr call;
    ClassAdvisor advisor;

    public NewExprMatcher(ClassAdvisor advisor, NewExpr call, ASTStart start) throws NotFoundException {
        super(start);
        this.advisor = advisor;
        this.call = call;
    }

    public Object visit(ASTCall node, Object data) {
        try {
            if (!(node.getBehavior() instanceof ASTConstructor)) {
                return Boolean.FALSE;
            }
            ASTConstructor astCon = (ASTConstructor)node.getBehavior();
            if (astCon.getClazz().isSimple() && !astCon.getClazz().matches(this.call.getClassName())) {
                return Boolean.FALSE;
            }
            CtConstructor calledCon = this.call.getConstructor();
            ClassAdvisor calledAdvisor = AspectManager.instance().getTempClassAdvisor(calledCon.getDeclaringClass());
            ConstructorMatcher conMatcher = new ConstructorMatcher(calledAdvisor, calledCon, null);
            return conMatcher.matches(astCon);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object visit(ASTWithin node, Object data) {
        WithinMatcher within = null;
        try {
            within = new WithinMatcher(this.advisor, this.call.where(), null);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return node.jjtAccept(within, null);
    }

    public Object visit(ASTWithincode node, Object data) {
        WithinMatcher within = null;
        try {
            within = new WithinMatcher(this.advisor, this.call.where(), null);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return node.jjtAccept(within, null);
    }

    protected Boolean resolvePointcut(Pointcut p) {
        try {
            return new Boolean(p.matchesCall(this.advisor, this.call));
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Object visit(ASTHas node, Object data) {
        try {
            Node n = node.jjtGetChild(0);
            CtConstructor con = this.call.getConstructor();
            if (n instanceof ASTMethod) {
                return new Boolean(Util.has(con.getDeclaringClass(), (ASTMethod)n, this.advisor));
            }
            return new Boolean(Util.has(con.getDeclaringClass(), (ASTConstructor)n, this.advisor));
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Object visit(ASTHasField node, Object data) {
        ASTField f = (ASTField)node.jjtGetChild(0);
        CtConstructor con = null;
        try {
            con = this.call.getConstructor();
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return new Boolean(Util.has(con.getDeclaringClass(), f, this.advisor));
    }
}

