/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import javassist.CtClass;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.ast.ASTAllParameter;
import org.jboss.aop.pointcut.ast.ASTAnd;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTBoolean;
import org.jboss.aop.pointcut.ast.ASTClass;
import org.jboss.aop.pointcut.ast.ASTComposite;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTField;
import org.jboss.aop.pointcut.ast.ASTHas;
import org.jboss.aop.pointcut.ast.ASTHasField;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTNot;
import org.jboss.aop.pointcut.ast.ASTOr;
import org.jboss.aop.pointcut.ast.ASTParameter;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ASTSub;
import org.jboss.aop.pointcut.ast.Node;
import org.jboss.aop.pointcut.ast.SimpleNode;
import org.jboss.aop.pointcut.ast.TypeExpressionParserVisitor;

public class TypeMatcher
implements TypeExpressionParserVisitor {
    private ClassAdvisor advisor;
    private CtClass ctClass;
    private Class clazz;

    public TypeMatcher(ClassAdvisor advisor, Class clazz) {
        this.advisor = advisor;
        this.clazz = clazz;
    }

    public TypeMatcher(ClassAdvisor advisor, CtClass ctClass) {
        this.advisor = advisor;
        this.ctClass = ctClass;
    }

    public Object visit(ASTStart node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTBoolean node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTComposite node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTNot node, Object data) {
        Boolean bool = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        boolean val = bool;
        return val ? Boolean.FALSE : Boolean.TRUE;
    }

    public Object visit(ASTSub node, Object data) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            data = node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTAnd node, Object left) {
        Node andChild = node.jjtGetChild(0);
        boolean val = (Boolean)left;
        return new Boolean(val && (Boolean)andChild.jjtAccept(this, (Object)Boolean.FALSE) != false);
    }

    public Object visit(ASTOr node, Object left) {
        Node orChild = node.jjtGetChild(0);
        boolean val = (Boolean)left;
        return new Boolean(val || (Boolean)orChild.jjtAccept(this, (Object)Boolean.FALSE) != false);
    }

    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    public Object visit(ASTHas node, Object data) {
        Node n = node.jjtGetChild(0);
        if (n instanceof ASTMethod) {
            if (this.clazz != null) {
                return new Boolean(Util.has(this.clazz, (ASTMethod)n, this.advisor));
            }
            if (this.ctClass != null) {
                return new Boolean(Util.has(this.ctClass, (ASTMethod)n, this.advisor));
            }
        } else {
            if (this.clazz != null) {
                return new Boolean(Util.has(this.clazz, (ASTConstructor)n, this.advisor));
            }
            if (this.ctClass != null) {
                return new Boolean(Util.has(this.ctClass, (ASTConstructor)n, this.advisor));
            }
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTHasField node, Object data) {
        if (this.clazz == null) {
            return Boolean.TRUE;
        }
        ASTField f = (ASTField)node.jjtGetChild(0);
        if (this.clazz != null) {
            return new Boolean(Util.has(this.clazz, f, this.advisor));
        }
        return new Boolean(Util.has(this.ctClass, f, this.advisor));
    }

    public Object visit(ASTClass node, Object data) {
        if (this.clazz != null) {
            return new Boolean(Util.matchesClassExpr(node.getClazz(), this.clazz, (Advisor)this.advisor));
        }
        return new Boolean(Util.matchesClassExpr(node.getClazz(), this.ctClass, (Advisor)this.advisor));
    }

    public Object visit(ASTMethod node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTAttribute node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTConstructor node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTParameter node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTAllParameter node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTField node, Object data) {
        return Boolean.FALSE;
    }
}

