/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.FileProvider;
import org.jboss.logging.Logger;

public final class EngineConfigurationFinder {
    private static final Logger log = Logger.getLogger((Class)EngineConfigurationFinder.class);
    public static final String DEFAULT_SERVER_CONFIG = "META-INF/axis-server-config.xml";
    public static final String DEFAULT_CLIENT_CONFIG = "META-INF/axis-client-config.xml";

    public static EngineConfiguration getClientEngineConfiguration() {
        String configLocation = System.getProperty("org.jboss.ws4ee.client.config");
        if (configLocation == null) {
            configLocation = DEFAULT_CLIENT_CONFIG;
        }
        return EngineConfigurationFinder.getEngineConfiguration(configLocation);
    }

    public static EngineConfiguration getServerEngineConfiguration() {
        String configLocation = System.getProperty("org.jboss.ws4ee.server.config");
        if (configLocation == null) {
            configLocation = DEFAULT_SERVER_CONFIG;
        }
        return EngineConfigurationFinder.getEngineConfiguration(configLocation);
    }

    private static EngineConfiguration getEngineConfiguration(String configLocation) {
        ClassLoader cl;
        URL configURL;
        FileProvider config = null;
        try {
            URL url = new URL(configLocation);
            InputStream is = url.openStream();
            if (is != null) {
                config = new FileProvider(is);
            }
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        if (config == null && new File(configLocation).exists()) {
            config = new FileProvider(configLocation);
        }
        if (config == null && (configURL = (cl = EngineConfigurationFinder.class.getClassLoader()).getResource(configLocation)) != null) {
            log.debug((Object)("Found config at: " + configURL));
            try {
                InputStream is = configURL.openStream();
                if (is != null) {
                    config = new FileProvider(is);
                }
            }
            catch (IOException e) {
                log.debug((Object)"Failed to open config", (Throwable)e);
            }
        }
        if (config == null) {
            log.warn((Object)("Cannot find engine configuration at: " + configLocation));
        }
        return config;
    }
}

