/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.MessageContext;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.Call;
import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.jboss.webservice.handler.ClientHandlerChain;

public class ClientEngine
extends AxisClient {
    protected static Logger log = Logger.getLogger((Class)ClientEngine.class);
    private Map handlerChainMap = new HashMap();

    public ClientEngine(EngineConfiguration config) {
        super(config);
    }

    public void registerHandlerChain(String portName, List infos, Set roles) {
        ClientHandlerChain chain = new ClientHandlerChain(infos, roles);
        this.handlerChainMap.put(portName, chain);
    }

    public void invoke(org.apache.axis.MessageContext msgContext) throws AxisFault {
        log.debug((Object)("invoke: " + msgContext));
        String hName = null;
        Handler handler = null;
        org.apache.axis.MessageContext previousContext = ClientEngine.getCurrentMessageContext();
        try {
            ClientEngine.setCurrentMessageContext((org.apache.axis.MessageContext)msgContext);
            msgContext.setPastPivot(false);
            ClientHandlerChain handlerChain = (ClientHandlerChain)this.getHandlerChain(msgContext);
            if (handlerChain.getState() == 1) {
                handlerChain.init(null);
            }
            if ((handler = this.getGlobalRequest()) != null) {
                handler.invoke(msgContext);
            }
            if (!handlerChain.handleRequest((MessageContext)msgContext)) {
                log.warn((Object)"FIXME: handlerChain.handleRequest() returned false");
                return;
            }
            hName = msgContext.getTransportName();
            if (hName == null || (handler = this.getTransport(hName)) == null) {
                throw new AxisFault(Messages.getMessage((String)"noTransport00", (String)hName));
            }
            handler.invoke(msgContext);
            boolean isFaultMessage = false;
            if (isFaultMessage && !handlerChain.handleFault((MessageContext)msgContext)) {
                log.warn((Object)"FIXME: handlerChain.handleFault() returned false");
                return;
            }
            if (!handlerChain.handleResponse((MessageContext)msgContext)) {
                log.warn((Object)"FIXME: handlerChain.handleResponse() returned false");
                return;
            }
            handler = this.getGlobalResponse();
            if (handler != null) {
                handler.invoke(msgContext);
            }
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException(e.toString());
        }
        finally {
            ClientEngine.setCurrentMessageContext((org.apache.axis.MessageContext)previousContext);
        }
    }

    private HandlerChain getHandlerChain(org.apache.axis.MessageContext msgContext) {
        Call call;
        ClientHandlerChain handlerChain = null;
        if (this.handlerChainMap.size() == 0) {
            handlerChain = new ClientHandlerChain(null, null);
        }
        if (this.handlerChainMap.size() == 1) {
            String portName = (String)this.handlerChainMap.keySet().iterator().next();
            handlerChain = (HandlerChain)this.handlerChainMap.get(portName);
            log.debug((Object)("Using handler chain for port: " + portName));
        }
        if ((call = (Call)msgContext.getProperty("call_object")) == null) {
            throw new JAXRPCException("Cannot obtain current call");
        }
        if (call.getPortName() != null) {
            String portName = call.getPortName().getLocalPart();
            handlerChain = (HandlerChain)this.handlerChainMap.get(portName);
            log.debug((Object)("Using handler chain for port: " + portName));
        }
        if (handlerChain == null) {
            handlerChain = new ClientHandlerChain(null, null);
            log.debug((Object)"Using empty handler chain");
        }
        return handlerChain;
    }
}

