/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.entity;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.emb.MediaEntityLocal;
import javax.emb.MediaEntityLocalHome;
import javax.emb.MediaException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.media.entity.MediaEntityDTO;

public abstract class MediaEntityManagerBean
implements SessionBean {
    public String createMediaEntity() throws MediaException, CreateException, NamingException {
        MediaEntityLocalHome mediaEntityLocalHome = this.getMediaEntityLocalHome();
        MediaEntityLocal mediaEntityLocal = mediaEntityLocalHome.create();
        return (String)mediaEntityLocal.getPrimaryKey();
    }

    public MediaEntityDTO getMediaEntity(String identity) throws MediaException, FinderException, NamingException {
        MediaEntityLocal mediaEntityLocal = this.findMediaEntity(identity);
        MediaEntityDTO mediaEntityDTO = new MediaEntityDTO();
        mediaEntityDTO.setContent(mediaEntityLocal.getContent());
        mediaEntityDTO.setLocation(mediaEntityLocal.getLocation());
        mediaEntityDTO.setDescription(mediaEntityLocal.getDescription());
        mediaEntityDTO.setName(mediaEntityLocal.getName());
        mediaEntityDTO.setMimeType(mediaEntityLocal.getMimeType());
        return mediaEntityDTO;
    }

    public String updateMediaEntity(String identity, MediaEntityDTO mediaEntityDTO) throws MediaException, FinderException, NamingException {
        MediaEntityLocal mediaEntityLocal = this.findMediaEntity(identity);
        mediaEntityLocal.setContent(mediaEntityDTO.getContent());
        mediaEntityLocal.setLocation(mediaEntityDTO.getLocation());
        mediaEntityLocal.setDescription(mediaEntityDTO.getDescription());
        mediaEntityLocal.setName(mediaEntityDTO.getName());
        mediaEntityLocal.setMimeType(mediaEntityDTO.getMimeType());
        return (String)mediaEntityLocal.getPrimaryKey();
    }

    public Object getMediaEntityProperty(String identity, String property) throws MediaException, FinderException, NamingException {
        if (identity == null || property == null) {
            throw new NullPointerException();
        }
        MediaEntityLocal mediaEntityLocal = this.findMediaEntity(identity);
        if (property.equals("content")) {
            return mediaEntityLocal.getContent();
        }
        if (property.equals("location")) {
            return mediaEntityLocal.getLocation();
        }
        if (property.equals("description")) {
            return mediaEntityLocal.getDescription();
        }
        if (property.equals("name")) {
            return mediaEntityLocal.getName();
        }
        if (property.equals("mimeType")) {
            return mediaEntityLocal.getMimeType();
        }
        throw new IllegalArgumentException("Invalid property name: " + property);
    }

    public void setMediaEntityProperty(String identity, String property, Object value) throws MediaException, FinderException, NamingException {
        block8: {
            if (identity == null || property == null) {
                throw new NullPointerException();
            }
            MediaEntityLocal mediaEntityLocal = this.findMediaEntity(identity);
            try {
                if (property.equals("content")) {
                    mediaEntityLocal.setContent((byte[])value);
                    break block8;
                }
                if (property.equals("location")) {
                    mediaEntityLocal.setLocation((URL)value);
                    break block8;
                }
                if (property.equals("description")) {
                    mediaEntityLocal.setDescription((String)value);
                    break block8;
                }
                if (property.equals("name")) {
                    mediaEntityLocal.setName((String)value);
                    break block8;
                }
                if (property.equals("mimeType")) {
                    mediaEntityLocal.setMimeType((String)value);
                    break block8;
                }
                throw new IllegalArgumentException("Invalid property name: " + property);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid value for property: " + property);
            }
        }
    }

    public void setMediaEntityContent(String identity, File contentFile) throws MediaException, FinderException, NamingException, FileNotFoundException {
        if (identity == null) {
            throw new NullPointerException();
        }
        MediaEntityLocal mediaEntityLocal = this.findMediaEntity(identity);
        FileInputStream contentStream = new FileInputStream(contentFile);
        mediaEntityLocal.setContent((InputStream)contentStream);
    }

    private MediaEntityLocal findMediaEntity(String identity) throws NamingException, FinderException {
        MediaEntityLocalHome mediaEntityLocalHome = this.getMediaEntityLocalHome();
        return mediaEntityLocalHome.findByPrimaryKey(identity);
    }

    private MediaEntityLocalHome getMediaEntityLocalHome() throws NamingException {
        InitialContext initialContext = new InitialContext();
        return (MediaEntityLocalHome)initialContext.lookup("ejb/media/MediaEntity");
    }
}

