/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.io.FileOutputStream;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.AspectManager;
import org.jboss.mx.loading.RepositoryClassLoader;

public class JBossClassPool
extends AOPClassPool {
    protected File tempdir = null;
    protected final Object tmplock = new Object();

    protected JBossClassPool(ClassLoader cl, ClassPool src, AspectManager manager, File tmp) {
        super(cl, src, manager);
        this.tempdir = tmp;
    }

    protected JBossClassPool(ClassPool src, AspectManager manager) {
        super(src, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class toClass(CtClass cc, ClassLoader loader) throws CannotCompileException {
        if (this.dcl == null || this.tempdir == null) {
            return super.toClass(cc);
        }
        Class<?> dynClass = null;
        try {
            File classFile = null;
            String classFileName = cc.getName().replace('.', '/') + ".class";
            Object object = this.tmplock;
            synchronized (object) {
                classFile = new File(this.tempdir, classFileName);
                File pkgDirs = classFile.getParentFile();
                pkgDirs.mkdirs();
                FileOutputStream stream = new FileOutputStream(classFile);
                stream.write(cc.toBytecode());
                stream.flush();
                stream.close();
                classFile.deleteOnExit();
            }
            RepositoryClassLoader rcl = (RepositoryClassLoader)this.dcl;
            rcl.clearClassBlackList();
            rcl.clearResourceBlackList();
            dynClass = this.dcl.loadClass(cc.getName());
        }
        catch (Exception ex) {
            ClassFormatError cfe = new ClassFormatError("Failed to load dyn class: " + cc.getName());
            cfe.initCause(ex);
            throw cfe;
        }
        return dynClass;
    }
}

