/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.security.Exclude;
import org.jboss.aspects.security.Permissions;
import org.jboss.aspects.security.Unchecked;
import org.jboss.logging.Logger;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;

public class RoleBasedAuthorizationInterceptor
implements Interceptor {
    protected Logger log = Logger.getLogger(this.getClass());
    protected AuthenticationManager securityManager;
    protected RealmMapping realmMapping;
    static /* synthetic */ Class class$org$jboss$aspects$security$Exclude;
    static /* synthetic */ Class class$org$jboss$aspects$security$Unchecked;
    static /* synthetic */ Class class$org$jboss$aspects$security$Permissions;

    public RoleBasedAuthorizationInterceptor(AuthenticationManager manager, RealmMapping realmMapping) {
        this.securityManager = manager;
        this.realmMapping = realmMapping;
    }

    public String getName() {
        return "RoleBasedAuthorizationInterceptor";
    }

    protected Set getRoleSet(Invocation invocation) {
        Set roles = (Set)invocation.getMetaData((Object)"security", (Object)"roles");
        if (roles == null) {
            roles = this.getAnnotationRoleSet(invocation);
        }
        return roles;
    }

    protected Set getAnnotationRoleSet(Invocation invocation) {
        HashSet<Object> set = new HashSet<Object>();
        Exclude exclude = (Exclude)invocation.resolveAnnotation(class$org$jboss$aspects$security$Exclude == null ? (class$org$jboss$aspects$security$Exclude = RoleBasedAuthorizationInterceptor.class$("org.jboss.aspects.security.Exclude")) : class$org$jboss$aspects$security$Exclude);
        if (exclude != null) {
            set.add(NobodyPrincipal.NOBODY_PRINCIPAL);
            return set;
        }
        Unchecked unchecked = (Unchecked)invocation.resolveAnnotation(class$org$jboss$aspects$security$Unchecked == null ? (class$org$jboss$aspects$security$Unchecked = RoleBasedAuthorizationInterceptor.class$("org.jboss.aspects.security.Unchecked")) : class$org$jboss$aspects$security$Unchecked);
        if (unchecked != null) {
            set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
            return set;
        }
        Permissions permissions = (Permissions)invocation.resolveAnnotation(class$org$jboss$aspects$security$Permissions == null ? (class$org$jboss$aspects$security$Permissions = RoleBasedAuthorizationInterceptor.class$("org.jboss.aspects.security.Permissions")) : class$org$jboss$aspects$security$Permissions);
        if (permissions == null) {
            set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
            return set;
        }
        for (int i = 0; i < permissions.value().length; ++i) {
            set.add(new SimplePrincipal(permissions.value()[i]));
        }
        return set;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.securityManager == null) {
            return invocation.invokeNext();
        }
        if (this.realmMapping == null) {
            throw new SecurityException("Role mapping manager has not been set");
        }
        Set roles = this.getRoleSet(invocation);
        if (roles == null) {
            String message = "No method permissions assigned.";
            this.log.error((Object)message);
            throw new SecurityException(message);
        }
        RunAsIdentity threadRunAsRole = SecurityAssociation.peekRunAsIdentity();
        if (threadRunAsRole != null) {
            if (!roles.contains(threadRunAsRole) && !roles.contains(AnybodyPrincipal.ANYBODY_PRINCIPAL)) {
                String message = "Insufficient method permissions, runAsRole=" + threadRunAsRole + ", interface=" + invocation.getClass().getName() + ", requiredRoles=" + roles;
                this.log.error((Object)message);
                throw new SecurityException(message);
            }
        } else {
            Principal principal = SecurityAssociation.getPrincipal();
            if (!this.realmMapping.doesUserHaveRole(principal, roles)) {
                String message = "Insufficient method permissions, principal=" + principal + ", interface=" + invocation.getClass().getName() + ", requiredRoles=" + roles + ", principalRoles=" + this.realmMapping.getUserRoles(principal);
                this.log.error((Object)message);
                throw new SecurityException(message);
            }
        }
        return invocation.invokeNext();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

