/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.tx;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.tx.ClientTxPropagationInterceptor;
import org.jboss.tm.TransactionPropagationContextUtil;

public class TxPropagationInterceptor
implements Interceptor {
    private TransactionManager tm;

    public TxPropagationInterceptor(TransactionManager tm) {
        this.tm = tm;
    }

    public TxPropagationInterceptor() {
        try {
            InitialContext ctx = new InitialContext();
            this.tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return "TxPropagationInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object tpc = invocation.getMetaData((Object)ClientTxPropagationInterceptor.TRANSACTION_PROPAGATION_CONTEXT, (Object)ClientTxPropagationInterceptor.TRANSACTION_PROPAGATION_CONTEXT);
        if (tpc != null) {
            Transaction tx = this.tm.getTransaction();
            if (tx != null) {
                throw new RuntimeException("cannot import a transaction context when a transaction is already associated with the thread");
            }
            Transaction importedTx = TransactionPropagationContextUtil.getTPCImporter().importTransactionPropagationContext(tpc);
            this.tm.resume(importedTx);
        }
        return invocation.invokeNext();
    }
}

