/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.tx;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRolledbackException;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.logging.Logger;
import org.jboss.util.UnreachableStatementException;

public abstract class TxSupport
implements Serializable {
    private static final List values = new ArrayList();
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$aspects$tx$TxSupport == null ? (class$org$jboss$aspects$tx$TxSupport = TxSupport.class$("org.jboss.aspects.tx.TxSupport")) : class$org$jboss$aspects$tx$TxSupport));
    public static final TxSupport NEVER = new Never("Never");
    public static final TxSupport NOT_SUPPORTED = new NotSupported("NotSupported");
    public static final TxSupport SUPPORTS = new Supports("Supports");
    public static final TxSupport REQUIRED = new Required("Required");
    public static final TxSupport REQUIRES_NEW = new RequiresNew("RequiresNew");
    public static final TxSupport MANDATORY = new Mandatory("Mandatory");
    public static final TxSupport DEFAULT = REQUIRED;
    private static int nextOrdinal = 0;
    private final int ordinal = nextOrdinal++;
    private final transient String name;
    private static final HashMap nameMap = new HashMap();
    static /* synthetic */ Class class$org$jboss$aspects$tx$TxSupport;

    private TxSupport(String name) {
        this.name = name;
        values.add(this);
    }

    public static TxSupport byName(String name) {
        TxSupport val = (TxSupport)nameMap.get(name.trim().toUpperCase());
        if (val == null) {
            throw new IllegalArgumentException("Unknown TxType: " + name);
        }
        return val;
    }

    public String toString() {
        return this.name;
    }

    protected Object internalReadResolve() throws ObjectStreamException {
        return values.get(this.ordinal);
    }

    public abstract Object serverInvoke(Invocation var1, TransactionManager var2) throws Throwable;

    protected Object invokeInNoTx(Invocation invocation) throws Throwable {
        return invocation.invokeNext();
    }

    protected Object invokeInOurTx(Invocation invocation, TransactionManager tm) throws Throwable {
        tm.begin();
        Transaction tx = tm.getTransaction();
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        catch (Throwable t) {
            this.rethrowApplicationException(invocation, t);
            this.setRollbackOnly(tx);
            throw t;
        }
        finally {
            this.endTransaction(tm, tx);
        }
    }

    protected Object invokeInCallerTx(Invocation invocation, Transaction tx) throws Throwable {
        try {
            return invocation.invokeNext();
        }
        catch (Throwable t) {
            this.rethrowApplicationException(invocation, t);
            this.setRollbackOnly(tx);
            this.rethrowAsTxRolledbackException(t);
            throw new UnreachableStatementException();
        }
    }

    protected void endTransaction(TransactionManager tm, Transaction tx) throws TransactionRolledbackException, SystemException {
        if (tx != tm.getTransaction()) {
            throw new IllegalStateException("Wrong tx on thread: expected " + tx + ", actual " + tm.getTransaction());
        }
        try {
            if (tx.getStatus() == 1) {
                tx.rollback();
            } else {
                tx.commit();
            }
        }
        catch (RollbackException e) {
            throw new TransactionRolledbackException(e.getMessage());
        }
        catch (HeuristicMixedException e) {
            throw new TransactionRolledbackException(e.getMessage());
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionRolledbackException(e.getMessage());
        }
        catch (SystemException e) {
            throw new TransactionRolledbackException(e.getMessage());
        }
    }

    protected void rethrowAsTxRolledbackException(Throwable cause) throws TransactionRolledbackException {
        if (cause instanceof TransactionRolledbackException) {
            throw (TransactionRolledbackException)cause;
        }
        TransactionRolledbackException ex = new TransactionRolledbackException(cause.getMessage());
        ex.detail = cause;
        throw ex;
    }

    protected void setRollbackOnly(Transaction tx) {
        try {
            tx.setRollbackOnly();
        }
        catch (SystemException ex) {
            log.error((Object)"SystemException while setting transaction for rollback only", (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            log.error((Object)"IllegalStateException while setting transaction for rollback only", (Throwable)ex);
        }
    }

    protected void rethrowApplicationException(Invocation inv, Throwable e) throws Throwable {
        Class[] applicationExceptionsList;
        Object applicationExceptions = inv.getMetaData((Object)"transaction", (Object)"application-exceptions");
        if (applicationExceptions == null) {
            return;
        }
        if (applicationExceptions instanceof String) {
            ArrayList tmpList = new ArrayList();
            String aes = (String)applicationExceptions;
            aes = aes.trim();
            StringTokenizer tokenizer = new StringTokenizer(aes, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                Class<?> excClass = Thread.currentThread().getContextClassLoader().loadClass(token);
                tmpList.add(excClass);
            }
            applicationExceptionsList = tmpList.toArray(new Class[tmpList.size()]);
        } else {
            applicationExceptionsList = (Class[])applicationExceptions;
        }
        for (int i = 0; i < applicationExceptionsList.length; ++i) {
            if (!applicationExceptionsList[i].isInstance(e)) continue;
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        nameMap.put("NEVER", NEVER);
        nameMap.put("NOTSUPPORTED", NOT_SUPPORTED);
        nameMap.put("SUPPORTS", SUPPORTS);
        nameMap.put("REQUIRED", REQUIRED);
        nameMap.put("REQUIRESNEW", REQUIRES_NEW);
        nameMap.put("MANDATORY", MANDATORY);
    }

    public static final class Mandatory
    extends TxSupport {
        private Mandatory(String name) {
            super(name);
        }

        private Object readResolve() throws ObjectStreamException {
            return this.internalReadResolve();
        }

        public Object serverInvoke(Invocation invocation, TransactionManager tm) throws Throwable {
            Transaction tx = tm.getTransaction();
            if (tx == null) {
                throw new RuntimeException("Transaction required");
            }
            return this.invokeInCallerTx(invocation, tx);
        }
    }

    public static final class RequiresNew
    extends TxSupport {
        private RequiresNew(String name) {
            super(name);
        }

        private Object readResolve() throws ObjectStreamException {
            return this.internalReadResolve();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object serverInvoke(Invocation invocation, TransactionManager tm) throws Throwable {
            Transaction tx = tm.getTransaction();
            if (tx != null) {
                tm.suspend();
                try {
                    Object object = this.invokeInOurTx(invocation, tm);
                    return object;
                }
                finally {
                    tm.resume(tx);
                }
            }
            return this.invokeInOurTx(invocation, tm);
        }
    }

    public static final class Required
    extends TxSupport {
        private Required(String name) {
            super(name);
        }

        private Object readResolve() throws ObjectStreamException {
            return this.internalReadResolve();
        }

        public Object serverInvoke(Invocation invocation, TransactionManager tm) throws Throwable {
            Transaction tx = tm.getTransaction();
            if (tx == null) {
                return this.invokeInOurTx(invocation, tm);
            }
            return this.invokeInCallerTx(invocation, tx);
        }
    }

    public static final class Supports
    extends TxSupport {
        private Supports(String name) {
            super(name);
        }

        private Object readResolve() throws ObjectStreamException {
            return this.internalReadResolve();
        }

        public Object serverInvoke(Invocation invocation, TransactionManager tm) throws Throwable {
            if (tm.getTransaction() == null) {
                return this.invokeInNoTx(invocation);
            }
            return this.invokeInCallerTx(invocation, tm.getTransaction());
        }
    }

    public static final class NotSupported
    extends TxSupport {
        private NotSupported(String name) {
            super(name);
        }

        private Object readResolve() throws ObjectStreamException {
            return this.internalReadResolve();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object serverInvoke(Invocation invocation, TransactionManager tm) throws Throwable {
            Transaction tx = tm.getTransaction();
            if (tx != null) {
                tm.suspend();
                try {
                    Object object = this.invokeInNoTx(invocation);
                    return object;
                }
                finally {
                    tm.resume(tx);
                }
            }
            return this.invokeInNoTx(invocation);
        }
    }

    public static final class Never
    extends TxSupport {
        private Never(String name) {
            super(name);
        }

        private Object readResolve() throws ObjectStreamException {
            return this.internalReadResolve();
        }

        public Object serverInvoke(Invocation invocation, TransactionManager tm) throws Throwable {
            if (tm.getTransaction() != null) {
                throw new IllegalStateException("Transaction present on server in Never call");
            }
            return this.invokeInNoTx(invocation);
        }
    }
}

