/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.aspects.versioned.DistributedState;
import org.jboss.aspects.versioned.DistributedUpdate;
import org.jboss.aspects.versioned.DistributedVersionManager;
import org.jboss.aspects.versioned.SynchronizationManager;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;
import org.jboss.util.id.GUID;

public class LocalSynchronizationManager
implements SynchronizationManager {
    protected static Logger log = Logger.getLogger((Class)(class$org$jboss$aspects$versioned$DistributedSynchronizationManager == null ? (class$org$jboss$aspects$versioned$DistributedSynchronizationManager = LocalSynchronizationManager.class$("org.jboss.aspects.versioned.DistributedSynchronizationManager")) : class$org$jboss$aspects$versioned$DistributedSynchronizationManager));
    protected TransactionLocal txSynch = new TransactionLocal();
    protected Object tableLock = new Object();
    protected Hashtable objectTable = new Hashtable();
    protected Hashtable stateTable = new Hashtable();
    protected DistributedVersionManager versionManager;
    static /* synthetic */ Class class$org$jboss$aspects$versioned$DistributedSynchronizationManager;

    public LocalSynchronizationManager(DistributedVersionManager versionManager) {
        this.versionManager = versionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(GUID guid) {
        Object object = this.tableLock;
        synchronized (object) {
            return this.objectTable.get(guid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(GUID guid, Object obj) {
        Object object = this.tableLock;
        synchronized (object) {
            this.objectTable.put(guid, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedState getState(GUID guid) {
        Object object = this.tableLock;
        synchronized (object) {
            return (DistributedState)this.stateTable.get(guid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putState(GUID guid, Object obj) {
        Object object = this.tableLock;
        synchronized (object) {
            this.stateTable.put(guid, obj);
        }
    }

    public void registerUpdate(Transaction tx, DistributedState state) throws Exception {
        if (tx == null) {
            return;
        }
        GUID guid = state.getGUID();
        DistributedStateSynchronization synch = (DistributedStateSynchronization)this.txSynch.get(tx);
        if (synch == null) {
            synch = new DistributedStateSynchronization(tx);
            this.txSynch.set(tx, (Object)synch);
            tx.registerSynchronization((Synchronization)synch);
            synch.updates().put(guid, state);
            return;
        }
        if (synch.updates().containsKey(guid)) {
            return;
        }
        synch.updates().put(guid, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObjects(List newObjects) throws Exception {
        log.trace((Object)"in create Objects");
        for (int i = 0; i < newObjects.size(); ++i) {
            DistributedState state = (DistributedState)newObjects.get(i);
            Object object = this.tableLock;
            synchronized (object) {
                this.objectTable.put(state.getGUID(), state.getObject());
                this.stateTable.put(state.getGUID(), state);
                continue;
            }
        }
        this.sendNewObjects(newObjects);
    }

    public void sendNewObjects(List newObjects) throws Exception {
    }

    protected void sendClusterUpdatesAndRelease(GUID globalTxId, List clusterUpdates) throws Exception {
    }

    protected void acquireRemoteLocks(GUID globalTxId, List guids) throws Exception {
    }

    public void noTxUpdate(DistributedUpdate update) throws Exception {
    }

    protected void releaseHeldLocks(List locks) {
        log.trace((Object)"releaseHeldLocks");
        for (int i = 0; i < locks.size(); ++i) {
            try {
                DistributedState state = (DistributedState)locks.get(i);
                state.releaseWriteLock();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.trace((Object)"end releaseHeldLocks");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class DistributedStateSynchronization
    implements Synchronization {
        final Transaction tx;
        HashMap managers = new HashMap();
        ArrayList locks;
        boolean optimisticLockPassed = false;
        ArrayList clusterUpdates;
        GUID globalTxId;

        public DistributedStateSynchronization(Transaction tx) {
            this.tx = tx;
        }

        public HashMap updates() {
            return this.managers;
        }

        public void beforeCompletion() {
            ArrayList guidList = new ArrayList(this.managers.keySet());
            Collections.sort(guidList);
            this.clusterUpdates = new ArrayList();
            this.locks = new ArrayList();
            try {
                for (int i = 0; i < guidList.size(); ++i) {
                    GUID guid = (GUID)guidList.get(i);
                    DistributedState manager = (DistributedState)this.managers.get(guid);
                    log.trace((Object)"acquiring writelock in beforecompletion");
                    manager.acquireWriteLock();
                    this.locks.add(manager);
                    manager.checkOptimisticLock(this.tx);
                    this.clusterUpdates.add(manager.createTxUpdate(this.tx));
                }
                this.globalTxId = new GUID();
                LocalSynchronizationManager.this.acquireRemoteLocks(this.globalTxId, guidList);
            }
            catch (RuntimeException ex) {
                LocalSynchronizationManager.this.releaseHeldLocks(this.locks);
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.optimisticLockPassed = true;
        }

        public void afterCompletion(int status) {
            if (status != 4) {
                Iterator it = this.managers.values().iterator();
                while (it.hasNext()) {
                    DistributedState manager = (DistributedState)it.next();
                    try {
                        manager.mergeState(this.tx);
                    }
                    catch (Exception ignored) {
                        log.error((Object)"afterCompletion failed on mergeState, cache is probably inconsistent and should be flushed", (Throwable)ignored);
                    }
                }
                try {
                    LocalSynchronizationManager.this.sendClusterUpdatesAndRelease(this.globalTxId, this.clusterUpdates);
                }
                catch (Exception ignored) {
                    log.error((Object)"afterCompletion failed on mergeState, cache is probably inconsistent and should be flushed", (Throwable)ignored);
                }
            }
            if (this.optimisticLockPassed) {
                log.trace((Object)"afterCompletion releaseHeldLocks");
                LocalSynchronizationManager.this.releaseHeldLocks(this.locks);
            }
        }
    }
}

