/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.jboss.system.server.Server;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigUtil;
import org.jboss.system.server.ServerLoader;

public class Main {
    private String jaxpLibs = null;
    private String jmxLibs = "jboss-jmx.jar,dom4j.jar,jaxen.jar,gnu-regexp.jar";
    private String concurrentLib = "concurrent.jar";
    private List bootLibraries = new LinkedList();
    private List extraLibraries = new LinkedList();
    private List extraClasspath = new LinkedList();
    private Properties props = new Properties(System.getProperties());

    public void boot(String[] args) throws Exception {
        int i;
        this.processCommandLine(args);
        String homeDir = this.props.getProperty("jboss.home.dir");
        if (homeDir == null) {
            String path = Main.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            path = URLDecoder.decode(path, "UTF-8");
            File runJar = new File(path);
            File homeFile = runJar.getParentFile().getParentFile();
            homeDir = homeFile.getCanonicalPath();
        }
        this.props.setProperty("jboss.home.dir", homeDir);
        String homeURL = this.props.getProperty("jboss.home.url");
        if (homeURL == null) {
            File file = new File(homeDir);
            homeURL = file.toURL().toString();
            this.props.setProperty("jboss.home.url", homeURL);
        }
        ServerLoader loader = new ServerLoader(this.props);
        for (i = 0; i < this.bootLibraries.size(); ++i) {
            loader.addLibrary((String)this.bootLibraries.get(i));
        }
        if (this.jaxpLibs != null) {
            loader.addLibraries(this.jaxpLibs);
        }
        loader.addEndorsedJars();
        loader.addLibraries(this.jmxLibs);
        loader.addLibrary(this.concurrentLib);
        for (i = 0; i < this.extraLibraries.size(); ++i) {
            loader.addLibrary((String)this.extraLibraries.get(i));
        }
        for (i = 0; i < this.extraClasspath.size(); ++i) {
            loader.addURL((URL)this.extraClasspath.get(i));
        }
        ClassLoader parentCL = Thread.currentThread().getContextClassLoader();
        Server server = loader.load(parentCL);
        server.init(this.props);
        ServerConfig config = server.getConfig();
        config.setExitOnShutdown(true);
        server.start();
    }

    private URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }

    private void processCommandLine(String[] args) throws Exception {
        int code;
        String programName = System.getProperty("program.name", "jboss");
        String sopts = "-:hD:p:n:c:Vj:L:C:P:b:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("patchdir", 1, null, 112), new LongOpt("netboot", 1, null, 110), new LongOpt("configuration", 1, null, 99), new LongOpt("version", 0, null, 86), new LongOpt("jaxp", 1, null, 106), new LongOpt("bootlib", 1, null, 66), new LongOpt("library", 1, null, 76), new LongOpt("classpath", 1, null, 67), new LongOpt("properties", 1, null, 80), new LongOpt("host", 1, null, 98)};
        Getopt getopt = new Getopt(programName, args, sopts, lopts);
        this.props.setProperty("jboss.bind.address", "0.0.0.0");
        System.setProperty("jboss.bind.address", "0.0.0.0");
        block16: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    System.exit(1);
                    continue block16;
                }
                case 1: {
                    System.err.println(programName + ": unused non-option argument: " + getopt.getOptarg());
                    continue block16;
                }
                case 104: {
                    System.out.println("usage: " + programName + " [options]");
                    System.out.println();
                    System.out.println("options:");
                    System.out.println("    -h, --help                    Show this help message");
                    System.out.println("    -V, --version                 Show version information");
                    System.out.println("    --                            Stop processing options");
                    System.out.println("    -D<name>[=<value>]            Set a system property");
                    System.out.println("    -p, --patchdir=<dir>          Set the patch directory; Must be absolute");
                    System.out.println("    -n, --netboot=<url>           Boot from net with the given url as base");
                    System.out.println("    -c, --configuration=<name>    Set the server configuration name");
                    System.out.println("    -j, --jaxp=<type>             Set the JAXP impl type (ie. crimson)");
                    System.out.println("    -B, --bootlib=<filename>      Add an extra library to the front bootclasspth");
                    System.out.println("    -L, --library=<filename>      Add an extra library to the loaders classpath");
                    System.out.println("    -C, --classpath=<url>         Add an extra url to the loaders classpath");
                    System.out.println("    -P, --properties=<url>        Load system properties from the given url");
                    System.out.println("    -b, --host=<host or ip>       Bind address for all JBoss services");
                    System.out.println();
                    System.exit(0);
                    continue block16;
                }
                case 68: {
                    String value;
                    String name;
                    String arg = getopt.getOptarg();
                    int i = arg.indexOf("=");
                    if (i == -1) {
                        name = arg;
                        value = "true";
                    } else {
                        name = arg.substring(0, i);
                        value = arg.substring(i + 1, arg.length());
                    }
                    System.setProperty(name, value);
                    continue block16;
                }
                case 112: {
                    URL url = this.makeURL(getopt.getOptarg());
                    this.props.put("jboss.patch.url", url.toString());
                    continue block16;
                }
                case 110: {
                    String arg = getopt.getOptarg();
                    if (!arg.endsWith("/")) {
                        arg = arg + "/";
                    }
                    this.props.put("jboss.home.url", new URL(arg).toString());
                    continue block16;
                }
                case 99: {
                    String arg = getopt.getOptarg();
                    this.props.put("jboss.server.name", arg);
                    continue block16;
                }
                case 86: {
                    Package jbossPackage = Package.getPackage("org.jboss");
                    System.out.println("JBoss " + jbossPackage.getImplementationVersion());
                    System.out.println();
                    System.out.println("Distributable under LGPL license.");
                    System.out.println("See terms of license at gnu.org.");
                    System.out.println();
                    System.exit(0);
                    continue block16;
                }
                case 106: {
                    String saxFactoryType;
                    String domFactoryType;
                    String arg = getopt.getOptarg().toLowerCase();
                    if (arg.equals("crimson")) {
                        domFactoryType = "org.apache.crimson.jaxp.DocumentBuilderFactoryImpl";
                        saxFactoryType = "org.apache.crimson.jaxp.SAXParserFactoryImpl";
                        this.jaxpLibs = "crimson.jar";
                    } else if (arg.equals("xerces")) {
                        domFactoryType = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
                        saxFactoryType = "org.apache.xerces.jaxp.SAXParserFactoryImpl";
                        this.jaxpLibs = "xercesImpl.jar,xml-apis.jar,resolver.jar";
                    } else {
                        System.err.println("Invalid JAXP type: " + arg + " (Expected 'crimson' or 'xerces')");
                        System.exit(1);
                        continue block16;
                    }
                    System.setProperty("javax.xml.parsers.DocumentBuilderFactory", domFactoryType);
                    System.setProperty("javax.xml.parsers.SAXParserFactory", saxFactoryType);
                    continue block16;
                }
                case 66: {
                    String arg = getopt.getOptarg();
                    this.bootLibraries.add(arg);
                    continue block16;
                }
                case 76: {
                    String arg = getopt.getOptarg();
                    this.extraLibraries.add(arg);
                    continue block16;
                }
                case 67: {
                    URL url = this.makeURL(getopt.getOptarg());
                    this.extraClasspath.add(url);
                    continue block16;
                }
                case 80: {
                    URL url = this.makeURL(getopt.getOptarg());
                    Properties props = System.getProperties();
                    props.load(url.openConnection().getInputStream());
                    continue block16;
                }
                case 98: {
                    String arg = getopt.getOptarg();
                    this.props.put("jboss.bind.address", arg);
                    System.setProperty("jboss.bind.address", arg);
                    System.setProperty("bind.address", arg);
                    String rmiHost = System.getProperty("java.rmi.server.hostname");
                    if (rmiHost != null) continue block16;
                    rmiHost = ServerConfigUtil.fixRemoteAddress(arg);
                    System.setProperty("java.rmi.server.hostname", rmiHost);
                    continue block16;
                }
            }
            throw new Error("unhandled option code: " + code);
        }
    }

    public static void main(final String[] args) throws Exception {
        Runnable worker = new Runnable(){

            public void run() {
                try {
                    Main main = new Main();
                    main.boot(args);
                }
                catch (Exception e) {
                    System.err.println("Failed to boot JBoss:");
                    e.printStackTrace();
                }
            }
        };
        ThreadGroup threads = new ThreadGroup("jboss");
        new Thread(threads, worker, "main").start();
    }

    public static void systemExit(String[] argv) {
        System.exit(0);
    }
}

