/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.dbutilities;

import at.tugraz.genome.dbutilities.PKGenerator;
import at.tugraz.genome.dbutilities.dao.MysqlDAOFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MYSQLPKGenerator
implements PKGenerator {
    private static MYSQLPKGenerator instance_ = null;
    private static MysqlDAOFactory daoFactory_ = null;
    private Hashtable pkCache_ = new Hashtable();
    private static int cacheSize_ = 50;
    private Hashtable existingSequences_ = null;
    protected static Log log = LogFactory.getLog(class$at$tugraz$genome$dbutilities$MYSQLPKGenerator == null ? (class$at$tugraz$genome$dbutilities$MYSQLPKGenerator = MYSQLPKGenerator.class$("at.tugraz.genome.dbutilities.MYSQLPKGenerator")) : class$at$tugraz$genome$dbutilities$MYSQLPKGenerator);
    static /* synthetic */ Class class$at$tugraz$genome$dbutilities$MYSQLPKGenerator;

    public static MYSQLPKGenerator getInstance(MysqlDAOFactory daoFactory) {
        daoFactory_ = daoFactory;
        if (instance_ == null) {
            instance_ = new MYSQLPKGenerator();
        }
        return instance_;
    }

    public static MYSQLPKGenerator getInstance() {
        log.info("create instance MYSQLPKGenerator");
        if (instance_ == null) {
            instance_ = new MYSQLPKGenerator();
        }
        return instance_;
    }

    private MYSQLPKGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getPrimaryKey(String tableName) {
        Long pk = null;
        log.debug("##create primary key##");
        String sequenceTable = tableName.replaceAll("-", "_").toLowerCase() + "seq";
        ArrayList pkList = (ArrayList)this.pkCache_.get(sequenceTable);
        if (pkList != null) {
            Long cachedPK = (Long)pkList.remove(0);
            if (pkList.size() == 0) {
                this.pkCache_.remove(sequenceTable);
            }
            pk = cachedPK;
        } else {
            Connection con = daoFactory_.createConnection();
            ArrayList<Long> currentPKList = new ArrayList<Long>();
            if (!this.checkTableExists(sequenceTable, con)) {
                this.createTable(sequenceTable, con);
                pk = new Long(100L);
            } else if (!this.checkEntryExists(sequenceTable, con)) {
                this.addRequiredProperties(sequenceTable, con);
                pk = new Long(100L);
            } else {
                try {
                    String sqlQuery = "select id from " + sequenceTable;
                    PreparedStatement stmt = con.prepareStatement(sqlQuery);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        pk = new Long(rs.getLong(1));
                    }
                    rs.close();
                    stmt.close();
                    String sqlUpdate = "UPDATE " + sequenceTable + " SET id = ? WHERE (id = ?)";
                    stmt = con.prepareStatement(sqlUpdate);
                    stmt.setLong(1, pk + Long.parseLong(String.valueOf(cacheSize_)));
                    stmt.setLong(2, pk);
                    stmt.executeUpdate();
                    stmt.close();
                }
                catch (SQLException sqlExc) {
                    sqlExc.printStackTrace();
                }
                finally {
                    try {
                        con.close();
                    }
                    catch (SQLException sqlExc) {
                        sqlExc.printStackTrace();
                    }
                }
            }
            for (int i = 0; i < cacheSize_; ++i) {
                currentPKList.add(pk);
                pk = new Long(pk + 1L);
            }
            pk = (Long)currentPKList.remove(0);
            this.pkCache_.put(sequenceTable, currentPKList);
        }
        return pk;
    }

    public String toString() {
        return "MYSQLPKGenerator";
    }

    private boolean checkTableExists(String tableName, Connection con) {
        String sqlStatement = "SELECT * FROM " + tableName;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = con.prepareStatement(sqlStatement);
            rs = pStmt.executeQuery();
            rs.close();
            pStmt.close();
            return true;
        }
        catch (SQLException ex) {
            try {
                pStmt.close();
            }
            catch (SQLException ex1) {
                // empty catch block
            }
            return false;
        }
    }

    private boolean checkEntryExists(String tableName, Connection con) {
        String sqlStatement = "SELECT COUNT(*) FROM " + tableName;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = con.prepareStatement(sqlStatement);
            rs = pStmt.executeQuery();
            Long nrOfEntries = new Long(0L);
            if (rs.next()) {
                nrOfEntries = new Long(rs.getLong(1));
            }
            rs.close();
            pStmt.close();
            return nrOfEntries > 0L;
        }
        catch (SQLException ex) {
            try {
                pStmt.close();
            }
            catch (SQLException ex1) {
                return false;
            }
            return false;
        }
    }

    private boolean createTable(String tableName, Connection con) {
        String sqlStatement = null;
        sqlStatement = "CREATE TABLE " + tableName + " (\n ID BIGINT(20)\n)";
        PreparedStatement pStmt = null;
        try {
            pStmt = con.prepareStatement(sqlStatement);
            pStmt.execute();
            pStmt.close();
            this.addRequiredProperties(tableName, con);
            return true;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            try {
                pStmt.close();
            }
            catch (SQLException ex1) {
                // empty catch block
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequiredProperties(String tableName, Connection con) {
        String sqlStatement = "INSERT INTO " + tableName + " VALUES (?)";
        PreparedStatement pStmt = null;
        try {
            pStmt = con.prepareStatement(sqlStatement);
            pStmt.setLong(1, 150L);
            pStmt.executeUpdate();
            pStmt.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            try {
                pStmt.close();
            }
            catch (SQLException ex1) {
                // empty catch block
            }
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException sqlExc) {
                sqlExc.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

