/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.dbutilities;

import at.tugraz.genome.dbutilities.ValueListIterator;
import at.tugraz.genome.dbutilities.exception.IteratorException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ValueListHandler
extends ValueListIterator
implements Serializable {
    protected LinkedList list_;
    protected int currentIndex_;
    protected transient ListIterator listIterator_;

    public ValueListHandler() {
    }

    public ValueListHandler(LinkedList list) throws IteratorException {
        this.setList(list);
    }

    protected void setList(LinkedList list) throws IteratorException {
        this.list_ = new LinkedList(list);
        if (this.list_ == null) {
            throw new IteratorException("List is empty: setList()");
        }
        this.listIterator_ = this.list_.listIterator();
    }

    protected void setList(LinkedList list, boolean preserveIndex) throws IteratorException {
        System.out.println("[ValueListHandler] currentIndex = " + this.currentIndex_);
        this.setList(list);
        if (preserveIndex) {
            this.setIndex(this.currentIndex_);
        }
    }

    protected Collection getList() {
        return this.list_;
    }

    public int getSize() throws IteratorException {
        int size = 0;
        if (this.list_ == null) {
            throw new IteratorException("List is empty: getSize()");
        }
        size = this.list_.size();
        return size;
    }

    protected Object getCurrentElement() throws IteratorException {
        int currentIndex;
        Object obj = null;
        if (this.list_ != null) {
            currentIndex = this.listIterator_.nextIndex();
            if (currentIndex == this.getSize()) {
                currentIndex = this.getSize() - 1;
            }
        } else {
            throw new IteratorException("List is empty: getCurrentElement()");
        }
        this.currentIndex_ = currentIndex;
        obj = this.list_.get(currentIndex);
        return obj;
    }

    protected List getPreviousElements(int count) throws IteratorException {
        Object object = null;
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.listIterator_ != null) {
            for (int i = 0; this.listIterator_.hasPrevious() && i < count; ++i) {
                object = this.listIterator_.previous();
                list.add(object);
                this.currentIndex_ = this.listIterator_.nextIndex();
            }
        } else {
            throw new IteratorException("List is empty: getPreviousElements()");
        }
        return list;
    }

    protected List getNextElements(int count) throws IteratorException {
        Object object = null;
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.listIterator_ != null) {
            for (int i = 0; this.listIterator_.hasNext() && i < count; ++i) {
                object = this.listIterator_.next();
                list.add(object);
                this.currentIndex_ = this.listIterator_.nextIndex();
            }
        } else {
            throw new IteratorException("List is empty: getNextElements()");
        }
        System.out.println("currentIndex after getNextElements(): " + this.currentIndex_);
        return list;
    }

    public void setIndex(int idx) throws IteratorException {
        if (idx < 0) {
            idx = 0;
        }
        if (this.listIterator_ != null) {
            if (idx < this.getSize()) {
                this.listIterator_ = this.list_.listIterator(idx);
                this.currentIndex_ = idx;
            } else {
                if (idx > this.getSize()) {
                    throw new IteratorException("Index " + idx + " is greater than the number of elements in the list!");
                }
                if (idx == this.getSize()) {
                    this.lastIndex();
                }
            }
        } else {
            throw new IteratorException("List is empty: setIndex()");
        }
    }

    public void resetIndex() throws IteratorException {
        if (this.listIterator_ == null) {
            throw new IteratorException("List is empty: resetIndex()");
        }
        this.listIterator_ = this.list_.listIterator();
        this.currentIndex_ = this.listIterator_.nextIndex();
    }

    public void lastIndex() throws IteratorException {
        if (this.listIterator_ == null) {
            throw new IteratorException("List is empty: lastIndex()");
        }
        this.listIterator_ = this.list_.listIterator(this.getSize());
        this.currentIndex_ = this.listIterator_.nextIndex();
    }

    public boolean hasPrevious() throws IteratorException {
        if (this.listIterator_ != null) {
            return this.listIterator_.hasPrevious();
        }
        throw new IteratorException("List is empty: hasPrevious()");
    }

    public boolean hasNext() throws IteratorException {
        if (this.listIterator_ != null) {
            return this.listIterator_.hasNext();
        }
        throw new IteratorException("List is empty: hasNext()");
    }

    public int getNumberOfPages(int count) throws IteratorException {
        return (int)Math.ceil((double)this.getSize() / (double)count);
    }

    public int getNumberOfElements() throws IteratorException {
        return this.getSize();
    }
}

