/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.utils;

import at.tugraz.genome.dbutilities.EJBExceptionFactory;
import at.tugraz.genome.dbutilities.PKGeneratorFactory;
import at.tugraz.genome.dbutilities.exception.EJBCreateException;
import at.tugraz.genome.dbutilities.exception.EJBFinderException;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.dbutilities.exception.ForeignKeyException;
import at.tugraz.genome.dbutilities.exception.UniqueException;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.utils.GlobalConstants;
import at.tugraz.genome.marsejb.utils.ejb.Enum;
import at.tugraz.genome.marsejb.utils.ejb.EnumHome;
import at.tugraz.genome.marsejb.utils.vo.EnumVO;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class EnumSBBean
implements SessionBean {
    SessionContext sessionContext;

    public void ejbCreate() throws CreateException {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public Long addEnumEntry(EnumVO enumVO) throws UniqueException, EJBCreateException, ForeignKeyException, EJBServerException {
        Long pk = null;
        try {
            InitialContext ctx = new InitialContext();
            EnumHome enumHome = (EnumHome)ctx.lookup("java:comp/env/ejb/Enum");
            pk = PKGeneratorFactory.getPKGenerator(GlobalConstants.getDatabase()).getPrimaryKey("ENUM");
            try {
                enumVO.setPK(pk);
            }
            catch (ValidationException validExc) {
                validExc.printStackTrace();
            }
            Enum enum_ = enumHome.create(enumVO);
        }
        catch (NamingException namingExc) {
            namingExc.printStackTrace();
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), namingExc);
            pk = null;
        }
        catch (CreateException createExc) {
            createExc.printStackTrace();
            pk = null;
            EJBExceptionFactory.throwEJBCreateExceptions(GlobalConstants.getDatabase(), createExc);
        }
        return pk;
    }

    public Collection getEnumEntries(String tableName) throws EJBFinderException, EJBServerException {
        Vector<EnumVO> returnVector = new Vector<EnumVO>();
        try {
            InitialContext ctx = new InitialContext();
            EnumHome enumHome = (EnumHome)ctx.lookup("java:comp/env/ejb/Enum");
            Collection collection = enumHome.findByTableName(tableName);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Enum enum_ = (Enum)iterator.next();
                EnumVO enumVO = new EnumVO(enum_);
                returnVector.add(enumVO);
            }
        }
        catch (NamingException namingExc) {
            namingExc.printStackTrace();
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), namingExc);
        }
        catch (FinderException finderExc) {
            finderExc.printStackTrace();
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), finderExc);
        }
        return returnVector;
    }

    public Collection getEnumEntries(String tableName, String fieldName) throws EJBFinderException, EJBServerException {
        Vector<EnumVO> returnVector = new Vector<EnumVO>();
        try {
            InitialContext ctx = new InitialContext();
            EnumHome enumHome = (EnumHome)ctx.lookup("java:comp/env/ejb/Enum");
            Collection collection = enumHome.findByTableNameFieldName(tableName, fieldName);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Enum enum_ = (Enum)iterator.next();
                EnumVO enumVO = new EnumVO(enum_);
                returnVector.add(enumVO);
            }
        }
        catch (NamingException namingExc) {
            namingExc.printStackTrace();
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), namingExc);
        }
        catch (FinderException finderExc) {
            finderExc.printStackTrace();
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), finderExc);
        }
        return returnVector;
    }

    public EnumVO getEnumEntry(Long id) throws EJBFinderException, EJBServerException {
        EnumVO enumVO = null;
        try {
            InitialContext ctx = new InitialContext();
            EnumHome enumHome = (EnumHome)ctx.lookup("java:comp/env/ejb/Enum");
            Enum enumEO = enumHome.findByPrimaryKey(id);
            enumVO = new EnumVO(enumEO);
        }
        catch (NamingException namingExc) {
            namingExc.printStackTrace();
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), namingExc);
        }
        catch (FinderException finderExc) {
            finderExc.printStackTrace();
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), finderExc);
        }
        return enumVO;
    }

    public boolean deleteEnumEntry(Long id) throws EJBFinderException, EJBServerException {
        try {
            InitialContext ctx = new InitialContext();
            EnumHome enumHome = (EnumHome)ctx.lookup("java:comp/env/ejb/Enum");
            Enum enumEO = enumHome.findByPrimaryKey(id);
            if (!new Boolean(enumEO.getDeleteable()).booleanValue()) {
                return false;
            }
            enumEO.remove();
        }
        catch (NamingException namingExc) {
            namingExc.printStackTrace();
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), namingExc);
            return false;
        }
        catch (FinderException finderExc) {
            finderExc.printStackTrace();
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), finderExc);
            return false;
        }
        catch (RemoveException removeExc) {
            removeExc.printStackTrace();
            return false;
        }
        return true;
    }

    public void updateEnumEntry(EnumVO vo) throws EJBFinderException, EJBServerException {
        Object enumVO = null;
        try {
            InitialContext ctx = new InitialContext();
            EnumHome enumHome = (EnumHome)ctx.lookup("java:comp/env/ejb/Enum");
            Enum enumEO = enumHome.findByPrimaryKey(vo.getPK());
            enumEO.update(vo);
        }
        catch (NamingException namingExc) {
            namingExc.printStackTrace();
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), namingExc);
        }
        catch (FinderException finderExc) {
            finderExc.printStackTrace();
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), finderExc);
        }
    }
}

