/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.utils;

import at.tugraz.genome.dbutilities.EJBExceptionFactory;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.marsejb.utils.GlobalConstants;
import at.tugraz.genome.marsejb.utils.vo.SubmitterVO;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VO.UserVO;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnectionManager;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import org.apache.log4j.Logger;

public class UserSBBean
implements SessionBean {
    SessionContext sessionContext;
    HashMap submittersMap = new HashMap();
    long submittersMapTimestamp = System.currentTimeMillis();
    private static final long UPDATE_TIME_MS = 300000L;
    private static final long MAP_UPDATE_TIME_MS = 43200000L;
    private Logger log = Logger.getLogger(this.getClass());
    private static ServerConnection serverConnection = ServerConnectionManager.getInstance().getConnection();

    public void ejbCreate() throws CreateException, EJBServerException {
        this.log.info((Object)"UserSBBean create");
        try {
            this.log.debug((Object)("serverConnection " + serverConnection));
        }
        catch (Exception ex) {
            this.log.error((Object)"error: no server connection");
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public Long addSubmitter(SubmitterVO vo, String passwd, String loggedInUserName, String authenticationID, Collection toAdd, Collection toDel) throws UserSecurityException {
        this.log.info((Object)"addSubmitter");
        Long id = null;
        id = serverConnection.addUser((ExtendedUserVO)vo, GlobalConstants.MYAPPLICATIONNAME, "", passwd, authenticationID, loggedInUserName, GlobalConstants.MYAPPLICATIONKEY, true);
        this.setUserRights(vo.getName(), toAdd, toDel);
        return id;
    }

    public void setUserRights(String username, Collection toAdd, Collection toDel) {
        this.log.info((Object)"setUserrights");
        Iterator itAdd = toAdd.iterator();
        try {
            while (itAdd.hasNext()) {
                String add = (String)itAdd.next();
                serverConnection.addUserToGroup(username, add, GlobalConstants.MYAPPLICATIONNAME, GlobalConstants.MYAPPLICATIONKEY);
                this.log.debug((Object)("adding User to group     :" + add));
            }
            Iterator itDel = toDel.iterator();
            while (itDel.hasNext()) {
                String del = (String)itDel.next();
                serverConnection.removeUserFromGroup(username, del, GlobalConstants.MYAPPLICATIONNAME, GlobalConstants.MYAPPLICATIONKEY);
                this.log.debug((Object)("deleting User from group :" + del));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    public SubmitterVO getSubmitter(Long id) {
        SubmitterVO submitterVO;
        this.log.info((Object)("getSubmitter " + id));
        if (System.currentTimeMillis() - this.submittersMapTimestamp > 43200000L) {
            this.submittersMap.clear();
            this.submittersMapTimestamp = System.currentTimeMillis();
            this.log.debug((Object)("Cleared submittersMap size: " + this.submittersMap.size()));
        }
        if (this.submittersMap.containsKey(id)) {
            this.log.debug((Object)("taking Submitter " + id + "from cache"));
            submitterVO = (SubmitterVO)this.submittersMap.get(id);
            if (System.currentTimeMillis() - submitterVO.getAccessTime() > 300000L) {
                this.log.debug((Object)("updating submittersMap .... " + submitterVO.getId()));
                submitterVO = this.getFetchSubmitter(id);
                this.submittersMap.put(submitterVO.getId(), submitterVO);
            }
        } else {
            this.log.debug((Object)("Submitter is not in cache ... will fetch " + id));
            submitterVO = this.getFetchSubmitter(id);
            this.submittersMap.put(submitterVO.getId(), submitterVO);
        }
        this.log.debug((Object)("User is in groups :" + submitterVO.getGroups()));
        return submitterVO;
    }

    private SubmitterVO getFetchSubmitter(Long id) {
        this.log.debug((Object)("fetchSubmitter " + id));
        SubmitterVO submitterVO = null;
        try {
            ExtendedUserVO euVO = serverConnection.getUserByIDExtended(id, GlobalConstants.MYAPPLICATIONNAME, GlobalConstants.MYAPPLICATIONKEY);
            this.log.debug((Object)("fetched:" + euVO.getName() + " id :" + euVO.getID()));
            submitterVO = new SubmitterVO(euVO, System.currentTimeMillis());
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        return submitterVO;
    }

    public Collection getAllSubmitters() {
        this.log.info((Object)"getAllSubmitters");
        Vector collORG = null;
        Vector<SubmitterVO> collVO = new Vector<SubmitterVO>();
        try {
            this.submittersMap.clear();
            this.submittersMapTimestamp = System.currentTimeMillis();
            this.log.debug((Object)("serverConnection" + serverConnection));
            collORG = serverConnection.getExtendedUsersOfApplication(GlobalConstants.MYAPPLICATIONNAME, GlobalConstants.MYAPPLICATIONKEY);
            Iterator it = collORG.iterator();
            while (it.hasNext()) {
                ExtendedUserVO extdUserVO = (ExtendedUserVO)it.next();
                SubmitterVO submitterVO = new SubmitterVO(extdUserVO, System.currentTimeMillis());
                this.submittersMap.put(submitterVO.getId(), submitterVO);
                collVO.add(submitterVO);
            }
        }
        catch (UserSecurityException use) {
            this.log.error((Object)use.getMessage());
        }
        return collVO;
    }

    public void editSubmitter(SubmitterVO vo, String passwd, String loggedInUserName, String authenticationID, Collection toAdd, Collection toDel) throws UserSecurityException {
        this.log.info((Object)"editSubmitter");
        this.submittersMap.remove(vo.getId());
        this.log.debug((Object)("SubmitterVO id :" + vo.getId()));
        serverConnection.editUser((ExtendedUserVO)vo, authenticationID, loggedInUserName, GlobalConstants.MYAPPLICATIONNAME, GlobalConstants.MYAPPLICATIONKEY);
        this.setUserRights(vo.getName(), toAdd, toDel);
    }

    public boolean changePassword(String username, String authenticationID, String oldPasswd, String newPasswd) throws UserSecurityException {
        this.log.info((Object)"changePassword");
        this.log.debug((Object)("authenticationID" + authenticationID));
        return serverConnection.changePassword(username, "", authenticationID, newPasswd, oldPasswd, GlobalConstants.MYAPPLICATIONNAME, GlobalConstants.MYAPPLICATIONKEY);
    }

    public Long getIdByUserName(String userName) throws UserSecurityException {
        this.log.info((Object)"getIdByUserName");
        return serverConnection.getUserIDFromName(userName, GlobalConstants.MYAPPLICATIONNAME, GlobalConstants.MYAPPLICATIONKEY);
    }

    public Vector getIDsByUserNameLike(String userName) throws UserSecurityException {
        this.log.info((Object)"getIDsByUserNameLike");
        Vector userVOs = serverConnection.getUserVORegEx(userName, GlobalConstants.MYAPPLICATIONNAME, GlobalConstants.MYAPPLICATIONKEY);
        Vector<Long> returnVector = new Vector<Long>();
        Iterator it = ((AbstractList)userVOs).iterator();
        while (it.hasNext()) {
            UserVO userVO = (UserVO)it.next();
            returnVector.add(userVO.getID());
        }
        return returnVector;
    }
}

