/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.utils.sql;

import at.tugraz.genome.dbutilities.EJBExceptionFactory;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.marsejb.utils.GlobalConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class InsertShared {
    private PreparedStatement pStmtShared = null;
    private Logger log = null;
    private String tablename;
    private Connection conn = null;

    public InsertShared(String tablename) throws EJBServerException {
        this.tablename = tablename;
        this.log = Logger.getLogger(this.getClass());
        this.log.info((Object)("InsertShared" + tablename));
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("java:jdbc/DefaultDS");
            this.conn = ds.getConnection();
            String sql = "insert into shared" + tablename + " Values (?,?)";
            this.pStmtShared = this.conn.prepareStatement(sql);
        }
        catch (SQLException se) {
            this.log.error((Object)"Cannot connect to Database");
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), se.getMessage());
        }
        catch (NamingException ne) {
            this.log.error((Object)"Cannot connect to Database");
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ne);
        }
    }

    public void insert(Long id, Long userid) throws EJBServerException {
        long start = System.currentTimeMillis();
        this.log.info((Object)("insert " + this.tablename));
        try {
            this.pStmtShared.setLong(1, userid);
            this.pStmtShared.setLong(2, id);
            this.pStmtShared.executeUpdate();
            this.log.info((Object)("Time [ms]: " + (System.currentTimeMillis() - start)));
            this.log.info((Object)"... finished");
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1) {
                this.log.info((Object)"Object already exists!");
            }
            this.log.error((Object)e.getMessage());
            throw new EJBServerException("" + e);
        }
    }

    public void removeAll(Long id) throws EJBServerException {
        this.log.info((Object)("+++ removeAll shares from " + this.tablename + " with item " + id));
        String sqlStatement = "delete from shared" + this.tablename + " where (item = ?)";
        this.log.info((Object)("sql statement: " + sqlStatement));
        try {
            PreparedStatement pStmt = this.conn.prepareStatement(sqlStatement);
            pStmt.setLong(1, id);
            pStmt.executeUpdate();
            pStmt.close();
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            throw new EJBServerException(ex.getMessage());
        }
        this.log.info((Object)("--- removeAll shares from " + this.tablename + " with item " + id));
    }

    public void close() {
        try {
            if (this.pStmtShared != null) {
                this.pStmtShared.close();
            }
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

