/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.utils.vo;

import at.tugraz.genome.marsejb.clientconnector.vo.SubmitterDTO;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VO.UserVO;
import com.opensymphony.module.propertyset.ejb.types.VO.exception.PropertyException;
import java.io.Serializable;

public class SubmitterVO
extends ExtendedUserVO
implements Serializable {
    private long accesstime_;

    public SubmitterVO(ExtendedUserVO vo) {
        super(vo.getName());
        super.setData(vo);
    }

    public SubmitterVO(ExtendedUserVO vo, long accesstime) {
        this(vo);
        this.accesstime_ = accesstime;
    }

    public SubmitterVO(String userName, String fullname, String descr, String email, String address, String phone, String fax, Long activeuntil, String active, String changePswd) {
        super(userName);
        super.setFullname(fullname);
        this.setDescription(descr);
        this.setEmail(email);
        this.setAddress(address);
        this.setPhone(phone);
        this.setFax(fax);
        super.setHasToChangePassword(new Boolean(changePswd).booleanValue());
        super.setStartDate(new Long(System.currentTimeMillis()));
        super.setExpireDate(activeuntil);
    }

    public Long getId() {
        return ((UserVO)this).id_;
    }

    public long getAccessTime() {
        return this.accesstime_;
    }

    public String getAddress() {
        try {
            return super.getProperties().getString("address");
        }
        catch (PropertyException ex) {
            return null;
        }
    }

    public void setAddress(String address) {
        super.getProperties().setString("address", address);
    }

    public String getPhone() {
        try {
            return super.getProperties().getString("phone");
        }
        catch (PropertyException ex) {
            return null;
        }
    }

    public void setPhone(String data) {
        super.getProperties().setString("phone", data);
    }

    public String getFax() {
        try {
            return super.getProperties().getString("fax");
        }
        catch (PropertyException ex) {
            return null;
        }
    }

    public void setFax(String data) {
        super.getProperties().setString("fax", data);
    }

    public String getDescription() {
        try {
            return super.getProperties().getString("description");
        }
        catch (PropertyException ex) {
            return null;
        }
    }

    public void setDescription(String data) {
        super.getProperties().setString("description", data);
    }

    public SubmitterDTO createSubmitterDTO() {
        SubmitterDTO submitterDTO = new SubmitterDTO();
        submitterDTO.setAddress(this.getName());
        submitterDTO.setDescription(this.getDescription());
        submitterDTO.setEmail(this.getEmail());
        submitterDTO.setFax(this.getFax());
        submitterDTO.setFullname(this.getFullname());
        submitterDTO.setPhone(this.getPhone());
        submitterDTO.setUsername(this.getName());
        return submitterDTO;
    }
}

