/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.csvparser;

import at.tugraz.genome.tma.csvparser.BadDelimeterException;
import at.tugraz.genome.tma.csvparser.CSVLexer;
import at.tugraz.genome.tma.csvparser.CSVParse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;

public class CSVParser
implements CSVParse {
    private CSVLexer lexer;
    private String tokenCache;
    private int lineCache;
    private int lastLine = -1;

    public CSVParser(InputStream in) {
        this.lexer = new CSVLexer(in);
    }

    public CSVParser(Reader in) {
        this.lexer = new CSVLexer(in);
    }

    public CSVParser(InputStream in, String escapes, String replacements, String commentDelims) {
        this.lexer = new CSVLexer(in);
        this.setEscapes(escapes, replacements);
        this.setCommentStart(commentDelims);
    }

    public CSVParser(Reader in, String escapes, String replacements, String commentDelims) {
        this.lexer = new CSVLexer(in);
        this.setEscapes(escapes, replacements);
        this.setCommentStart(commentDelims);
    }

    public String nextValue() throws IOException {
        if (this.tokenCache == null) {
            this.tokenCache = this.lexer.getNextToken();
            this.lineCache = this.lexer.getLineNumber();
        }
        this.lastLine = this.lineCache;
        String result = this.tokenCache;
        this.tokenCache = null;
        return result;
    }

    public int lastLineNumber() {
        return this.lastLine;
    }

    public String[] getLine() throws IOException {
        int lineNumber = -1;
        Vector<String> v = new Vector<String>();
        if (this.tokenCache != null) {
            v.add(this.tokenCache);
            lineNumber = this.lineCache;
        }
        while ((this.tokenCache = this.lexer.getNextToken()) != null && (lineNumber == -1 || this.lexer.getLineNumber() == lineNumber)) {
            v.add(this.tokenCache);
            lineNumber = this.lexer.getLineNumber();
        }
        if (v.size() == 0) {
            return null;
        }
        this.lastLine = lineNumber;
        this.lineCache = this.lexer.getLineNumber();
        String[] result = new String[v.size()];
        return v.toArray(result);
    }

    public String[][] getAllValues() throws IOException {
        String[] line;
        Vector<String[]> v = new Vector<String[]>();
        while ((line = this.getLine()) != null) {
            v.add(line);
        }
        if (v.size() == 0) {
            return null;
        }
        String[][] result = new String[v.size()][];
        return (String[][])v.toArray((T[])result);
    }

    public void setEscapes(String escapes, String replacements) {
        this.lexer.setEscapes(escapes, replacements);
    }

    public void changeDelimiter(char newDelim) throws BadDelimeterException {
        this.lexer.changeDelimiter(newDelim);
    }

    public void setCommentStart(String commentDelims) {
        this.lexer.setCommentStart(commentDelims);
    }

    public int getLastLineNumber() {
        return this.lastLine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void main(String[] args) {
        try {
            String[] t;
            InputStream in;
            if (args.length > 0) {
                File f = new File(args[0]);
                if (!f.exists()) throw new IOException("Could not find " + args[0]);
                if (!f.canRead()) throw new IOException("Could not open " + args[0]);
                in = new FileInputStream(f);
            } else {
                in = System.in;
            }
            CSVParser p = new CSVParser(in);
            p.setCommentStart("#;!");
            p.setEscapes("nrtf", "\n\r\t\f");
            while ((t = p.getLine()) != null) {
                for (int i = 0; i < t.length; ++i) {
                    System.out.print('\"' + t[i] + '\"');
                    if (i >= t.length - 1) continue;
                    System.out.print(", ");
                }
                System.out.println();
            }
            return;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static String[][] parse(String s) {
        try {
            return new CSVParser(new StringReader(s)).getAllValues();
        }
        catch (IOException x) {
            return null;
        }
    }

    public static String[][] parse(String s, String escapes, String replacements, String commentDelims) {
        try {
            return new CSVParser(new StringReader(s), escapes, replacements, commentDelims).getAllValues();
        }
        catch (IOException x) {
            return null;
        }
    }

    public static String[][] parse(Reader in) throws IOException {
        return new CSVParser(in).getAllValues();
    }

    public static String[][] parse(Reader in, String escapes, String replacements, String commentDelims) throws IOException {
        return new CSVParser(in, escapes, replacements, commentDelims).getAllValues();
    }
}

