/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.entity;

import at.tugraz.genome.dbutilities.DummyPKGeneratorFactory;
import at.tugraz.genome.tma.ejb.entity.Algorithm;
import at.tugraz.genome.tma.ejb.entity.Result;
import at.tugraz.genome.tma.ejb.entity.ResultLocalHome;
import at.tugraz.genome.tma.ejb.entity.ResultUtil;
import at.tugraz.genome.tma.ejb.vos.AlgorithmVO;
import at.tugraz.genome.tma.ejb.vos.ResultVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AlgorithmBean
implements EntityBean {
    Log log = LogFactory.getLog(this.getClass());
    private EntityContext context;

    public abstract Long getAlgorithmId();

    public abstract void setAlgorithmId(Long var1);

    public abstract String getAlgorithmname();

    public abstract void setAlgorithmname(String var1);

    public abstract Collection getResults();

    public abstract void setResults(Collection var1);

    public AlgorithmVO getValueObject() {
        AlgorithmVO result = new AlgorithmVO(this.getAlgorithmId(), this.getAlgorithmname());
        this.log.debug("getValueObject: returned AlgorithmVO=" + result);
        return result;
    }

    public void updateCMP(AlgorithmVO value) throws FinderException, NamingException, CreateException {
        this.log.debug("updateCMP: begin value=" + value);
        this.log.debug("update:  algorithmname=" + value.getAlgorithmname());
        this.setAlgorithmname(value.getAlgorithmname());
    }

    public void update(AlgorithmVO value) throws FinderException, NamingException, CreateException {
        this.log.debug("update: begin value=" + value);
        this.log.debug("update:  algorithmname=" + value.getAlgorithmname());
        this.setAlgorithmname(value.getAlgorithmname());
        this.setResultVOs(value.getResults());
    }

    public Long ejbCreate(String algorithmname) throws CreateException {
        this.log.debug("ejbCreate: algorithmname=" + algorithmname);
        this.setAlgorithmname(algorithmname);
        Long primaryKey = (Long)this.getPrimaryKey("Algorithm", "java.lang.Long");
        this.setAlgorithmId(primaryKey);
        this.log.debug("ejbCreate: finished successfuly new primaryKey=" + primaryKey);
        return null;
    }

    public void ejbPostCreate(String algorithmname) throws CreateException {
    }

    public Long ejbCreate(AlgorithmVO data) throws CreateException {
        this.log.info("ejbCreate(data): begin data=" + data);
        this.log.debug("ejbCreate(data): data.getAlgorithmname()=" + data.getAlgorithmname());
        this.setAlgorithmname(data.getAlgorithmname());
        Long primaryKey = data.getPrimaryKey() == null ? (Long)this.getPrimaryKey("Algorithm", "java.lang.Long") : data.getPrimaryKey();
        this.setAlgorithmId(primaryKey);
        this.log.debug("ejbCreate(data): finished successfuly new primaryKey=" + primaryKey);
        return null;
    }

    public void ejbPostCreate(AlgorithmVO data) throws CreateException {
        this.log.debug("ejbPostCreate(data): begin data=" + data);
        data.setAlgorithmId((Long)this.context.getPrimaryKey());
        try {
            this.setResultVOs(data.getResults());
        }
        catch (NamingException namExc) {
            this.log.error("ejbPostCreate(data): NamingException thrown");
            this.log.error(namExc);
            throw new CreateException(namExc.getMessage());
        }
        catch (FinderException findExc) {
            this.log.error("ejbPostCreate(data): NamingException thrown");
            this.log.error((Object)findExc);
            throw new CreateException(findExc.getMessage());
        }
        catch (EJBException ejbExc) {
            this.log.error("ejbPostCreate(data): EJBException thrown");
            this.log.error((Object)ejbExc);
            throw new CreateException(ejbExc.getMessage());
        }
    }

    public void setResultVOs(Collection Results) throws FinderException, NamingException, CreateException {
        this.log.debug("setResultVOs: begin");
        if (Results == null) {
            this.log.info("setResultVOs: Results is NULL");
            this.setResults(null);
        } else {
            this.log.debug("begin setResultVOs(Results) Results.size=" + Results.size());
            ArrayList<Result> col = new ArrayList<Result>();
            Iterator iter = Results.iterator();
            while (iter.hasNext()) {
                Result ResultRef;
                ResultVO someVO = (ResultVO)iter.next();
                Long id = someVO.getResultId();
                ResultLocalHome ResultLH = ResultUtil.getLocalHome();
                if (id != null && !id.toString().equals("")) {
                    this.log.debug("setResultVOs: find by primKey: id=" + id);
                    ResultRef = ResultLH.findByPrimaryKey(id);
                    ResultRef.setAlgorithm((Algorithm)this.context.getEJBLocalObject());
                } else {
                    this.log.debug("setResultVOs: create new entity.");
                    ResultRef = ResultLH.create(someVO);
                    ResultRef.setAlgorithm((Algorithm)this.context.getEJBLocalObject());
                }
                col.add(ResultRef);
            }
            this.setResults(col);
        }
    }

    private Object getPrimaryKey(String className, String type) {
        Object primaryKey = new Object();
        if (type.equalsIgnoreCase("java.lang.Long")) {
            primaryKey = DummyPKGeneratorFactory.getPKGenerator("THESERVERSIDEGUID").getPrimaryKey(className);
        } else {
            System.out.println("This Type of PKGenerator must be implemented");
        }
        return primaryKey;
    }

    public void setEntityContext(EntityContext ctx) {
        this.context = ctx;
    }

    public void unsetEntityContext() {
        this.context = null;
    }
}

