/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.entity;

import at.tugraz.genome.dbutilities.DummyPKGeneratorFactory;
import at.tugraz.genome.tma.ejb.entity.Behaviour;
import at.tugraz.genome.tma.ejb.entity.Tissue;
import at.tugraz.genome.tma.ejb.entity.TissueLocalHome;
import at.tugraz.genome.tma.ejb.entity.TissueUtil;
import at.tugraz.genome.tma.ejb.vos.BehaviourVO;
import at.tugraz.genome.tma.ejb.vos.TissueVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BehaviourBean
implements EntityBean {
    Log log = LogFactory.getLog(this.getClass());
    private EntityContext context;

    public abstract Long getBehaviourId();

    public abstract void setBehaviourId(Long var1);

    public abstract String getBehaviour();

    public abstract void setBehaviour(String var1);

    public abstract Collection getTissues();

    public abstract void setTissues(Collection var1);

    public BehaviourVO getValueObject() {
        BehaviourVO result = new BehaviourVO(this.getBehaviourId(), this.getBehaviour());
        this.log.debug("getValueObject: returned BehaviourVO=" + result);
        return result;
    }

    public void updateCMP(BehaviourVO value) throws FinderException, NamingException, CreateException {
        this.log.debug("updateCMP: begin value=" + value);
        this.log.debug("update:  behaviour=" + value.getBehaviour());
        this.setBehaviour(value.getBehaviour());
    }

    public void update(BehaviourVO value) throws FinderException, NamingException, CreateException {
        this.log.debug("update: begin value=" + value);
        this.log.debug("update:  behaviour=" + value.getBehaviour());
        this.setBehaviour(value.getBehaviour());
        this.setTissueVOs(value.getTissues());
    }

    public Long ejbCreate(String behaviour) throws CreateException {
        this.log.debug("ejbCreate: behaviour=" + behaviour);
        this.setBehaviour(behaviour);
        Long primaryKey = (Long)this.getPrimaryKey("Behaviour", "java.lang.Long");
        this.setBehaviourId(primaryKey);
        this.log.debug("ejbCreate: finished successfuly new primaryKey=" + primaryKey);
        return null;
    }

    public void ejbPostCreate(String behaviour) throws CreateException {
    }

    public Long ejbCreate(BehaviourVO data) throws CreateException {
        this.log.info("ejbCreate(data): begin data=" + data);
        this.log.debug("ejbCreate(data): data.getBehaviour()=" + data.getBehaviour());
        this.setBehaviour(data.getBehaviour());
        Long primaryKey = data.getPrimaryKey() == null ? (Long)this.getPrimaryKey("Behaviour", "java.lang.Long") : data.getPrimaryKey();
        this.setBehaviourId(primaryKey);
        this.log.debug("ejbCreate(data): finished successfuly new primaryKey=" + primaryKey);
        return null;
    }

    public void ejbPostCreate(BehaviourVO data) throws CreateException {
        this.log.debug("ejbPostCreate(data): begin data=" + data);
        data.setBehaviourId((Long)this.context.getPrimaryKey());
        try {
            this.setTissueVOs(data.getTissues());
        }
        catch (NamingException namExc) {
            this.log.error("ejbPostCreate(data): NamingException thrown");
            this.log.error(namExc);
            throw new CreateException(namExc.getMessage());
        }
        catch (FinderException findExc) {
            this.log.error("ejbPostCreate(data): NamingException thrown");
            this.log.error((Object)findExc);
            throw new CreateException(findExc.getMessage());
        }
        catch (EJBException ejbExc) {
            this.log.error("ejbPostCreate(data): EJBException thrown");
            this.log.error((Object)ejbExc);
            throw new CreateException(ejbExc.getMessage());
        }
    }

    public void setTissueVOs(Collection Tissues) throws FinderException, NamingException, CreateException {
        this.log.debug("setTissueVOs: begin");
        if (Tissues == null) {
            this.log.info("setTissueVOs: Tissues is NULL");
            this.setTissues(null);
        } else {
            this.log.debug("begin setTissueVOs(Tissues) Tissues.size=" + Tissues.size());
            ArrayList<Tissue> col = new ArrayList<Tissue>();
            Iterator iter = Tissues.iterator();
            while (iter.hasNext()) {
                Tissue TissueRef;
                TissueVO someVO = (TissueVO)iter.next();
                Long id = someVO.getTissueId();
                TissueLocalHome TissueLH = TissueUtil.getLocalHome();
                if (id != null && !id.toString().equals("")) {
                    this.log.debug("setTissueVOs: find by primKey: id=" + id);
                    TissueRef = TissueLH.findByPrimaryKey(id);
                    TissueRef.setBehaviour((Behaviour)this.context.getEJBLocalObject());
                } else {
                    this.log.debug("setTissueVOs: create new entity.");
                    TissueRef = TissueLH.create(someVO);
                    TissueRef.setBehaviour((Behaviour)this.context.getEJBLocalObject());
                }
                col.add(TissueRef);
            }
            this.setTissues(col);
        }
    }

    private Object getPrimaryKey(String className, String type) {
        Object primaryKey = new Object();
        if (type.equalsIgnoreCase("java.lang.Long")) {
            primaryKey = DummyPKGeneratorFactory.getPKGenerator("THESERVERSIDEGUID").getPrimaryKey(className);
        } else {
            System.out.println("This Type of PKGenerator must be implemented");
        }
        return primaryKey;
    }

    public void setEntityContext(EntityContext ctx) {
        this.context = ctx;
    }

    public void unsetEntityContext() {
        this.context = null;
    }
}

