/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.report;

import at.tugraz.genome.dbutilities.ConnectionManager;
import at.tugraz.genome.dbutilities.DatabaseTableField;
import at.tugraz.genome.dbutilities.GenericDAOFactory;
import at.tugraz.genome.dbutilities.SearchableField;
import at.tugraz.genome.dbutilities.exception.IteratorException;
import at.tugraz.genome.tma.GlobalConstants;
import at.tugraz.genome.tma.ejb.entity.Donor;
import at.tugraz.genome.tma.ejb.entity.DonorUtil;
import at.tugraz.genome.tma.ejb.report.DonorReportServiceBean;
import at.tugraz.genome.tma.ejb.vos.DonorReportVO;
import at.tugraz.genome.tma.ejb.vos.DonorVO;
import at.tugraz.genome.usermUtilities.remote.UsermUtilitiesBusinessInterface;
import at.tugraz.genome.usermUtilities.remote.UsermUtilitiesServiceFactory;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class DonorReportServiceBeanImpl
extends DonorReportServiceBean
implements SessionBean {
    SessionContext sessionContext;
    private transient Logger log_ = Logger.getLogger(this.getClass());
    private UsermUtilitiesBusinessInterface usermUtilitiesInterface = null;
    private SearchableField arrayblockQuery = null;

    public void ejbRemove() {
        this.log_.info((Object)"ejbRemove");
    }

    public void ejbActivate() {
        this.log_ = Logger.getLogger(this.getClass());
        this.genericDAO_ = GenericDAOFactory.getDAOFactory("at.tugraz.genome.dbutilities.dao.MysqlDAOFactory").getDAO();
        this.log_.info((Object)("list: " + this.list_));
        this.log_.info((Object)("currentIndex: " + this.currentIndex_));
        if (this.list_ != null) {
            this.listIterator_ = this.list_.listIterator(this.currentIndex_);
        } else {
            this.list_ = new LinkedList();
            this.listIterator_ = this.list_.listIterator();
        }
        this.log_.info((Object)"ejbActivate()");
    }

    public void ejbPassivate() {
        this.log_.info((Object)"ejbPassivate()");
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void executeQuery(Collection searchCriteria, Long id, DatabaseTableField orderBy, String direction) {
        this.log_.info((Object)"executeSearch");
        try {
            List resultList = null;
            Vector searchcriteria = null;
            this.log_.info((Object)("searchCriteria: " + searchCriteria));
            searchcriteria = searchCriteria == null ? new Vector() : new Vector(searchCriteria);
            Iterator it = searchcriteria.iterator();
            while (it.hasNext()) {
                SearchableField combinedField;
                SearchableField field = (SearchableField)it.next();
                if (field.getDBFieldName().equalsIgnoreCase("EnteredBy")) {
                    int i;
                    String correctedSearchValue;
                    String searchValue = this.parseSearchValue(field);
                    System.out.println("searchValue: " + searchValue);
                    String[] newSearchValues = searchValue.split(",");
                    this.log_.info((Object)("field.getOperator: " + field.getOperator()));
                    if (!field.getOperator().equalsIgnoreCase("like")) {
                        this.log_.info((Object)("operator: " + field.getOperator()));
                        correctedSearchValue = "";
                        for (i = 0; i < newSearchValues.length; ++i) {
                            System.out.println("newSerchValues[i]: " + newSearchValues[i]);
                            Long submitterID = null;
                            submitterID = this.usermUtilitiesInterface.getIdByUserName(newSearchValues[i]);
                            if (submitterID == null) continue;
                            correctedSearchValue = i < newSearchValues.length - 1 ? correctedSearchValue + submitterID.toString() + "," : correctedSearchValue + submitterID.toString();
                        }
                        field.setSearchValue(correctedSearchValue);
                    } else {
                        this.log_.info((Object)("LIKE operator: " + field.getOperator()));
                        correctedSearchValue = "";
                        for (i = 0; i < newSearchValues.length; ++i) {
                            System.out.println("newSerchValues[i]: " + newSearchValues[i]);
                            Vector submitterIDs = this.usermUtilitiesInterface.getIDsByUserNameLike(newSearchValues[i]);
                            for (int j = 0; j < submitterIDs.size(); ++j) {
                                correctedSearchValue = j < submitterIDs.size() - 1 ? correctedSearchValue + submitterIDs.elementAt(j).toString() + "," : correctedSearchValue + submitterIDs.elementAt(j).toString();
                            }
                            if (i >= newSearchValues.length - 1) continue;
                            correctedSearchValue = correctedSearchValue + ",";
                        }
                        field.setSearchValue(correctedSearchValue);
                    }
                }
                if (field.getDBFieldName().equalsIgnoreCase("Topography")) {
                    DatabaseTableField topoField = new DatabaseTableField("tissues", "TopographyID", "", true, "Topography", "topography", "TopographyID", "Topography");
                    combinedField = new SearchableField(topoField, field.getOperator(), field.getSearchValue());
                    field.setDBTableName("donor");
                    field.setDBFieldName("TissueID");
                    field.setFakeDBTableField("TissueID");
                    field.setFakeTableName("tissues");
                    field.setFakeTableConnectorFieldName("TissueID");
                    field.setFake(true);
                    field.setSearchValue(null);
                    field.addANDCombinedField(combinedField);
                }
                if (!field.getDBFieldName().equalsIgnoreCase("Morphology")) continue;
                DatabaseTableField morphField = new DatabaseTableField("tissues", "MorphologyID", "", true, "Morphology", "morphology", "MorphologyID", "Morphology");
                combinedField = new SearchableField(morphField, field.getOperator(), field.getSearchValue());
                field.setDBTableName("donor");
                field.setDBFieldName("TissueID");
                field.setFakeDBTableField("TissueID");
                field.setFakeTableName("tissues");
                field.setFakeTableConnectorFieldName("TissueID");
                field.setFake(true);
                field.setSearchValue(null);
                field.addANDCombinedField(combinedField);
            }
            if (orderBy != null) {
                if (orderBy.getDBFieldName().equalsIgnoreCase("Topography")) {
                    orderBy.setDBFieldName("TissueID");
                    orderBy.setFake(true);
                    orderBy.setFakeTableName("tissues");
                    orderBy.setFakeTableConnectorFieldName("TissueID");
                    orderBy.setFakeOrderByField("TopographyID");
                }
                if (orderBy.getDBFieldName().equalsIgnoreCase("Morphology")) {
                    orderBy.setDBFieldName("TissueID");
                    orderBy.setFake(true);
                    orderBy.setFakeTableName("tissues");
                    orderBy.setFakeTableConnectorFieldName("TissueID");
                    orderBy.setFakeOrderByField("MorphologyID");
                }
            }
            resultList = searchcriteria == null || searchcriteria.size() == 0 ? this.genericDAO_.selectAll("donor", "DonorID", orderBy, direction) : this.genericDAO_.selectCustom("donor", "DonorID", searchcriteria, orderBy, direction);
            this.setList(new LinkedList(resultList));
        }
        catch (Exception e) {
            this.log_.error((Object)e);
        }
    }

    public void setArrayblockDonorIdList(Collection Donors) {
        try {
            Vector donors = new Vector(Donors);
            LinkedList<Long> donorIdList = new LinkedList<Long>();
            Iterator it = donors.iterator();
            while (it.hasNext()) {
                DonorVO donorVO = (DonorVO)it.next();
                donorIdList.add(donorVO.getDonorId());
            }
            this.setList(donorIdList);
        }
        catch (Exception e) {
            this.log_.error((Object)e);
        }
    }

    public void setArrayblockQuery(Long arraybolckId) {
        SearchableField query;
        DatabaseTableField dbField = new DatabaseTableField("donor", "DonorID", "ArrayblockID", true, "THE_ARRAYBLOCK_FK", "Donorarrayassosiation", "THE_DONOR_FK", "THE_DONOR_FK");
        this.arrayblockQuery = query = new SearchableField(dbField, "=", arraybolckId.toString());
    }

    public SearchableField getArrayblockQuery() {
        return this.arrayblockQuery;
    }

    public Object getCurrentElement() throws IteratorException {
        Long id = (Long)super.getCurrentElement();
        Donor entity = null;
        try {
            entity = DonorUtil.getLocalHome().findByPrimaryKey(id);
            DonorVO donorVO = (DonorVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree("Tissue,Tissue.Topography,Tissue.Morphology,DatadictionaryPerson,Arrayblocks"));
            donorVO.setUserVO(this.usermUtilitiesInterface.getSubmitter(donorVO.getUserid()));
            DonorReportVO returnVO = new DonorReportVO(donorVO);
            return returnVO;
        }
        catch (FinderException fex) {
            this.log.error("findDonorById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
        }
        catch (NamingException nex) {
            this.log.error("findDonorById(id=" + id + "): NamingException thrown");
            throw new IteratorException(nex.getMessage());
        }
        catch (UserSecurityException usx) {
            this.log.error("getSubmitterById: UserSecurityException thrown");
            this.log.error((Object)usx);
        }
        return null;
    }

    public void executeQuery(Collection searchCriteria, Long id, DatabaseTableField orderBy) {
        this.executeQuery(searchCriteria, id, orderBy, null);
    }

    public void executeQuery(Collection searchCriteria, Long id) {
        DatabaseTableField orderBy = this.getDatabaseTableField("BarcodeId");
        this.executeQuery(searchCriteria, id, orderBy, null);
    }

    public List getElements(List idList) {
        ArrayList<DonorReportVO> arrayList = new ArrayList<DonorReportVO>();
        Donor entity = null;
        try {
            Iterator iterator = idList.iterator();
            while (iterator.hasNext()) {
                Long id = (Long)iterator.next();
                entity = DonorUtil.getLocalHome().findByPrimaryKey(id);
                DonorVO donorVO = (DonorVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree("Tissue,Tissue.Topography,Tissue.Morphology,DatadictionaryPerson,Arrayblocks"));
                donorVO.setUserVO(this.usermUtilitiesInterface.getSubmitter(donorVO.getUserid()));
                DonorReportVO returnVO = new DonorReportVO(donorVO);
                arrayList.add(returnVO);
            }
        }
        catch (FinderException fex) {
            this.log.error("findDonorById(id=" + this.id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findDonorById(id=" + this.id + "): NamingException thrown");
            this.log.error(nex);
        }
        catch (UserSecurityException usx) {
            this.log.error("getSubmitterById: UserSecurityException thrown");
            this.log.error((Object)usx);
        }
        return arrayList;
    }

    public Collection getOperators() {
        return GlobalConstants.getSearchOperators();
    }

    public Collection getSearchableFields() {
        Vector<DatabaseTableField> dbFields = new Vector<DatabaseTableField>();
        DatabaseTableField dbField = null;
        dbField = new DatabaseTableField("donor", "Date", "Date", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("donor", "EnteredBy", "Entered by", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("donor", "BarcodeID", "BarcodeId", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("donor", "Corecomment", "Corecomment", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("donor", "PersonID", "Person", true, "Datavalue", "datadictionary", "DataID", "Datavalue");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("donor", "TissueID", "SampleId", true, "SampleID", "tissues", "TissueID", "SampleID");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("donor", "Topography", "Topography", false);
        dbField.addAdditionalTable("tissues");
        dbField.addAdditionalTable("topography");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("donor", "Morphology", "Morphology", false);
        dbField.addAdditionalTable("tissues");
        dbField.addAdditionalTable("morphology");
        dbFields.add(dbField);
        return dbFields;
    }

    public void setValueObjectParameters(Collection parameters) {
    }

    private String parseSearchValue(SearchableField field) {
        String retValue = "";
        if (field.getOperator().equalsIgnoreCase("between") || field.getOperator().equalsIgnoreCase("not between")) {
            String searchValue = field.getSearchValue();
            searchValue = searchValue.trim();
            Pattern pattern = Pattern.compile("([a-zA-Z_0-9\\s]+),([a-zA-Z_0-9\\s]+)");
            Matcher matcher = pattern.matcher(searchValue);
            if (matcher.matches()) {
                System.out.println("MATCH BETWEEN");
                String value1 = matcher.group(1).trim();
                String value2 = matcher.group(2).trim();
                retValue = value1 + "," + value2;
            }
        } else if (field.getOperator().equalsIgnoreCase("in") || field.getOperator().equalsIgnoreCase("not in")) {
            Pattern pattern;
            Matcher matcher;
            String searchValue = field.getSearchValue();
            if (!(searchValue = searchValue.trim()).endsWith(",")) {
                searchValue = searchValue + ",";
            }
            if ((matcher = (pattern = Pattern.compile("([a-zA-Z_0-9\\s]{1,},){1,}")).matcher(searchValue)).matches()) {
                System.out.println("MATCH IN");
                retValue = field.getSearchValue();
            }
        } else {
            retValue = field.getSearchValue();
        }
        return retValue;
    }

    public void ejbCreate() throws CreateException {
        this.genericDAO_ = GenericDAOFactory.getDAOFactory("at.tugraz.genome.dbutilities.dao.MysqlDAOFactory").getDAO();
        try {
            this.usermUtilitiesInterface = UsermUtilitiesServiceFactory.getInstance(ConnectionManager.getInstance().getJNDIProperties());
        }
        catch (Exception e) {
            this.log_.error((Object)e);
        }
    }
}

